/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cli;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.DictionaryProvider;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGeneratorCLI {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGeneratorCLI.class);

    public static void processSegment(KylinConfig config, String cubeName, String segmentID, DistinctColumnValuesProvider factTableValueProvider, DictionaryProvider dictProvider) throws IOException {
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        CubeSegment segment = cube.getSegmentById(segmentID);
        DictionaryGeneratorCLI.processSegment(config, segment, factTableValueProvider, dictProvider);
    }

    private static void processSegment(KylinConfig config, CubeSegment cubeSeg, DistinctColumnValuesProvider factTableValueProvider, DictionaryProvider dictProvider) throws IOException {
        CubeManager cubeMgr = CubeManager.getInstance(config);
        for (TblColRef col : cubeSeg.getCubeDesc().getAllColumnsNeedDictionaryBuilt()) {
            logger.info("Building dictionary for " + col);
            IReadableTable inpTable = DictionaryGeneratorCLI.decideInputTable(cubeSeg.getModel(), col, factTableValueProvider);
            if (dictProvider != null) {
                Dictionary<String> dict = dictProvider.getDictionary(col);
                if (dict != null) {
                    logger.debug("Dict for '" + col.getName() + "' has already been built, save it");
                    cubeMgr.saveDictionary(cubeSeg, col, inpTable, dict);
                    continue;
                }
                logger.debug("Dict for '" + col.getName() + "' not pre-built, build it from " + inpTable.toString());
                cubeMgr.buildDictionary(cubeSeg, col, inpTable);
                continue;
            }
            logger.debug("Dict for '" + col.getName() + "' not pre-built, build it from " + inpTable.toString());
            cubeMgr.buildDictionary(cubeSeg, col, inpTable);
        }
        HashSet toSnapshot = Sets.newHashSet();
        HashSet toCheckLookup = Sets.newHashSet();
        for (DimensionDesc dim : cubeSeg.getCubeDesc().getDimensions()) {
            TableRef table = dim.getTableRef();
            if (!cubeSeg.getModel().isLookupTable(table)) continue;
            toSnapshot.add(table.getTableIdentity());
            toCheckLookup.add(table);
        }
        for (String tableIdentity : toSnapshot) {
            logger.info("Building snapshot of " + tableIdentity);
            cubeMgr.buildSnapshotTable(cubeSeg, tableIdentity);
        }
        for (TableRef lookup : toCheckLookup) {
            logger.info("Checking snapshot of " + lookup);
            JoinDesc join = cubeSeg.getModel().getJoinsTree().getJoinByPKSide(lookup);
            cubeMgr.getLookupTable(cubeSeg, join);
        }
    }

    private static IReadableTable decideInputTable(DataModelDesc model, TblColRef col, DistinctColumnValuesProvider factTableValueProvider) {
        IReadableTable inpTable;
        KylinConfig config = model.getConfig();
        DictionaryManager dictMgr = DictionaryManager.getInstance(config);
        TblColRef srcCol = dictMgr.decideSourceData(model, col);
        String srcTable = srcCol.getTable();
        if (model.isFactTable(srcTable)) {
            inpTable = factTableValueProvider.getDistinctValuesFor(srcCol);
        } else {
            MetadataManager metadataManager = MetadataManager.getInstance(config);
            TableDesc tableDesc = new TableDesc(metadataManager.getTableDesc(srcTable));
            inpTable = SourceFactory.createReadableTable(tableDesc);
        }
        return inpTable;
    }
}

