/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeSignatureRefresher {
    private static final Logger logger = LoggerFactory.getLogger(CubeSignatureRefresher.class);
    private KylinConfig config = null;
    private ResourceStore store;
    private String[] cubeNames;
    private List<String> updatedResources = Lists.newArrayList();
    private List<String> errorMsgs = Lists.newArrayList();

    public CubeSignatureRefresher(String[] cubes) {
        this.config = KylinConfig.getInstanceFromEnv();
        this.store = ResourceStore.getStore(this.config);
        this.cubeNames = cubes;
    }

    public void update() {
        ArrayList cubeDescs;
        logger.info("Reloading Cube Metadata from store: " + this.store.getReadableResourcePath("/cube_desc"));
        CubeDescManager cubeDescManager = CubeDescManager.getInstance(this.config);
        if (ArrayUtils.isEmpty((Object[])this.cubeNames)) {
            cubeDescs = cubeDescManager.listAllDesc();
        } else {
            Object[] names = this.cubeNames[0].split(",");
            if (ArrayUtils.isEmpty((Object[])names)) {
                return;
            }
            cubeDescs = Lists.newArrayListWithCapacity((int)names.length);
            for (Object name : names) {
                cubeDescs.add(cubeDescManager.getCubeDesc((String)name));
            }
        }
        for (CubeDesc cubeDesc : cubeDescs) {
            this.updateCubeDesc(cubeDesc);
        }
        this.verify();
    }

    private void verify() {
        MetadataManager.getInstance(this.config).reload();
        CubeDescManager.clearCache();
        CubeDescManager.getInstance(this.config);
        CubeManager.getInstance(this.config);
        ProjectManager.getInstance(this.config);
    }

    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    private void updateCubeDesc(CubeDesc cubeDesc) {
        try {
            String calculatedSign = cubeDesc.calculateSignature();
            if (cubeDesc.getSignature() == null || !cubeDesc.getSignature().equals(calculatedSign)) {
                cubeDesc.setSignature(calculatedSign);
                this.store.putResource(cubeDesc.getResourcePath(), cubeDesc, CubeDescManager.CUBE_DESC_SERIALIZER);
                this.updatedResources.add(cubeDesc.getResourcePath());
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            this.errorMsgs.add("Update CubeDesc[" + cubeDesc.getName() + "] failed: " + e.getLocalizedMessage());
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length > 1) {
            System.out.println("Usage: java CubeSignatureRefresher [Cubes]; e.g, cube1,cube2 ");
            return;
        }
        CubeSignatureRefresher metadataUpgrade = new CubeSignatureRefresher(args);
        metadataUpgrade.update();
        logger.info("=================================================================");
        logger.info("Run CubeSignatureRefresher completed;");
        if (!metadataUpgrade.updatedResources.isEmpty()) {
            logger.info("Following resources are updated successfully:");
            for (String s : metadataUpgrade.updatedResources) {
                logger.info(s);
            }
        } else {
            logger.warn("No resource updated.");
        }
        if (!metadataUpgrade.errorMsgs.isEmpty()) {
            logger.info("Here are the error/warning messages, you may need to check:");
            for (String s : metadataUpgrade.errorMsgs) {
                logger.warn(s);
            }
        } else {
            logger.info("No error or warning messages; The update succeeds.");
        }
        logger.info("=================================================================");
    }
}

