/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.CubeValidator;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.SourcePartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeManager
implements IRealizationProvider {
    private static String ALPHA_NUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static int HBASE_TABLE_LENGTH = 10;
    public static final Serializer<CubeInstance> CUBE_SERIALIZER = new JsonSerializer<CubeInstance>(CubeInstance.class);
    private static final Logger logger = LoggerFactory.getLogger(CubeManager.class);
    private static final ConcurrentMap<KylinConfig, CubeManager> CACHE = new ConcurrentHashMap<KylinConfig, CubeManager>();
    private KylinConfig config;
    private CaseInsensitiveStringCache<CubeInstance> cubeMap;
    private ConcurrentMap<String, String> usedStorageLocation = new ConcurrentHashMap<String, String>();
    private CubeChangeListener listener;
    private final String GLOBAL_DICTIONNARY_CLASS = "org.apache.kylin.dict.GlobalDictionaryBuilder";

    public static CubeManager getInstance(KylinConfig config) {
        CubeManager r = (CubeManager)CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<CubeManager> clazz = CubeManager.class;
        synchronized (CubeManager.class) {
            r = (CubeManager)CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new CubeManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                    for (KylinConfig kylinConfig : CACHE.keySet()) {
                        logger.warn("type: " + kylinConfig.getClass() + " reference: " + System.identityHashCode(kylinConfig.base()));
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init CubeManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static void clearCache(KylinConfig kylinConfig) {
        if (kylinConfig != null) {
            CACHE.remove(kylinConfig);
        }
    }

    private CubeManager(KylinConfig config) throws IOException {
        logger.info("Initializing CubeManager with config " + config);
        this.config = config;
        this.cubeMap = new CaseInsensitiveStringCache(config, "cube");
        this.loadAllCubeInstance();
        Broadcaster.getInstance(config).registerListener(new CubeSyncListener(), "cube");
    }

    public List<CubeInstance> listAllCubes() {
        return new ArrayList<CubeInstance>(this.cubeMap.values());
    }

    public CubeInstance getCube(String cubeName) {
        cubeName = cubeName.toUpperCase();
        return (CubeInstance)this.cubeMap.get(cubeName);
    }

    public CubeInstance getCubeByUuid(String uuid) {
        ArrayList copy = new ArrayList(this.cubeMap.values());
        for (CubeInstance cube : copy) {
            if (!uuid.equals(cube.getUuid())) continue;
            return cube;
        }
        return null;
    }

    public List<CubeInstance> getCubesByDesc(String descName) {
        descName = descName.toUpperCase();
        List<CubeInstance> list = this.listAllCubes();
        ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
        for (CubeInstance ci : list) {
            if (!descName.equalsIgnoreCase(ci.getDescName())) continue;
            result.add(ci);
        }
        return result;
    }

    public DictionaryInfo buildDictionary(CubeSegment cubeSeg, TblColRef col, IReadableTable inpTable) throws IOException {
        CubeDesc cubeDesc = cubeSeg.getCubeDesc();
        if (!cubeDesc.getAllColumnsNeedDictionaryBuilt().contains(col)) {
            return null;
        }
        String builderClass = cubeDesc.getDictionaryBuilderClass(col);
        DictionaryInfo dictInfo = this.getDictionaryManager().buildDictionary(cubeDesc.getModel(), col, inpTable, builderClass);
        this.saveDictionaryInfo(cubeSeg, col, dictInfo);
        return dictInfo;
    }

    public DictionaryInfo saveDictionary(CubeSegment cubeSeg, TblColRef col, IReadableTable inpTable, Dictionary<String> dict) throws IOException {
        CubeDesc cubeDesc = cubeSeg.getCubeDesc();
        if (!cubeDesc.getAllColumnsNeedDictionaryBuilt().contains(col)) {
            return null;
        }
        DictionaryInfo dictInfo = this.getDictionaryManager().saveDictionary(cubeDesc.getModel(), col, inpTable, dict);
        this.saveDictionaryInfo(cubeSeg, col, dictInfo);
        return dictInfo;
    }

    private void saveDictionaryInfo(CubeSegment cubeSeg, TblColRef col, DictionaryInfo dictInfo) throws IOException {
        if (dictInfo != null) {
            Dictionary<String> dict = dictInfo.getDictionaryObject();
            cubeSeg.putDictResPath(col, dictInfo.getResourcePath());
            cubeSeg.getRowkeyStats().add(new Object[]{col.getIdentity(), dict.getSize(), dict.getSizeOfId()});
            CubeUpdate update = new CubeUpdate(cubeSeg.getCubeInstance());
            update.setToUpdateSegs(cubeSeg);
            this.updateCube(update);
        }
    }

    public Dictionary<String> getDictionary(CubeSegment cubeSeg, TblColRef col) {
        DictionaryInfo info = null;
        try {
            DictionaryManager dictMgr = this.getDictionaryManager();
            String dictResPath = cubeSeg.getDictResPath(col);
            if (dictResPath == null) {
                return null;
            }
            info = dictMgr.getDictionaryInfo(dictResPath);
            if (info == null) {
                throw new IllegalStateException("No dictionary found by " + dictResPath + ", invalid cube state; cube segment" + cubeSeg + ", col " + col);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get dictionary for cube segment" + cubeSeg + ", col" + col, e);
        }
        return info.getDictionaryObject();
    }

    public SnapshotTable buildSnapshotTable(CubeSegment cubeSeg, String lookupTable) throws IOException {
        MetadataManager metaMgr = this.getMetadataManager();
        SnapshotManager snapshotMgr = this.getSnapshotManager();
        TableDesc tableDesc = new TableDesc(metaMgr.getTableDesc(lookupTable));
        IReadableTable hiveTable = SourceFactory.createReadableTable(tableDesc);
        SnapshotTable snapshot = snapshotMgr.buildSnapshot(hiveTable, tableDesc);
        cubeSeg.putSnapshotResPath(lookupTable, snapshot.getResourcePath());
        CubeUpdate cubeBuilder = new CubeUpdate(cubeSeg.getCubeInstance());
        cubeBuilder.setToUpdateSegs(cubeSeg);
        this.updateCube(cubeBuilder);
        return snapshot;
    }

    public CubeInstance dropCube(String cubeName, boolean deleteDesc) throws IOException {
        logger.info("Dropping cube '" + cubeName + "'");
        CubeInstance cube = this.getCube(cubeName);
        if (deleteDesc && cube.getDescriptor() != null) {
            CubeDescManager.getInstance(this.config).removeCubeDesc(cube.getDescriptor());
        }
        this.getStore().deleteResource(cube.getResourcePath());
        this.cubeMap.remove(cube.getName());
        ProjectManager.getInstance(this.config).removeRealizationsFromProjects(RealizationType.CUBE, cubeName);
        if (this.listener != null) {
            this.listener.afterCubeDelete(cube);
        }
        return cube;
    }

    public CubeInstance createCube(String cubeName, String projectName, CubeDesc desc, String owner) throws IOException {
        logger.info("Creating cube '" + projectName + "-->" + cubeName + "' from desc '" + desc.getName() + "'");
        CubeInstance cube = CubeInstance.create(cubeName, desc);
        cube.setOwner(owner);
        this.updateCubeWithRetry(new CubeUpdate(cube), 0);
        ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.CUBE, cubeName, projectName, owner);
        if (this.listener != null) {
            this.listener.afterCubeCreate(cube);
        }
        return cube;
    }

    public CubeInstance createCube(CubeInstance cube, String projectName, String owner) throws IOException {
        logger.info("Creating cube '" + projectName + "-->" + cube.getName() + "' from instance object. '");
        cube.setOwner(owner);
        this.updateCubeWithRetry(new CubeUpdate(cube), 0);
        ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.CUBE, cube.getName(), projectName, owner);
        if (this.listener != null) {
            this.listener.afterCubeCreate(cube);
        }
        return cube;
    }

    public CubeInstance updateCube(CubeUpdate update) throws IOException {
        CubeInstance cube = this.updateCubeWithRetry(update, 0);
        if (this.listener != null) {
            this.listener.afterCubeUpdate(cube);
        }
        return cube;
    }

    private CubeInstance updateCubeWithRetry(CubeUpdate update, int retry) throws IOException {
        if (update == null || update.getCubeInstance() == null) {
            throw new IllegalStateException();
        }
        CubeInstance cube = update.getCubeInstance();
        logger.info("Updating cube instance '" + cube.getName() + "'");
        Segments newSegs = (Segments)cube.getSegments().clone();
        if (update.getToAddSegs() != null) {
            newSegs.addAll(Arrays.asList(update.getToAddSegs()));
        }
        ArrayList toRemoveResources = Lists.newArrayList();
        if (update.getToRemoveSegs() != null) {
            Iterator iterator = newSegs.iterator();
            block4: while (iterator.hasNext()) {
                CubeSegment currentSeg = (CubeSegment)iterator.next();
                for (CubeSegment toRemoveSeg : update.getToRemoveSegs()) {
                    if (!currentSeg.getUuid().equals(toRemoveSeg.getUuid())) continue;
                    logger.info("Remove segment " + currentSeg.toString());
                    toRemoveResources.add(currentSeg.getStatisticsResourcePath());
                    iterator.remove();
                    continue block4;
                }
            }
        }
        if (update.getToUpdateSegs() != null) {
            block6: for (CubeSegment segment : update.getToUpdateSegs()) {
                for (int i = 0; i < newSegs.size(); ++i) {
                    if (!((CubeSegment)newSegs.get(i)).getUuid().equals(segment.getUuid())) continue;
                    newSegs.set(i, segment);
                    continue block6;
                }
            }
        }
        Collections.sort(newSegs);
        CubeValidator.validate(newSegs);
        cube.setSegments(newSegs);
        if (update.getStatus() != null) {
            cube.setStatus(update.getStatus());
        }
        if (update.getOwner() != null) {
            cube.setOwner(update.getOwner());
        }
        if (update.getCost() > 0) {
            cube.setCost(update.getCost());
        }
        try {
            this.getStore().putResource(cube.getResourcePath(), cube, CUBE_SERIALIZER);
        }
        catch (IllegalStateException ise) {
            logger.warn("Write conflict to update cube " + cube.getName() + " at try " + retry + ", will retry...");
            if (retry >= 7) {
                logger.error("Retried 7 times till got error, abandoning...", (Throwable)ise);
                throw ise;
            }
            cube = this.reloadCubeLocal(cube.getName());
            update.setCubeInstance(cube);
            cube = this.updateCubeWithRetry(update, ++retry);
        }
        if (toRemoveResources.size() > 0) {
            for (String resource : toRemoveResources) {
                try {
                    this.getStore().deleteResource(resource);
                }
                catch (IOException ioe) {
                    logger.error("Failed to delete resource " + ((Object)toRemoveResources).toString());
                }
            }
        }
        this.cubeMap.put(cube.getName(), cube);
        ProjectManager.getInstance(cube.getConfig()).clearL2Cache();
        return cube;
    }

    public CubeSegment appendSegment(CubeInstance cube) throws IOException {
        return this.appendSegment(cube, 0L, Long.MAX_VALUE, 0L, 0L, null, null);
    }

    public CubeSegment appendSegment(CubeInstance cube, long startDate, long endDate) throws IOException {
        return this.appendSegment(cube, startDate, endDate, 0L, 0L, null, null);
    }

    public CubeSegment appendSegment(CubeInstance cube, SourcePartition sourcePartition) throws IOException {
        return this.appendSegment(cube, sourcePartition.getStartDate(), sourcePartition.getEndDate(), sourcePartition.getStartOffset(), sourcePartition.getEndOffset(), sourcePartition.getSourcePartitionOffsetStart(), sourcePartition.getSourcePartitionOffsetEnd());
    }

    CubeSegment appendSegment(CubeInstance cube, long startDate, long endDate, long startOffset, long endOffset, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd) throws IOException {
        this.checkBuildingSegment(cube);
        if (cube.getModel().getPartitionDesc().isPartitioned()) {
            if (startDate == 0L && startOffset == 0L && cube.getLastSegment() != null) {
                CubeSegment last = cube.getLastSegment();
                startDate = last.isSourceOffsetsOn() ? 0L : last.getDateRangeEnd();
                startOffset = last.isSourceOffsetsOn() ? last.getSourceOffsetEnd() : 0L;
            }
        } else {
            endOffset = 0L;
            startOffset = 0L;
            startDate = 0L;
            endDate = Long.MAX_VALUE;
        }
        CubeSegment newSegment = this.newSegment(cube, startDate, endDate, startOffset, endOffset);
        newSegment.setSourcePartitionOffsetStart(sourcePartitionOffsetStart);
        newSegment.setSourcePartitionOffsetEnd(sourcePartitionOffsetEnd);
        this.validateNewSegments(cube, newSegment);
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToAddSegs(newSegment);
        this.updateCube(cubeBuilder);
        return newSegment;
    }

    public CubeSegment refreshSegment(CubeInstance cube, long startDate, long endDate, long startOffset, long endOffset) throws IOException {
        this.checkBuildingSegment(cube);
        CubeSegment newSegment = this.newSegment(cube, startDate, endDate, startOffset, endOffset);
        Pair<Boolean, Boolean> pair = CubeValidator.fitInSegments(cube.getSegments(), newSegment);
        if (!pair.getFirst().booleanValue() || !pair.getSecond().booleanValue()) {
            throw new IllegalArgumentException("The new refreshing segment " + newSegment + " does not match any existing segment in cube " + cube);
        }
        if (startOffset > 0L || endOffset > 0L) {
            CubeSegment toRefreshSeg = null;
            for (CubeSegment cubeSegment : cube.getSegments()) {
                if (cubeSegment.getSourceOffsetStart() != startOffset || cubeSegment.getSourceOffsetEnd() != endOffset) continue;
                toRefreshSeg = cubeSegment;
                break;
            }
            if (toRefreshSeg == null) {
                throw new IllegalArgumentException("For streaming cube, only one segment can be refreshed at one time");
            }
            newSegment.setSourcePartitionOffsetStart(toRefreshSeg.getSourcePartitionOffsetStart());
            newSegment.setSourcePartitionOffsetEnd(toRefreshSeg.getSourcePartitionOffsetEnd());
        }
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToAddSegs(newSegment);
        this.updateCube(cubeBuilder);
        return newSegment;
    }

    public CubeSegment mergeSegments(CubeInstance cube, long startDate, long endDate, long startOffset, long endOffset, boolean force) throws IOException {
        if (cube.getSegments().isEmpty()) {
            throw new IllegalArgumentException("Cube " + cube + " has no segments");
        }
        if (startDate >= endDate && startOffset >= endOffset) {
            throw new IllegalArgumentException("Invalid merge range");
        }
        this.checkBuildingSegment(cube);
        this.checkCubeIsPartitioned(cube);
        boolean isOffsetsOn = ((CubeSegment)cube.getSegments().get(0)).isSourceOffsetsOn();
        if (isOffsetsOn) {
            if (startOffset == endOffset) {
                Pair<CubeSegment, CubeSegment> pair = cube.getSegments(SegmentStatusEnum.READY).findMergeOffsetsByDateRange(startDate, endDate, Long.MAX_VALUE);
                if (pair == null) {
                    throw new IllegalArgumentException("Find no segments to merge by date range " + startDate + "-" + endDate + " for cube " + cube);
                }
                startOffset = pair.getFirst().getSourceOffsetStart();
                endOffset = pair.getSecond().getSourceOffsetEnd();
            }
            startDate = 0L;
            endDate = 0L;
        } else {
            if (startDate == endDate) {
                startDate = startOffset;
                endDate = endOffset;
            }
            startOffset = 0L;
            endOffset = 0L;
        }
        CubeSegment newSegment = this.newSegment(cube, startDate, endDate, startOffset, endOffset);
        List<CubeSegment> mergingSegments = cube.getMergingSegments(newSegment);
        if (mergingSegments.size() <= 1) {
            throw new IllegalArgumentException("Range " + newSegment.getSourceOffsetStart() + "-" + newSegment.getSourceOffsetEnd() + " must contain at least 2 segments, but there is " + mergingSegments.size());
        }
        CubeSegment first = mergingSegments.get(0);
        CubeSegment last = mergingSegments.get(mergingSegments.size() - 1);
        if (newSegment.isSourceOffsetsOn()) {
            newSegment.setDateRangeStart(CubeManager.minDateRangeStart(mergingSegments));
            newSegment.setDateRangeEnd(CubeManager.maxDateRangeEnd(mergingSegments));
            newSegment.setSourceOffsetStart(first.getSourceOffsetStart());
            newSegment.setSourceOffsetEnd(last.getSourceOffsetEnd());
            newSegment.setSourcePartitionOffsetStart(first.getSourcePartitionOffsetStart());
            newSegment.setSourcePartitionOffsetEnd(last.getSourcePartitionOffsetEnd());
        } else {
            newSegment.setDateRangeStart(first.getSourceOffsetStart());
            newSegment.setDateRangeEnd(last.getSourceOffsetEnd());
        }
        if (!force) {
            ArrayList emptySegment = Lists.newArrayList();
            for (CubeSegment seg : mergingSegments) {
                if (seg.getSizeKB() != 0L) continue;
                emptySegment.add(seg.getName());
            }
            if (emptySegment.size() > 0) {
                throw new IllegalArgumentException("Empty cube segment found, couldn't merge unless 'forceMergeEmptySegment' set to true: " + emptySegment);
            }
        }
        this.validateNewSegments(cube, newSegment);
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToAddSegs(newSegment);
        this.updateCube(cubeBuilder);
        return newSegment;
    }

    public static long minDateRangeStart(List<CubeSegment> mergingSegments) {
        long min = Long.MAX_VALUE;
        for (CubeSegment seg : mergingSegments) {
            min = Math.min(min, seg.getDateRangeStart());
        }
        return min;
    }

    public static long maxDateRangeEnd(List<CubeSegment> mergingSegments) {
        long max = Long.MIN_VALUE;
        for (CubeSegment seg : mergingSegments) {
            max = Math.max(max, seg.getDateRangeEnd());
        }
        return max;
    }

    public CubeSegment getLatestSegment(CubeInstance cube) {
        Segments<CubeSegment> existing = cube.getSegments();
        if (existing.isEmpty()) {
            return null;
        }
        return (CubeSegment)existing.get(existing.size() - 1);
    }

    private void checkBuildingSegment(CubeInstance cube) {
        int maxBuldingSeg = cube.getConfig().getMaxBuildingSegments();
        if (cube.getBuildingSegments().size() >= maxBuldingSeg) {
            throw new IllegalStateException("There is already " + cube.getBuildingSegments().size() + " building segment; ");
        }
    }

    private void checkCubeIsPartitioned(CubeInstance cube) {
        if (!cube.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
            throw new IllegalStateException("there is no partition date column specified, only full build is supported");
        }
    }

    public CubeInstance reloadCubeLocal(String cubeName) {
        return this.reloadCubeLocalAt(CubeInstance.concatResourcePath(cubeName));
    }

    public void removeCubeLocal(String cubeName) {
        CubeInstance cube = (CubeInstance)this.cubeMap.get(cubeName);
        if (cube != null) {
            for (CubeSegment segment : cube.getSegments()) {
                this.usedStorageLocation.remove(segment.getUuid());
            }
        }
        this.cubeMap.removeLocal(cubeName);
    }

    public LookupStringTable getLookupTable(CubeSegment cubeSegment, JoinDesc join) {
        String tableName = join.getPKSide().getTableIdentity();
        String[] pkCols = join.getPrimaryKey();
        String snapshotResPath = cubeSegment.getSnapshotResPath(tableName);
        if (snapshotResPath == null) {
            throw new IllegalStateException("No snapshot for table '" + tableName + "' found on cube segment" + cubeSegment.getCubeInstance().getName() + "/" + cubeSegment);
        }
        try {
            SnapshotTable snapshot = this.getSnapshotManager().getSnapshotTable(snapshotResPath);
            TableDesc tableDesc = this.getMetadataManager().getTableDesc(tableName);
            return new LookupStringTable(tableDesc, pkCols, snapshot);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load lookup table " + tableName + " from snapshot " + snapshotResPath, e);
        }
    }

    private CubeSegment newSegment(CubeInstance cube, long startDate, long endDate, long startOffset, long endOffset) {
        CubeSegment segment = new CubeSegment();
        segment.setUuid(UUID.randomUUID().toString());
        segment.setName(CubeSegment.makeSegmentName(startDate, endDate, startOffset, endOffset));
        segment.setCreateTimeUTC(System.currentTimeMillis());
        segment.setDateRangeStart(startDate);
        segment.setDateRangeEnd(endDate);
        segment.setSourceOffsetStart(startOffset);
        segment.setSourceOffsetEnd(endOffset);
        segment.setStatus(SegmentStatusEnum.NEW);
        segment.setStorageLocationIdentifier(this.generateStorageLocation());
        segment.setCubeInstance(cube);
        segment.validate();
        return segment;
    }

    private String generateStorageLocation() {
        StringBuffer sb;
        String namePrefix = "KYLIN_";
        String tableName = "";
        Random ran = new Random();
        do {
            sb = new StringBuffer();
            sb.append(namePrefix);
            for (int i = 0; i < HBASE_TABLE_LENGTH; ++i) {
                sb.append(ALPHA_NUM.charAt(ran.nextInt(ALPHA_NUM.length())));
            }
        } while (this.usedStorageLocation.containsValue(tableName = sb.toString()));
        return tableName;
    }

    public Pair<Long, Long> autoMergeCubeSegments(CubeInstance cube) throws IOException {
        return cube.autoMergeCubeSegments();
    }

    public void promoteNewlyBuiltSegments(CubeInstance cube, CubeSegment newSegment) throws IOException {
        Segments tobe;
        if (StringUtils.isBlank((CharSequence)newSegment.getStorageLocationIdentifier())) {
            throw new IllegalStateException("For cube " + cube + ", segment " + newSegment + " missing StorageLocationIdentifier");
        }
        if (StringUtils.isBlank((CharSequence)newSegment.getLastBuildJobID())) {
            throw new IllegalStateException("For cube " + cube + ", segment " + newSegment + " missing LastBuildJobID");
        }
        if (this.isReady(newSegment)) {
            logger.warn("For cube " + cube + ", segment " + newSegment + " state should be NEW but is READY");
        }
        if (!(tobe = cube.calculateToBeSegments(newSegment)).contains(newSegment)) {
            throw new IllegalStateException("For cube " + cube + ", segment " + newSegment + " is expected but not in the tobe " + tobe);
        }
        newSegment.setStatus(SegmentStatusEnum.READY);
        ArrayList toRemoveSegs = Lists.newArrayList();
        for (CubeSegment segment : cube.getSegments()) {
            if (tobe.contains(segment)) continue;
            toRemoveSegs.add(segment);
        }
        logger.info("Promoting cube " + cube + ", new segment " + newSegment + ", to remove segments " + toRemoveSegs);
        CubeUpdate cubeBuilder = new CubeUpdate(cube);
        cubeBuilder.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[toRemoveSegs.size()])).setToUpdateSegs(newSegment).setStatus(RealizationStatusEnum.READY);
        this.updateCube(cubeBuilder);
    }

    public void validateNewSegments(CubeInstance cube, CubeSegment newSegments) {
        Segments tobe = cube.calculateToBeSegments(newSegments);
        List<CubeSegment> newList = Arrays.asList(newSegments);
        if (!tobe.containsAll(newList)) {
            throw new IllegalStateException("For cube " + cube + ", the new segments " + newList + " do not fit in its current " + cube.getSegments() + "; the resulted tobe is " + tobe);
        }
    }

    private boolean isReady(CubeSegment seg) {
        return seg.getStatus() == SegmentStatusEnum.READY;
    }

    private void loadAllCubeInstance() throws IOException {
        ResourceStore store = this.getStore();
        List<String> paths = store.collectResourceRecursively("/cube", ".json");
        logger.info("Loading Cube from folder " + store.getReadableResourcePath("/cube"));
        int succeed = 0;
        int fail = 0;
        for (String path : paths) {
            CubeInstance cube = this.reloadCubeLocalAt(path);
            if (cube == null) {
                ++fail;
                continue;
            }
            ++succeed;
        }
        logger.info("Loaded " + succeed + " cubes, fail on " + fail + " cubes");
    }

    private CubeInstance reloadCubeLocalAt(String path) {
        ResourceStore store = this.getStore();
        try {
            CubeInstance cube = store.getResource(path, CubeInstance.class, CUBE_SERIALIZER);
            Preconditions.checkNotNull((Object)cube, (String)"cube (at %s) not found", (Object[])new Object[]{path});
            String cubeName = cube.getName();
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)cubeName), (String)"cube (at %s) name must not be blank", (Object[])new Object[]{path});
            CubeDesc cubeDesc = CubeDescManager.getInstance(this.config).getCubeDesc(cube.getDescName());
            Preconditions.checkNotNull((Object)cubeDesc, (String)"cube descriptor '%s' (for cube '%s') not found", (Object[])new Object[]{cube.getDescName(), cubeName});
            if (!this.isSpecialTestCube(cubeName)) {
                Preconditions.checkState((boolean)cubeDesc.getName().equals(cubeName), (String)"cube name '%s' must be same as descriptor name '%s', but it is not", (Object[])new Object[]{cubeName, cubeDesc.getName()});
            }
            if (!cubeDesc.getError().isEmpty()) {
                cube.setStatus(RealizationStatusEnum.DESCBROKEN);
                logger.error("cube descriptor {} (for cube '{}') is broken", (Object)cubeDesc.getResourcePath(), (Object)cubeName);
                for (String error : cubeDesc.getError()) {
                    logger.error("Error: {}", (Object)error);
                }
            } else if (cube.getStatus() == RealizationStatusEnum.DESCBROKEN) {
                cube.setStatus(RealizationStatusEnum.DISABLED);
                logger.info("cube {} changed from DESCBROKEN to DISABLED", (Object)cubeName);
            }
            cube.setConfig((KylinConfigExt)cubeDesc.getConfig());
            this.cubeMap.putLocal(cubeName, cube);
            for (CubeSegment segment : cube.getSegments()) {
                this.usedStorageLocation.put(segment.getUuid(), segment.getStorageLocationIdentifier());
            }
            logger.info("Reloaded cube {} being {} having {} segments", new Object[]{cubeName, cube, cube.getSegments().size()});
            return cube;
        }
        catch (Exception e) {
            logger.error("Error during load cube instance, skipping : " + path, (Throwable)e);
            return null;
        }
    }

    private boolean isSpecialTestCube(String cubeName) {
        return cubeName.equals("kylin_sales_cube") || this.config.isDevEnv() && (cubeName.startsWith("test_kylin_cube") || cubeName.startsWith("test_streaming"));
    }

    private MetadataManager getMetadataManager() {
        return MetadataManager.getInstance(this.config);
    }

    private DictionaryManager getDictionaryManager() {
        return DictionaryManager.getInstance(this.config);
    }

    private SnapshotManager getSnapshotManager() {
        return SnapshotManager.getInstance(this.config);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    @Override
    public RealizationType getRealizationType() {
        return RealizationType.CUBE;
    }

    @Override
    public IRealization getRealization(String name) {
        return this.getCube(name);
    }

    public void setCubeChangeListener(CubeChangeListener listener) {
        this.listener = listener;
    }

    public List<TblColRef> getAllDictColumnsOnFact(CubeDesc cubeDesc) throws IOException {
        ArrayList<TblColRef> factDictCols = new ArrayList<TblColRef>();
        DictionaryManager dictMgr = DictionaryManager.getInstance(this.config);
        for (TblColRef col : cubeDesc.getAllColumnsNeedDictionaryBuilt()) {
            String scanTable = dictMgr.decideSourceData(cubeDesc.getModel(), col).getTable();
            if (!cubeDesc.getModel().isFactTable(scanTable)) continue;
            factDictCols.add(col);
        }
        return factDictCols;
    }

    public List<CubeSegment> calculateHoles(String cubeName) {
        ArrayList holes = Lists.newArrayList();
        CubeInstance cube = this.getCube(cubeName);
        Preconditions.checkNotNull((Object)cube);
        Segments<CubeSegment> segments = cube.getSegments();
        logger.info("totally " + segments.size() + " cubeSegments");
        if (segments.size() == 0) {
            return holes;
        }
        Collections.sort(segments);
        boolean isOffsetOn = ((CubeSegment)segments.get(0)).isSourceOffsetsOn();
        for (int i = 0; i < segments.size() - 1; ++i) {
            CubeSegment first = (CubeSegment)segments.get(i);
            CubeSegment second = (CubeSegment)segments.get(i + 1);
            if (first.getSourceOffsetEnd() == second.getSourceOffsetStart() || first.getSourceOffsetEnd() >= second.getSourceOffsetStart()) continue;
            CubeSegment hole = new CubeSegment();
            if (isOffsetOn) {
                hole.setSourceOffsetStart(first.getSourceOffsetEnd());
                hole.setSourcePartitionOffsetStart(first.getSourcePartitionOffsetEnd());
                hole.setSourceOffsetEnd(second.getSourceOffsetStart());
                hole.setSourcePartitionOffsetEnd(second.getSourcePartitionOffsetStart());
            } else {
                hole.setDateRangeStart(first.getDateRangeEnd());
                hole.setDateRangeEnd(second.getDateRangeStart());
            }
            hole.setName(CubeSegment.makeSegmentName(hole.getDateRangeStart(), hole.getDateRangeEnd(), hole.getSourceOffsetStart(), hole.getSourceOffsetEnd()));
            holes.add(hole);
        }
        return holes;
    }

    public int[] getUHCIndex(CubeDesc cubeDesc) throws IOException {
        List<TblColRef> factDictCols = this.getAllDictColumnsOnFact(cubeDesc);
        int[] uhcIndex = new int[factDictCols.size()];
        List<DictionaryDesc> dictionaryDescList = cubeDesc.getDictionaries();
        if (dictionaryDescList != null) {
            block0: for (DictionaryDesc dictionaryDesc : dictionaryDescList) {
                if (dictionaryDesc.getBuilderClass() == null || !dictionaryDesc.getBuilderClass().equalsIgnoreCase("org.apache.kylin.dict.GlobalDictionaryBuilder")) continue;
                for (int i = 0; i < factDictCols.size(); ++i) {
                    if (!factDictCols.get(i).equals(dictionaryDesc.getColumnRef())) continue;
                    uhcIndex[i] = 1;
                    continue block0;
                }
            }
        }
        Set<TblColRef> shardByColumns = cubeDesc.getShardByColumns();
        for (int i = 0; i < factDictCols.size(); ++i) {
            if (!shardByColumns.contains(factDictCols.get(i))) continue;
            uhcIndex[i] = 1;
        }
        return uhcIndex;
    }

    public static interface CubeChangeListener {
        public void afterCubeCreate(CubeInstance var1);

        public void afterCubeUpdate(CubeInstance var1);

        public void afterCubeDelete(CubeInstance var1);
    }

    private class CubeSyncListener
    extends Broadcaster.Listener {
        private CubeSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CubeManager.clearCache();
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            for (IRealization real : ProjectManager.getInstance(CubeManager.this.config).listAllRealizations(project)) {
                if (!(real instanceof CubeInstance)) continue;
                CubeManager.this.reloadCubeLocal(real.getName());
            }
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String cubeName = cacheKey;
            if (event == Broadcaster.Event.DROP) {
                CubeManager.this.removeCubeLocal(cubeName);
            } else {
                CubeManager.this.reloadCubeLocal(cubeName);
            }
            for (ProjectInstance prj : ProjectManager.getInstance(CubeManager.this.config).findProjects(RealizationType.CUBE, cubeName)) {
                broadcaster.notifyProjectDataUpdate(prj.getName());
            }
        }
    }
}

