/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeCapabilityChecker;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metadata.realization.SQLDigest;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeInstance
extends RootPersistentEntity
implements IRealization,
IBuildable {
    public static final int COST_WEIGHT_MEASURE = 1;
    public static final int COST_WEIGHT_DIMENSION = 10;
    public static final int COST_WEIGHT_INNER_JOIN = 100;
    @JsonIgnore
    private KylinConfigExt config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="descriptor")
    private String descName;
    @JsonProperty(value="cost")
    private int cost = 50;
    @JsonProperty(value="status")
    private RealizationStatusEnum status;
    @JsonManagedReference
    @JsonProperty(value="segments")
    private Segments<CubeSegment> segments = new Segments();
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;

    public static CubeInstance create(String cubeName, CubeDesc cubeDesc) {
        CubeInstance cubeInstance = new CubeInstance();
        cubeInstance.setConfig((KylinConfigExt)cubeDesc.getConfig());
        cubeInstance.setName(cubeName);
        cubeInstance.setDescName(cubeDesc.getName());
        cubeInstance.setCreateTimeUTC(System.currentTimeMillis());
        cubeInstance.setSegments(new Segments());
        cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
        cubeInstance.updateRandomUuid();
        return cubeInstance;
    }

    public List<CubeSegment> getBuildingSegments() {
        return this.segments.getBuildingSegments();
    }

    public List<CubeSegment> getMergingSegments(CubeSegment mergedSegment) {
        return this.segments.getMergingSegments(mergedSegment);
    }

    public CubeDesc getDescriptor() {
        return CubeDescManager.getInstance(this.config).getCubeDesc(this.descName);
    }

    @Override
    public DataModelDesc getModel() {
        CubeDesc cubeDesc = this.getDescriptor();
        if (cubeDesc != null) {
            return cubeDesc.getModel();
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.getStatus() == RealizationStatusEnum.READY;
    }

    public boolean allowBrokenDescriptor() {
        return (this.getStatus() == RealizationStatusEnum.DISABLED || this.getStatus() == RealizationStatusEnum.DESCBROKEN) && this.segments.isEmpty();
    }

    public String getResourcePath() {
        return CubeInstance.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String cubeName) {
        return "/cube/" + cubeName + ".json";
    }

    public String toString() {
        return this.getCanonicalName();
    }

    @JsonProperty(value="size_kb")
    public long getSizeKB() {
        long sizeKb = 0L;
        for (CubeSegment cubeSegment : this.getSegments(SegmentStatusEnum.READY)) {
            sizeKb += cubeSegment.getSizeKB();
        }
        return sizeKb;
    }

    @JsonProperty(value="input_records_count")
    public long getInputRecordCount() {
        long sizeRecordCount = 0L;
        for (CubeSegment cubeSegment : this.getSegments(SegmentStatusEnum.READY)) {
            sizeRecordCount += cubeSegment.getInputRecords();
        }
        return sizeRecordCount;
    }

    @JsonProperty(value="input_records_size")
    public long getInputRecordSize() {
        long sizeRecordSize = 0L;
        for (CubeSegment cubeSegment : this.getSegments(SegmentStatusEnum.READY)) {
            sizeRecordSize += cubeSegment.getInputRecordsSize();
        }
        return sizeRecordSize;
    }

    @Override
    public KylinConfig getConfig() {
        return this.config;
    }

    void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public String getRootFactTable() {
        return this.getModel().getRootFactTable().getTableIdentity();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCanonicalName() {
        return (Object)((Object)this.getType()) + "[name=" + this.name + "]";
    }

    @Override
    public List<MeasureDesc> getMeasures() {
        return this.getDescriptor().getMeasures();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDescName() {
        return this.descName;
    }

    public void setDescName(String descName) {
        this.descName = descName;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public RealizationStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(RealizationStatusEnum status) {
        this.status = status;
    }

    public CubeSegment getFirstSegment() {
        return this.segments.getFirstSegment();
    }

    public CubeSegment getLatestReadySegment() {
        return this.segments.getLatestReadySegment();
    }

    public CubeSegment getLatestBuiltSegment() {
        return this.segments.getLatestBuiltSegment();
    }

    public Segments<CubeSegment> getSegments() {
        return this.segments;
    }

    public Segments<CubeSegment> getSegments(SegmentStatusEnum status) {
        return this.segments.getSegments(status);
    }

    public CubeSegment getSegment(String name, SegmentStatusEnum status) {
        return this.segments.getSegment(name, status);
    }

    public void setSegments(Segments segments) {
        this.segments = segments;
    }

    public CubeSegment getSegmentById(String segmentId) {
        for (CubeSegment segment : this.segments) {
            if (!Objects.equal((Object)segment.getUuid(), (Object)segmentId)) continue;
            return segment;
        }
        return null;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    @Override
    public CapabilityResult isCapable(SQLDigest digest) {
        CapabilityResult result = CubeCapabilityChecker.check(this, digest);
        if (result.capable) {
            result.cost = this.getCost(digest);
            for (CapabilityResult.CapabilityInfluence i : result.influences) {
                result.cost = (int)((double)result.cost * (i.suggestCostMultiplier() == 0.0 ? 1.0 : i.suggestCostMultiplier()));
            }
        } else {
            result.cost = -1;
        }
        return result;
    }

    public int getCost(SQLDigest digest) {
        int calculatedCost = this.cost;
        calculatedCost += this.getRowKeyColumnCount() * 10 + this.getMeasures().size() * 1;
        for (JoinTableDesc joinTable : this.getModel().getJoinTables()) {
            if (!joinTable.getJoin().isInnerJoin()) continue;
            calculatedCost += 100;
        }
        return calculatedCost;
    }

    @Override
    public RealizationType getType() {
        return RealizationType.CUBE;
    }

    @Override
    public Set<TblColRef> getAllColumns() {
        return this.getDescriptor().listAllColumns();
    }

    @Override
    public Set<ColumnDesc> getAllColumnDescs() {
        return this.getDescriptor().listAllColumnDescs();
    }

    @Override
    public long getDateRangeStart() {
        return this.segments.getDateRangeStart();
    }

    @Override
    public long getDateRangeEnd() {
        return this.segments.getDateRangeEnd();
    }

    @Override
    public boolean supportsLimitPushDown() {
        return this.getDescriptor().supportsLimitPushDown();
    }

    public int getRowKeyColumnCount() {
        return this.getDescriptor().getRowkey().getRowKeyColumns().length;
    }

    @Override
    public List<TblColRef> getAllDimensions() {
        return Lists.newArrayList(this.getDescriptor().listDimensionColumnsIncludingDerived());
    }

    public boolean needAutoMerge() {
        if (!this.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
            return false;
        }
        return this.getDescriptor().getAutoMergeTimeRanges() != null && this.getDescriptor().getAutoMergeTimeRanges().length > 0;
    }

    public Pair<Long, Long> autoMergeCubeSegments() throws IOException {
        return this.segments.autoMergeCubeSegments(this.needAutoMerge(), this.getName(), this.getDescriptor().getAutoMergeTimeRanges());
    }

    public Segments calculateToBeSegments(CubeSegment newSegment) {
        return this.segments.calculateToBeSegments(newSegment);
    }

    public CubeSegment getLastSegment() {
        Segments<CubeSegment> existing = this.getSegments();
        if (existing.isEmpty()) {
            return null;
        }
        return (CubeSegment)existing.get(existing.size() - 1);
    }

    @Override
    public int getSourceType() {
        return this.getModel().getRootFactTable().getTableDesc().getSourceType();
    }

    @Override
    public int getStorageType() {
        return this.getDescriptor().getStorageType();
    }

    @Override
    public int getEngineType() {
        return this.getDescriptor().getEngineType();
    }

    public static CubeInstance getCopyOf(CubeInstance cubeInstance) {
        CubeInstance newCube = new CubeInstance();
        newCube.setName(cubeInstance.getName());
        newCube.setSegments(cubeInstance.getSegments());
        newCube.setDescName(cubeInstance.getDescName());
        newCube.setConfig((KylinConfigExt)cubeInstance.getConfig());
        newCube.setStatus(cubeInstance.getStatus());
        newCube.setOwner(cubeInstance.getOwner());
        newCube.setCost(cubeInstance.getCost());
        newCube.setCreateTimeUTC(System.currentTimeMillis());
        newCube.updateRandomUuid();
        return newCube;
    }
}

