/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.CubeMetadataValidator;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDescManager {
    private static final Logger logger = LoggerFactory.getLogger(CubeDescManager.class);
    public static final Serializer<CubeDesc> CUBE_DESC_SERIALIZER = new JsonSerializer<CubeDesc>(CubeDesc.class);
    private static final ConcurrentMap<KylinConfig, CubeDescManager> CACHE = new ConcurrentHashMap<KylinConfig, CubeDescManager>();
    private KylinConfig config;
    private CaseInsensitiveStringCache<CubeDesc> cubeDescMap;

    public static CubeDescManager getInstance(KylinConfig config) {
        CubeDescManager r = (CubeDescManager)CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<CubeDescManager> clazz = CubeDescManager.class;
        synchronized (CubeDescManager.class) {
            r = (CubeDescManager)CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new CubeDescManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init CubeDescManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static void clearCache(KylinConfig kylinConfig) {
        if (kylinConfig != null) {
            CACHE.remove(kylinConfig);
        }
    }

    private CubeDescManager(KylinConfig config) throws IOException {
        logger.info("Initializing CubeDescManager with config " + config);
        this.config = config;
        this.cubeDescMap = new CaseInsensitiveStringCache(config, "cube_desc");
        this.reloadAllCubeDesc();
        Broadcaster.getInstance(config).registerListener(new CubeDescSyncListener(), "cube_desc");
    }

    public CubeDesc getCubeDesc(String name) {
        return (CubeDesc)this.cubeDescMap.get(name);
    }

    public List<CubeDesc> listAllDesc() {
        return new ArrayList<CubeDesc>(this.cubeDescMap.values());
    }

    public CubeDesc reloadCubeDescLocal(String name) throws IOException {
        CubeDesc ndesc = this.loadCubeDesc(CubeDesc.concatResourcePath(name), false);
        this.cubeDescMap.putLocal(ndesc.getName(), ndesc);
        Cuboid.reloadCache(name);
        CubeManager cubeManager = CubeManager.getInstance(this.config);
        for (CubeInstance cube : cubeManager.getCubesByDesc(name)) {
            if (cube.getStatus() != RealizationStatusEnum.DESCBROKEN) continue;
            cubeManager.reloadCubeLocal(cube.getName());
        }
        return ndesc;
    }

    private CubeDesc loadCubeDesc(String path, boolean allowBroken) throws IOException {
        ResourceStore store = this.getStore();
        CubeDesc ndesc = store.getResource(path, CubeDesc.class, CUBE_DESC_SERIALIZER);
        if (ndesc == null) {
            throw new IllegalArgumentException("No cube desc found at " + path);
        }
        if (ndesc.isDraft()) {
            throw new IllegalArgumentException("CubeDesc '" + ndesc.getName() + "' must not be a draft");
        }
        try {
            ndesc.init(this.config);
        }
        catch (Exception e) {
            logger.warn("Broken cube desc " + path, (Throwable)e);
            ndesc.addError(e.getMessage());
        }
        if (!allowBroken && !ndesc.getError().isEmpty()) {
            throw new IllegalStateException("Cube desc at " + path + " has issues: " + ndesc.getError());
        }
        return ndesc;
    }

    public CubeDesc createCubeDesc(CubeDesc cubeDesc) throws IOException {
        if (cubeDesc.getUuid() == null || cubeDesc.getName() == null) {
            throw new IllegalArgumentException();
        }
        if (this.cubeDescMap.containsKey(cubeDesc.getName())) {
            throw new IllegalArgumentException("CubeDesc '" + cubeDesc.getName() + "' already exists");
        }
        if (cubeDesc.isDraft()) {
            throw new IllegalArgumentException("CubeDesc '" + cubeDesc.getName() + "' must not be a draft");
        }
        try {
            cubeDesc.init(this.config);
        }
        catch (Exception e) {
            logger.warn("Broken cube desc " + cubeDesc, (Throwable)e);
            cubeDesc.addError(e.getMessage());
        }
        this.postProcessCubeDesc(cubeDesc);
        if (!cubeDesc.getError().isEmpty()) {
            return cubeDesc;
        }
        CubeMetadataValidator validator = new CubeMetadataValidator();
        ValidateContext context = validator.validate(cubeDesc);
        if (!context.ifPass()) {
            return cubeDesc;
        }
        cubeDesc.setSignature(cubeDesc.calculateSignature());
        String path = cubeDesc.getResourcePath();
        this.getStore().putResource(path, cubeDesc, CUBE_DESC_SERIALIZER);
        this.cubeDescMap.put(cubeDesc.getName(), cubeDesc);
        return cubeDesc;
    }

    private void postProcessCubeDesc(CubeDesc cubeDesc) {
        for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
            if (!"TOP_N".equalsIgnoreCase(measureDesc.getFunction().getExpression())) continue;
            Map<String, String> configuration = measureDesc.getFunction().getConfiguration();
            ParameterDesc parameter = measureDesc.getFunction().getParameter();
            int keyLength = 0;
            for (parameter = parameter.getNextParameter(); parameter != null; parameter = parameter.getNextParameter()) {
                String encoding = configuration.get("topn.encoding." + parameter.getValue());
                String encodingVersionStr = configuration.get("topn.encoding_version." + parameter.getValue());
                if (StringUtils.isEmpty((CharSequence)encoding) || "dict".equals(encoding)) {
                    keyLength += 4;
                    continue;
                }
                int encodingVersion = 1;
                if (!StringUtils.isEmpty((CharSequence)encodingVersionStr)) {
                    try {
                        encodingVersion = Integer.parseInt(encodingVersionStr);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("invalid encoding version: " + encodingVersionStr);
                    }
                }
                Object[] encodingConf = DimensionEncoding.parseEncodingConf(encoding);
                DimensionEncoding dimensionEncoding = DimensionEncodingFactory.create((String)encodingConf[0], (String[])encodingConf[1], encodingVersion);
                keyLength += dimensionEncoding.getLengthOfEncoding();
            }
            DataType returnType = DataType.getType(measureDesc.getFunction().getReturnType());
            DataType newReturnType = new DataType(returnType.getName(), returnType.getPrecision(), keyLength);
            measureDesc.getFunction().setReturnType(newReturnType.toString());
        }
    }

    public void removeCubeDesc(CubeDesc cubeDesc) throws IOException {
        String path = cubeDesc.getResourcePath();
        this.getStore().deleteResource(path);
        this.cubeDescMap.remove(cubeDesc.getName());
        Cuboid.reloadCache(cubeDesc.getName());
    }

    public void removeLocalCubeDesc(String name) throws IOException {
        this.cubeDescMap.removeLocal(name);
        Cuboid.reloadCache(name);
    }

    private void reloadAllCubeDesc() throws IOException {
        ResourceStore store = this.getStore();
        logger.info("Reloading Cube Metadata from folder " + store.getReadableResourcePath("/cube_desc"));
        this.cubeDescMap.clear();
        List<String> paths = store.collectResourceRecursively("/cube_desc", ".json");
        for (String path : paths) {
            CubeDesc desc = null;
            try {
                desc = this.loadCubeDesc(path, true);
            }
            catch (Exception e) {
                logger.error("Error during load cube desc, skipping " + path, (Throwable)e);
                continue;
            }
            if (!path.equals(desc.getResourcePath())) {
                logger.error("Skip suspicious desc at " + path + ", " + desc + " should be at " + desc.getResourcePath());
                continue;
            }
            if (this.cubeDescMap.containsKey(desc.getName())) {
                logger.error("Dup CubeDesc name '" + desc.getName() + "' on path " + path);
                continue;
            }
            this.cubeDescMap.putLocal(desc.getName(), desc);
        }
        logger.info("Loaded " + this.cubeDescMap.size() + " Cube(s)");
    }

    public CubeDesc updateCubeDesc(CubeDesc desc) throws IOException {
        if (desc.getUuid() == null || desc.getName() == null) {
            throw new IllegalArgumentException();
        }
        String name = desc.getName();
        if (!this.cubeDescMap.containsKey(name)) {
            throw new IllegalArgumentException("CubeDesc '" + name + "' does not exist.");
        }
        if (desc.isDraft()) {
            throw new IllegalArgumentException("CubeDesc '" + desc.getName() + "' must not be a draft");
        }
        try {
            desc.init(this.config);
        }
        catch (Exception e) {
            logger.warn("Broken cube desc " + desc, (Throwable)e);
            desc.addError(e.getMessage());
            return desc;
        }
        this.postProcessCubeDesc(desc);
        CubeMetadataValidator validator = new CubeMetadataValidator();
        ValidateContext context = validator.validate(desc);
        if (!context.ifPass()) {
            return desc;
        }
        desc.setSignature(desc.calculateSignature());
        String path = desc.getResourcePath();
        this.getStore().putResource(path, desc, CUBE_DESC_SERIALIZER);
        CubeDesc ndesc = this.loadCubeDesc(path, false);
        this.cubeDescMap.put(ndesc.getName(), desc);
        return ndesc;
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    private class CubeDescSyncListener
    extends Broadcaster.Listener {
        private CubeDescSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CubeDescManager.clearCache();
            Cuboid.clearCache();
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            for (IRealization real : ProjectManager.getInstance(CubeDescManager.this.config).listAllRealizations(project)) {
                if (!(real instanceof CubeInstance)) continue;
                String descName = ((CubeInstance)real).getDescName();
                CubeDescManager.this.reloadCubeDescLocal(descName);
            }
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String modelName;
            String cubeDescName = cacheKey;
            CubeDesc cubeDesc = CubeDescManager.this.getCubeDesc(cubeDescName);
            String string = modelName = cubeDesc == null ? null : cubeDesc.getModelName();
            if (event == Broadcaster.Event.DROP) {
                CubeDescManager.this.removeLocalCubeDesc(cubeDescName);
            } else {
                CubeDescManager.this.reloadCubeDescLocal(cubeDescName);
            }
            for (ProjectInstance prj : ProjectManager.getInstance(CubeDescManager.this.config).findProjectsByModel(modelName)) {
                broadcaster.notifyProjectSchemaUpdate(prj.getName());
            }
        }
    }
}

