/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer.MappeableContainer;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer.MappeableContainerPointer;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class BufferFastAggregation {
    public static MutableRoaringBitmap and(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_and(bitmaps);
    }

    public static MutableRoaringBitmap and(Iterator bitmaps) {
        return BufferFastAggregation.naive_and(bitmaps);
    }

    public static MutableRoaringBitmap and(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.and(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static Iterator<ImmutableRoaringBitmap> convertToImmutable(final Iterator<MutableRoaringBitmap> i) {
        return new Iterator<ImmutableRoaringBitmap>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public ImmutableRoaringBitmap next() {
                return (ImmutableRoaringBitmap)i.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    private static ImmutableRoaringBitmap[] convertToImmutable(MutableRoaringBitmap[] array) {
        ImmutableRoaringBitmap[] answer = new ImmutableRoaringBitmap[array.length];
        for (int k = 0; k < answer.length; ++k) {
            answer[k] = array[k];
        }
        return answer;
    }

    public static MutableRoaringBitmap horizontal_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<MappeableContainerPointer> pq = new PriorityQueue<MappeableContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            MappeableContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            MappeableContainerPointer x1 = (MappeableContainerPointer)pq.poll();
            if (pq.isEmpty() || ((MappeableContainerPointer)pq.peek()).key() != x1.key()) {
                answer.getMappeableRoaringArray().append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            MappeableContainerPointer x2 = (MappeableContainerPointer)pq.poll();
            MappeableContainer newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((MappeableContainerPointer)pq.peek()).key() == x1.key()) {
                MappeableContainerPointer x = (MappeableContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.getMappeableRoaringArray().append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    @Deprecated
    public static MutableRoaringBitmap horizontal_or(Iterator bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap horizontal_or(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.horizontal_or(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap horizontal_xor(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<MappeableContainerPointer> pq = new PriorityQueue<MappeableContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            MappeableContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            MappeableContainerPointer x1 = (MappeableContainerPointer)pq.poll();
            if (pq.isEmpty() || ((MappeableContainerPointer)pq.peek()).key() != x1.key()) {
                answer.getMappeableRoaringArray().append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            MappeableContainerPointer x2 = (MappeableContainerPointer)pq.poll();
            MappeableContainer newc = x1.getContainer().xor(x2.getContainer());
            while (!pq.isEmpty() && ((MappeableContainerPointer)pq.peek()).key() == x1.key()) {
                MappeableContainerPointer x = (MappeableContainerPointer)pq.poll();
                newc = newc.ixor(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.getMappeableRoaringArray().append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static MutableRoaringBitmap horizontal_xor(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.horizontal_xor(BufferFastAggregation.convertToImmutable(bitmaps));
    }

    public static MutableRoaringBitmap naive_and(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer;
        if (bitmaps.length > 0) {
            answer = bitmaps[0].toMutableRoaringBitmap();
            for (int k = 1; k < bitmaps.length; ++k) {
                answer = ImmutableRoaringBitmap.and(answer, bitmaps[k]);
            }
        } else {
            answer = new MutableRoaringBitmap();
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_and(Iterator bitmaps) {
        if (!bitmaps.hasNext()) {
            return new MutableRoaringBitmap();
        }
        MutableRoaringBitmap answer = ((ImmutableRoaringBitmap)bitmaps.next()).toMutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.and((ImmutableRoaringBitmap)bitmaps.next());
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_and(MutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new MutableRoaringBitmap();
        }
        MutableRoaringBitmap answer = bitmaps[0].clone();
        for (int k = 1; k < bitmaps.length; ++k) {
            answer.and(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_or(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.or(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_or(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.lazyor((ImmutableRoaringBitmap)bitmaps.next());
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_or(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.lazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(ImmutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(Iterator bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.xor((ImmutableRoaringBitmap)bitmaps.next());
        }
        return answer;
    }

    public static MutableRoaringBitmap naive_xor(MutableRoaringBitmap ... bitmaps) {
        MutableRoaringBitmap answer = new MutableRoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static MutableRoaringBitmap or(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(Iterator bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap or(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_or(bitmaps);
    }

    public static MutableRoaringBitmap priorityqueue_or(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new MutableRoaringBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0].toMutableRoaringBitmap();
        }
        ImmutableRoaringBitmap[] buffer = Arrays.copyOf(bitmaps, bitmaps.length);
        final int[] sizes = new int[buffer.length];
        boolean[] istmp = new boolean[buffer.length];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = buffer[k].serializedSizeInBytes();
        }
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(128, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return sizes[a] - sizes[b];
            }
        });
        for (int k = 0; k < sizes.length; ++k) {
            pq.add(k);
        }
        while (pq.size() > 1) {
            Integer x1 = pq.poll();
            Integer x2 = pq.poll();
            if (istmp[x1] && istmp[x2]) {
                buffer[x1.intValue()] = MutableRoaringBitmap.lazyorfromlazyinputs((MutableRoaringBitmap)buffer[x1], (MutableRoaringBitmap)buffer[x2]);
                sizes[x1.intValue()] = buffer[x1].serializedSizeInBytes();
                pq.add(x1);
                continue;
            }
            if (istmp[x2]) {
                ((MutableRoaringBitmap)buffer[x2]).lazyor(buffer[x1]);
                sizes[x2.intValue()] = buffer[x2].serializedSizeInBytes();
                pq.add(x2);
                continue;
            }
            if (istmp[x1]) {
                ((MutableRoaringBitmap)buffer[x1]).lazyor(buffer[x2]);
                sizes[x1.intValue()] = buffer[x1].serializedSizeInBytes();
                pq.add(x1);
                continue;
            }
            buffer[x1.intValue()] = ImmutableRoaringBitmap.lazyor(buffer[x1], buffer[x2]);
            sizes[x1.intValue()] = buffer[x1].serializedSizeInBytes();
            istmp[x1.intValue()] = true;
            pq.add(x1);
        }
        MutableRoaringBitmap answer = (MutableRoaringBitmap)buffer[pq.poll()];
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_or(Iterator bitmaps) {
        if (!bitmaps.hasNext()) {
            return new MutableRoaringBitmap();
        }
        ArrayList<ImmutableRoaringBitmap> buffer = new ArrayList<ImmutableRoaringBitmap>();
        while (bitmaps.hasNext()) {
            buffer.add((ImmutableRoaringBitmap)bitmaps.next());
        }
        final long[] sizes = new long[buffer.size()];
        boolean[] istmp = new boolean[buffer.size()];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = ((ImmutableRoaringBitmap)buffer.get(k)).getLongSizeInBytes();
        }
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(128, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return (int)(sizes[a] - sizes[b]);
            }
        });
        for (int k = 0; k < sizes.length; ++k) {
            pq.add(k);
        }
        if (pq.size() == 1) {
            return ((ImmutableRoaringBitmap)buffer.get(pq.poll())).toMutableRoaringBitmap();
        }
        while (pq.size() > 1) {
            Integer x1 = pq.poll();
            Integer x2 = pq.poll();
            if (istmp[x1] && istmp[x2]) {
                buffer.set(x1, MutableRoaringBitmap.lazyorfromlazyinputs((MutableRoaringBitmap)buffer.get(x1), (MutableRoaringBitmap)buffer.get(x2)));
                sizes[x1.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
                pq.add(x1);
                continue;
            }
            if (istmp[x2]) {
                ((MutableRoaringBitmap)buffer.get(x2)).lazyor((ImmutableRoaringBitmap)buffer.get(x1));
                sizes[x2.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x2)).getLongSizeInBytes();
                pq.add(x2);
                continue;
            }
            if (istmp[x1]) {
                ((MutableRoaringBitmap)buffer.get(x1)).lazyor((ImmutableRoaringBitmap)buffer.get(x2));
                sizes[x1.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
                pq.add(x1);
                continue;
            }
            buffer.set(x1, ImmutableRoaringBitmap.lazyor((ImmutableRoaringBitmap)buffer.get(x1), (ImmutableRoaringBitmap)buffer.get(x2)));
            sizes[x1.intValue()] = ((ImmutableRoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
            istmp[x1.intValue()] = true;
            pq.add(x1);
        }
        MutableRoaringBitmap answer = (MutableRoaringBitmap)buffer.get(pq.poll());
        answer.repairAfterLazy();
        return answer;
    }

    public static MutableRoaringBitmap priorityqueue_xor(ImmutableRoaringBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("Expecting at least 2 bitmaps");
        }
        PriorityQueue<ImmutableRoaringBitmap> pq = new PriorityQueue<ImmutableRoaringBitmap>(bitmaps.length, new Comparator<ImmutableRoaringBitmap>(){

            @Override
            public int compare(ImmutableRoaringBitmap a, ImmutableRoaringBitmap b) {
                return (int)(a.getLongSizeInBytes() - b.getLongSizeInBytes());
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            ImmutableRoaringBitmap x1 = pq.poll();
            ImmutableRoaringBitmap x2 = pq.poll();
            pq.add(ImmutableRoaringBitmap.xor(x1, x2));
        }
        return (MutableRoaringBitmap)pq.poll();
    }

    public static MutableRoaringBitmap xor(ImmutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap xor(Iterator bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    public static MutableRoaringBitmap xor(MutableRoaringBitmap ... bitmaps) {
        return BufferFastAggregation.naive_xor(bitmaps);
    }

    private BufferFastAggregation() {
    }
}

