/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.restclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.util.JsonUtil;

public class RestClient {
    protected String host;
    protected int port;
    protected String baseUrl;
    protected String userName;
    protected String password;
    protected DefaultHttpClient client;
    protected static Pattern fullRestPattern = Pattern.compile("(?:([^:]+)[:]([^@]+)[@])?([^:]+)(?:[:](\\d+))?");
    private static final int HTTP_CONNECTION_TIMEOUT_MS = 30000;
    private static final int HTTP_SOCKET_TIMEOUT_MS = 120000;
    public static final String SCHEME_HTTP = "http://";
    public static final String KYLIN_API_PATH = "/kylin/api";

    public static boolean matchFullRestPattern(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        return m.matches();
    }

    public RestClient(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        if (!m.matches()) {
            throw new IllegalArgumentException("URI: " + uri + " -- does not match pattern " + fullRestPattern);
        }
        String user = m.group(1);
        String pwd = m.group(2);
        String host = m.group(3);
        String portStr = m.group(4);
        int port = Integer.parseInt(portStr == null ? "7070" : portStr);
        this.init(host, port, user, pwd);
    }

    public RestClient(String host, int port, String userName, String password) {
        this.init(host, port, userName, password);
    }

    private void init(String host, int port, String userName, String password) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.baseUrl = SCHEME_HTTP + host + ":" + port + KYLIN_API_PATH;
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)120000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
        this.client = new DefaultHttpClient((HttpParams)httpParams);
        if (userName != null && password != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.client.setCredentialsProvider((CredentialsProvider)provider);
        }
    }

    public void wipeCache(String entity, String event, String cacheKey) throws IOException {
        String url = this.baseUrl + "/cache/" + entity + "/" + cacheKey + "/" + event;
        HttpPut request = new HttpPut(url);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                String msg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with cache wipe url " + url + "\n" + msg);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKylinProperties() throws IOException {
        String url = this.baseUrl + "/admin/config";
        HttpGet request = new HttpGet(url);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            Map<String, String> map = JsonUtil.readValueAsMap(msg);
            msg = map.get("config");
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with cache wipe url " + url + "\n" + msg);
            }
            String string = msg;
            return string;
        }
        finally {
            request.releaseConnection();
        }
    }

    public boolean enableCache() throws IOException {
        return this.setCache(true);
    }

    public boolean disableCache() throws IOException {
        return this.setCache(false);
    }

    public boolean buildCube(String cubeName, long startTime, long endTime, String buildType) throws Exception {
        String url = this.baseUrl + "/cubes/" + cubeName + "/build";
        HttpPut put = this.newPut(url);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("startTime", startTime + "");
        paraMap.put("endTime", endTime + "");
        paraMap.put("buildType", buildType);
        String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
        put.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)put);
        String result = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with build cube url " + url + "\n" + jsonMsg);
        }
        return true;
    }

    public boolean disableCube(String cubeName) throws Exception {
        return this.changeCubeStatus(this.baseUrl + "/cubes/" + cubeName + "/disable");
    }

    public boolean enableCube(String cubeName) throws Exception {
        return this.changeCubeStatus(this.baseUrl + "/cubes/" + cubeName + "/enable");
    }

    public boolean purgeCube(String cubeName) throws Exception {
        return this.changeCubeStatus(this.baseUrl + "/cubes/" + cubeName + "/purge");
    }

    public HashMap getCube(String cubeName) throws Exception {
        String url = this.baseUrl + "/cubes/" + cubeName;
        HttpGet get = this.newGet(url);
        get.setURI(new URI(url));
        HttpResponse response = this.client.execute((HttpUriRequest)get);
        return this.dealResponse(response);
    }

    private boolean changeCubeStatus(String url) throws Exception {
        HttpPut put = this.newPut(url);
        HashMap paraMap = new HashMap();
        String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
        put.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)put);
        String result = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n" + jsonMsg);
        }
        return true;
    }

    public HttpResponse query(String sql, String project) throws IOException {
        String url = this.baseUrl + "/query";
        HttpPost post = this.newPost(url);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("sql", sql);
        paraMap.put("project", project);
        String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
        post.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        return response;
    }

    private HashMap dealResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode());
        }
        String result = this.getContent(response);
        HashMap resultMap = (HashMap)new ObjectMapper().readValue(result, HashMap.class);
        return resultMap;
    }

    private void addHttpHeaders(HttpRequestBase method) {
        method.addHeader("Accept", "application/json, text/plain, */*");
        method.addHeader("Content-Type", "application/json");
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])(this.userName + ":" + this.password).getBytes());
        method.addHeader("Authorization", "Basic " + basicAuth);
    }

    private HttpPost newPost(String url) {
        HttpPost post = new HttpPost(url);
        this.addHttpHeaders((HttpRequestBase)post);
        return post;
    }

    private HttpPut newPut(String url) {
        HttpPut put = new HttpPut(url);
        this.addHttpHeaders((HttpRequestBase)put);
        return put;
    }

    private HttpGet newGet(String url) {
        HttpGet get = new HttpGet();
        this.addHttpHeaders((HttpRequestBase)get);
        return get;
    }

    private boolean setCache(boolean flag) throws IOException {
        String url = this.baseUrl + "/admin/config";
        HttpPut put = this.newPut(url);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("key", "kylin.query.cache-enabled");
        paraMap.put("value", flag + "");
        put.setEntity((HttpEntity)new StringEntity(new ObjectMapper().writeValueAsString(paraMap), "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)put);
        EntityUtils.consume((HttpEntity)response.getEntity());
        return response.getStatusLine().getStatusCode() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(HttpResponse response) throws IOException {
        InputStreamReader reader = null;
        BufferedReader rd = null;
        StringBuffer result = new StringBuffer();
        try {
            reader = new InputStreamReader(response.getEntity().getContent());
            rd = new BufferedReader(reader);
            String line = null;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(rd);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)rd);
        return result.toString();
    }
}

