/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class QueryContext {
    private static final ThreadLocal<QueryContext> contexts = new ThreadLocal<QueryContext>(){

        @Override
        protected QueryContext initialValue() {
            return new QueryContext();
        }
    };
    private String queryId;
    private AtomicLong scannedRows = new AtomicLong();
    private AtomicLong scannedBytes = new AtomicLong();

    private QueryContext() {
        this.queryId = UUID.randomUUID().toString();
    }

    public static QueryContext current() {
        return contexts.get();
    }

    public static void reset() {
        contexts.remove();
    }

    public String getQueryId() {
        return this.queryId == null ? "" : this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public long getScannedRows() {
        return this.scannedRows.get();
    }

    public long addAndGetScannedRows(long deltaRows) {
        return this.scannedRows.addAndGet(deltaRows);
    }

    public long getScannedBytes() {
        return this.scannedBytes.get();
    }

    public long addAndGetScannedBytes(long deltaBytes) {
        return this.scannedBytes.addAndGet(deltaBytes);
    }
}

