/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanHtableCLI
extends AbstractApplication {
    protected static final Logger logger = LoggerFactory.getLogger(CleanHtableCLI.class);

    private void clean() throws IOException {
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        for (HTableDescriptor descriptor : hbaseAdmin.listTables()) {
            String name = descriptor.getNameAsString().toLowerCase();
            if (!name.startsWith("kylin") && !name.startsWith("_kylin")) continue;
            String x = descriptor.getValue("KYLIN_HOST");
            System.out.println("table name " + descriptor.getNameAsString() + " host: " + x);
            System.out.println(descriptor);
            System.out.println();
            descriptor.setValue("OWNER", "DL-eBay-Kylin@ebay.com");
            hbaseAdmin.modifyTable(descriptor.getNameAsString(), descriptor);
        }
        hbaseAdmin.close();
    }

    public static void main(String[] args) throws Exception {
        CleanHtableCLI cli = new CleanHtableCLI();
        cli.execute(args);
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.clean();
    }
}

