/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.IGTWriter;
import org.apache.kylin.storage.hbase.cube.v2.CellListIterator;

public class HBaseReadonlyStore
implements IGTStore {
    private CellListIterator cellListIterator;
    private GTInfo info;
    private List<Pair<byte[], byte[]>> hbaseColumns;
    private List<List<Integer>> hbaseColumnsToGT;
    private int rowkeyPreambleSize;
    private boolean withDelay = false;

    public HBaseReadonlyStore(CellListIterator cellListIterator, GTScanRequest gtScanRequest, List<Pair<byte[], byte[]>> hbaseColumns, List<List<Integer>> hbaseColumnsToGT, int rowkeyPreambleSize, boolean withDelay) {
        this.cellListIterator = cellListIterator;
        this.info = gtScanRequest.getInfo();
        this.hbaseColumns = hbaseColumns;
        this.hbaseColumnsToGT = hbaseColumnsToGT;
        this.rowkeyPreambleSize = rowkeyPreambleSize;
        this.withDelay = withDelay;
    }

    @Override
    public GTInfo getInfo() {
        return this.info;
    }

    @Override
    public IGTWriter rebuild() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IGTWriter append() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Cell findCell(List<Cell> cells, byte[] familyName, byte[] columnName) {
        for (Cell c : cells) {
            if (BytesUtil.compareBytes(familyName, 0, c.getFamilyArray(), c.getFamilyOffset(), familyName.length) != 0 || BytesUtil.compareBytes(columnName, 0, c.getQualifierArray(), c.getQualifierOffset(), columnName.length) != 0) continue;
            return c;
        }
        return null;
    }

    @Override
    public IGTScanner scan(GTScanRequest scanRequest) throws IOException {
        return new IGTScanner(){
            int count;

            @Override
            public void close() throws IOException {
                HBaseReadonlyStore.this.cellListIterator.close();
            }

            @Override
            public Iterator<GTRecord> iterator() {
                return new Iterator<GTRecord>(){
                    GTRecord oneRecord;
                    {
                        this.oneRecord = new GTRecord(HBaseReadonlyStore.this.info);
                    }

                    @Override
                    public boolean hasNext() {
                        if (HBaseReadonlyStore.this.withDelay) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        return HBaseReadonlyStore.this.cellListIterator.hasNext();
                    }

                    @Override
                    public GTRecord next() {
                        ++count;
                        List oneRow = (List)HBaseReadonlyStore.this.cellListIterator.next();
                        if (oneRow.size() < 1) {
                            throw new IllegalStateException("cell list's size less than 1");
                        }
                        Cell firstCell = (Cell)oneRow.get(0);
                        ByteBuffer buf = this.byteBuffer(firstCell.getRowArray(), HBaseReadonlyStore.this.rowkeyPreambleSize + firstCell.getRowOffset(), firstCell.getRowLength() - HBaseReadonlyStore.this.rowkeyPreambleSize);
                        this.oneRecord.loadCellBlock(0, buf);
                        for (int i = 0; i < HBaseReadonlyStore.this.hbaseColumns.size(); ++i) {
                            Pair hbaseColumn = (Pair)HBaseReadonlyStore.this.hbaseColumns.get(i);
                            Cell cell = HBaseReadonlyStore.findCell(oneRow, (byte[])hbaseColumn.getFirst(), (byte[])hbaseColumn.getSecond());
                            Preconditions.checkNotNull((Object)cell);
                            buf = this.byteBuffer(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                            this.oneRecord.loadColumns((List)HBaseReadonlyStore.this.hbaseColumnsToGT.get(i), buf);
                        }
                        return this.oneRecord;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private ByteBuffer byteBuffer(byte[] array, int offset, int length) {
                        return ByteBuffer.wrap(array, offset, length);
                    }
                };
            }

            @Override
            public GTInfo getInfo() {
                return HBaseReadonlyStore.this.info;
            }

            @Override
            public long getScannedRowCount() {
                return this.count;
            }
        };
    }
}

