/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@Deprecated
public class CoprocessorRowType {
    private static final BytesSerializer<CoprocessorRowType> serializer = new BytesSerializer<CoprocessorRowType>(){

        @Override
        public void serialize(CoprocessorRowType o, ByteBuffer out) {
            int n = o.columns.length;
            BytesUtil.writeVInt(o.columns.length, out);
            BytesUtil.writeVInt(o.bodyOffset, out);
            for (int i = 0; i < n; ++i) {
                BytesUtil.writeAsciiString(o.columns[i].getTable(), out);
                BytesUtil.writeAsciiString(o.columns[i].getName(), out);
                BytesUtil.writeVInt(o.columnSizes[i], out);
            }
        }

        @Override
        public CoprocessorRowType deserialize(ByteBuffer in) {
            int n = BytesUtil.readVInt(in);
            int bodyOffset = BytesUtil.readVInt(in);
            TblColRef[] cols = new TblColRef[n];
            int[] colSizes = new int[n];
            for (int i = 0; i < n; ++i) {
                int colSize;
                String tableName = BytesUtil.readAsciiString(in);
                String colName = BytesUtil.readAsciiString(in);
                TableDesc table = new TableDesc();
                table.setName(tableName);
                ColumnDesc col = new ColumnDesc();
                col.setTable(table);
                col.setName(colName);
                col.init(table);
                cols[i] = col.getRef();
                colSizes[i] = colSize = BytesUtil.readVInt(in);
            }
            return new CoprocessorRowType(cols, colSizes, bodyOffset);
        }
    };
    public TblColRef[] columns;
    private int bodyOffset;
    public int[] columnSizes;
    public int[] columnOffsets;
    public HashMap<TblColRef, Integer> columnIdxMap;

    public static CoprocessorRowType fromCuboid(CubeSegment seg, Cuboid cuboid) {
        List<TblColRef> colList = cuboid.getColumns();
        TblColRef[] cols = colList.toArray(new TblColRef[colList.size()]);
        RowKeyColumnIO colIO = new RowKeyColumnIO(seg.getDimensionEncodingMap());
        int[] colSizes = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            colSizes[i] = colIO.getColumnLength(cols[i]);
        }
        return new CoprocessorRowType(cols, colSizes, seg.getRowKeyPreambleSize());
    }

    public static byte[] serialize(CoprocessorRowType o) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        serializer.serialize(o, buf);
        byte[] result = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, result, 0, buf.position());
        return result;
    }

    public static CoprocessorRowType deserialize(byte[] bytes) {
        return serializer.deserialize(ByteBuffer.wrap(bytes));
    }

    public CoprocessorRowType(TblColRef[] columns, int[] columnSizes, int bodyOffset) {
        this.bodyOffset = bodyOffset;
        this.columns = columns;
        this.columnSizes = columnSizes;
        this.init();
    }

    public int getColIndexByTblColRef(TblColRef colRef) {
        return this.columnIdxMap.get(colRef);
    }

    private void init() {
        int[] offsets = new int[this.columns.length];
        int o = this.bodyOffset;
        for (int i = 0; i < this.columns.length; ++i) {
            offsets[i] = o;
            o += this.columnSizes[i];
        }
        this.columnOffsets = offsets;
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < this.columns.length; ++i) {
            map.put(this.columns[i], i);
        }
        this.columnIdxMap = map;
    }

    public int getColumnCount() {
        return this.columns.length;
    }
}

