/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class SQLDigest {
    public String factTable;
    public TupleFilter filter;
    public List<JoinDesc> joinDescs;
    public Set<TblColRef> allColumns;
    public List<TblColRef> groupbyColumns;
    public Set<TblColRef> filterColumns;
    public Set<TblColRef> metricColumns;
    public List<FunctionDesc> aggregations;
    public List<SQLCall> aggrSqlCalls;
    public List<TblColRef> sortColumns;
    public List<OrderEnum> sortOrders;
    public boolean isRawQuery;

    public SQLDigest(String factTable, TupleFilter filter, List<JoinDesc> joinDescs, Set<TblColRef> allColumns, List<TblColRef> groupbyColumns, Set<TblColRef> filterColumns, Set<TblColRef> metricColumns, List<FunctionDesc> aggregations, List<SQLCall> aggrSqlCalls, List<TblColRef> sortColumns, List<OrderEnum> sortOrders) {
        this.factTable = factTable;
        this.filter = filter;
        this.joinDescs = joinDescs;
        this.allColumns = allColumns;
        this.groupbyColumns = groupbyColumns;
        this.filterColumns = filterColumns;
        this.metricColumns = metricColumns;
        this.aggregations = aggregations;
        this.aggrSqlCalls = aggrSqlCalls;
        this.sortColumns = sortColumns;
        this.sortOrders = sortOrders;
        this.isRawQuery = this.isRawQuery();
    }

    private boolean isRawQuery() {
        return this.groupbyColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public String toString() {
        return "fact table " + this.factTable + "," + "group by " + this.groupbyColumns + "," + "filter on " + this.filterColumns + "," + "with aggregates" + this.aggregations + ".";
    }

    public static class SQLCall {
        public final String function;
        public final List<Object> args;

        public SQLCall(String function, Iterable<Object> args) {
            this.function = function;
            this.args = ImmutableList.copyOf(args);
        }
    }

    public static enum OrderEnum {
        ASCENDING,
        DESCENDING;

    }
}

