/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;

public class TblColRef
implements Serializable {
    private static final String INNER_TABLE_NAME = "_kylin_table";
    private static final DataModelDesc UNKNOWN_MODEL = new DataModelDesc();
    private TableRef table;
    private ColumnDesc column;

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType) {
        ColumnDesc column = new ColumnDesc();
        column.setName(columnName);
        TableDesc table = new TableDesc();
        column.setTable(table);
        TblColRef colRef = new TblColRef(column);
        colRef.markInnerColumn(dataType);
        return colRef;
    }

    public static TableRef tableForUnknownModel(String tempTableAlias, TableDesc table) {
        return new TableRef(UNKNOWN_MODEL, tempTableAlias, table);
    }

    public static TblColRef columnForUnknownModel(TableRef table, ColumnDesc colDesc) {
        Preconditions.checkArgument((table.getModel() == UNKNOWN_MODEL ? 1 : 0) != 0);
        return new TblColRef(table, colDesc);
    }

    public static void fixUnknownModel(DataModelDesc model, String alias, TblColRef col) {
        Preconditions.checkArgument((col.table.getModel() == UNKNOWN_MODEL || col.table.getModel() == model ? 1 : 0) != 0);
        TableRef tableRef = model.findTable(alias);
        Preconditions.checkArgument((tableRef.getTableDesc() == col.column.getTable() ? 1 : 0) != 0);
        col.table = tableRef;
    }

    public static TblColRef mockup(TableDesc table, int oneBasedColumnIndex, String name, String datatype) {
        ColumnDesc desc = new ColumnDesc();
        String id = "" + oneBasedColumnIndex;
        desc.setId(id);
        desc.setName(name);
        desc.setDatatype(datatype);
        desc.init(table);
        return new TblColRef(desc);
    }

    TblColRef(ColumnDesc column) {
        this.column = column;
    }

    TblColRef(TableRef table, ColumnDesc column) {
        Preconditions.checkArgument((table.getTableDesc() == column.getTable() ? 1 : 0) != 0);
        this.table = table;
        this.column = column;
    }

    public ColumnDesc getColumnDesc() {
        return this.column;
    }

    public String getName() {
        return this.column.getName();
    }

    public TableRef getTableRef() {
        return this.table;
    }

    public String getTable() {
        if (this.column.getTable() == null) {
            return null;
        }
        return this.column.getTable().getIdentity();
    }

    public String getCanonicalName() {
        return this.getTable() + "." + this.getName();
    }

    public String getDatatype() {
        return this.column.getDatatype();
    }

    public DataType getType() {
        return this.column.getType();
    }

    public void markInnerColumn(InnerDataTypeEnum dataType) {
        this.column.setDatatype(dataType.getDataType());
        this.column.getTable().setName(INNER_TABLE_NAME);
        this.column.getTable().setDatabase("DEFAULT");
    }

    public boolean isInnerColumn() {
        return InnerDataTypeEnum.contains(this.getDatatype());
    }

    public boolean isDerivedDataType() {
        return InnerDataTypeEnum.DERIVED.getDataType().equals(this.getDatatype());
    }

    public boolean isSameAs(String tableName, String columnName) {
        return this.column.isSameAs(tableName, columnName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column.getTable().getIdentity().hashCode();
        result = 31 * result + this.column.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TblColRef other = (TblColRef)obj;
        if (!StringUtils.equals((String)this.column.getTable().getIdentity(), (String)other.column.getTable().getIdentity())) {
            return false;
        }
        return StringUtils.equals((String)this.column.getName(), (String)other.column.getName());
    }

    public String toString() {
        String tableIdentity;
        String alias = this.table == null ? "UNKNOWN_MODEL" : this.table.getAlias();
        String tableName = this.column.getTable() == null ? "NULL" : this.column.getTable().getName();
        String string = tableIdentity = this.column.getTable() == null ? "NULL" : this.column.getTable().getIdentity();
        if (alias.equals(tableName)) {
            return tableIdentity + "." + this.column.getName();
        }
        return alias + ":" + tableIdentity + "." + this.column.getName();
    }

    public static enum InnerDataTypeEnum {
        LITERAL("_literal_type"),
        DERIVED("_derived_type");

        private final String dateType;

        private InnerDataTypeEnum(String name) {
            this.dateType = name;
        }

        public String getDataType() {
            return this.dateType;
        }

        public static boolean contains(String name) {
            return LITERAL.getDataType().equals(name) || DERIVED.getDataType().equals(name);
        }
    }
}

