/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class TableRef {
    private final DataModelDesc model;
    private final String alias;
    private final TableDesc table;
    private final Map<String, TblColRef> columns;

    TableRef(DataModelDesc model, String alias, TableDesc table) {
        this.model = model;
        this.alias = alias;
        this.table = table;
        this.columns = Maps.newLinkedHashMap();
        for (ColumnDesc col : table.getColumns()) {
            this.columns.put(col.getName(), new TblColRef(this, col));
        }
    }

    public DataModelDesc getModel() {
        return this.model;
    }

    public String getAlias() {
        return this.alias;
    }

    public TableDesc getTableDesc() {
        return this.table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public String getTableIdentity() {
        return this.table.getIdentity();
    }

    public TblColRef getColumn(String name) {
        return this.columns.get(name);
    }

    public Collection<TblColRef> getColumns() {
        return Collections.unmodifiableCollection(this.columns.values());
    }

    public TblColRef makeFakeColumn(String name) {
        ColumnDesc colDesc = new ColumnDesc();
        colDesc.setName(name);
        colDesc.setTable(this.table);
        return new TblColRef(this, colDesc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRef t = (TableRef)o;
        if (!this.model.equals(t.model)) {
            return false;
        }
        if (!this.alias.equals(t.alias)) {
            return false;
        }
        return this.table.getIdentity().equals(t.table.getIdentity());
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.model.getName().hashCode();
        result = 31 * result + this.alias.hashCode();
        result = 31 * result + this.table.getIdentity().hashCode();
        return result;
    }

    public String toString() {
        if (this.alias.equals(this.table.getName())) {
            return "TableRef[" + this.table.getName() + "]";
        }
        return "TableRef[" + this.alias + ":" + this.table.getName() + "]";
    }
}

