/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DataModelDesc
extends RootPersistentEntity {
    private static final Logger logger = LoggerFactory.getLogger(DataModelDesc.class);
    private KylinConfig config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="fact_table")
    private String factTable;
    @JsonProperty(value="lookups")
    private LookupDesc[] lookups;
    @JsonProperty(value="dimensions")
    private List<ModelDimensionDesc> dimensions;
    @JsonProperty(value="metrics")
    private String[] metrics;
    @JsonProperty(value="filter_condition")
    private String filterCondition;
    @JsonProperty(value="partition_desc")
    PartitionDesc partitionDesc;
    @JsonProperty(value="capacity")
    private RealizationCapacity capacity = RealizationCapacity.MEDIUM;
    private TableRef factTableRef;
    private List<TableRef> lookupTableRefs = Lists.newArrayList();
    private Map<String, TableRef> aliasMap = Maps.newHashMap();
    private Map<String, TableRef> tableNameMap = Maps.newHashMap();
    private List<String> errors = new ArrayList<String>();

    public KylinConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<String> getAllTables() {
        HashSet ret = Sets.newHashSet();
        ret.add(this.factTable);
        for (LookupDesc lookupDesc : this.lookups) {
            ret.add(lookupDesc.getTable());
        }
        return ret;
    }

    public String getFactTable() {
        return this.factTable;
    }

    public TableRef getFactTableRef() {
        return this.factTableRef;
    }

    public List<TableRef> getLookupTableRefs() {
        return this.lookupTableRefs;
    }

    @Deprecated
    public List<TableDesc> getLookupTableDescs() {
        ArrayList result = Lists.newArrayList();
        for (TableRef table : this.getLookupTableRefs()) {
            result.add(table.getTableDesc());
        }
        return result;
    }

    public void setFactTable(String factTable) {
        this.factTable = factTable.toUpperCase();
    }

    public LookupDesc[] getLookups() {
        return this.lookups;
    }

    public void setLookups(LookupDesc[] lookups) {
        this.lookups = lookups;
    }

    public boolean isFactTable(String factTable) {
        return this.factTable.equalsIgnoreCase(factTable);
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    public void setPartitionDesc(PartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    public RealizationCapacity getCapacity() {
        return this.capacity;
    }

    public void setCapacity(RealizationCapacity capacity) {
        this.capacity = capacity;
    }

    public TblColRef findPKByFK(TblColRef fk, String joinType) {
        assert (this.isFactTable(fk.getTable()));
        TblColRef candidate = null;
        for (LookupDesc dim : this.lookups) {
            int find;
            JoinDesc join = dim.getJoin();
            if (join == null || joinType != null && !joinType.equals(join.getType()) || (find = ArrayUtils.indexOf((Object[])join.getForeignKeyColumns(), (Object)fk)) < 0) continue;
            candidate = join.getPrimaryKeyColumns()[find];
            if (join.getForeignKeyColumns().length == 1) break;
        }
        return candidate;
    }

    public TblColRef findColumn(String table, String column) {
        TableRef tableRef = this.findTable(table);
        TblColRef result = tableRef.getColumn(column);
        if (result == null) {
            throw new IllegalArgumentException("Column not found by " + table + "." + column);
        }
        return result;
    }

    public TblColRef findColumn(String column) {
        TblColRef result = null;
        int cut = column.lastIndexOf(46);
        if (cut > 0) {
            result = this.findColumn(column.substring(0, cut), column.substring(cut + 1));
        } else {
            result = this.factTableRef.getColumn(column);
            if (result == null) {
                TableRef tableRef;
                Iterator<TableRef> i$ = this.lookupTableRefs.iterator();
                while (i$.hasNext() && (result = (tableRef = i$.next()).getColumn(column)) == null) {
                }
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Column not found by " + column);
        }
        return result;
    }

    public TableRef findTable(String table) {
        TableRef result = this.tableNameMap.get(table);
        if (result == null) {
            throw new IllegalArgumentException("Table not found by " + table);
        }
        return result;
    }

    public TableRef findFirstTable(String tableIdentity) {
        if (this.factTableRef.getTableIdentity().equals(tableIdentity)) {
            return this.factTableRef;
        }
        for (TableRef lookup : this.lookupTableRefs) {
            if (!lookup.getTableIdentity().equals(tableIdentity)) continue;
            return lookup;
        }
        throw new IllegalArgumentException("Table not found by " + tableIdentity);
    }

    public void init(KylinConfig config, Map<String, TableDesc> tables) {
        this.config = config;
        this.lookupTableRefs.clear();
        this.aliasMap.clear();
        this.tableNameMap.clear();
        this.initTableAlias(tables);
        this.initJoinColumns();
        ModelDimensionDesc.capicalizeStrings(this.dimensions);
        this.initPartitionDesc();
    }

    private void initTableAlias(Map<String, TableDesc> tables) {
        this.factTable = this.factTable.toUpperCase();
        if (!tables.containsKey(this.factTable)) {
            throw new IllegalStateException("Fact table does not exist:" + this.factTable);
        }
        TableDesc factDesc = tables.get(this.factTable);
        this.factTableRef = new TableRef(this, factDesc.getName(), factDesc);
        this.addAlias(this.factTableRef);
        for (LookupDesc lookup : this.lookups) {
            lookup.setTable(lookup.getTable().toUpperCase());
            if (!tables.containsKey(lookup.getTable())) {
                throw new IllegalStateException("Lookup table does not exist:" + lookup.getTable());
            }
            TableDesc tableDesc = tables.get(lookup.getTable());
            String alias = lookup.getAlias();
            if (alias == null) {
                alias = tableDesc.getName();
            }
            TableRef ref = new TableRef(this, alias, tableDesc);
            lookup.setTableRef(ref);
            this.lookupTableRefs.add(ref);
            this.addAlias(ref);
        }
        this.tableNameMap.putAll(this.aliasMap);
    }

    private void addAlias(TableRef ref) {
        String alias = ref.getAlias();
        if (this.aliasMap.containsKey(alias)) {
            throw new IllegalStateException("Alias '" + alias + "' ref to multiple tables: " + ref.getTableIdentity() + ", " + this.aliasMap.get(alias).getTableIdentity());
        }
        this.aliasMap.put(alias, ref);
        TableDesc table = ref.getTableDesc();
        this.addTableName(table.getName(), ref);
        this.addTableName(table.getIdentity(), ref);
    }

    private void addTableName(String name, TableRef ref) {
        if (this.tableNameMap.containsKey(name)) {
            this.tableNameMap.put(name, null);
        } else {
            this.tableNameMap.put(name, ref);
        }
    }

    private void initPartitionDesc() {
        if (this.partitionDesc != null) {
            this.partitionDesc.init(this);
        }
    }

    private void initJoinColumns() {
        for (LookupDesc lookup : this.lookups) {
            int i;
            TableRef dimTable = lookup.getTableRef();
            JoinDesc join = lookup.getJoin();
            if (join == null) continue;
            StringUtil.toUpperCaseArray(join.getForeignKey(), join.getForeignKey());
            StringUtil.toUpperCaseArray(join.getPrimaryKey(), join.getPrimaryKey());
            Object[] pks = join.getPrimaryKey();
            TblColRef[] pkCols = new TblColRef[pks.length];
            for (int i2 = 0; i2 < pks.length; ++i2) {
                TblColRef col = dimTable.getColumn(pks[i2]);
                if (col == null) {
                    throw new IllegalStateException("Can't find column " + pks[i2] + " in table " + dimTable.getTableIdentity());
                }
                pkCols[i2] = col;
            }
            join.setPrimaryKeyColumns(pkCols);
            Object[] fks = join.getForeignKey();
            TblColRef[] fkCols = new TblColRef[fks.length];
            for (i = 0; i < fks.length; ++i) {
                TblColRef col = this.factTableRef.getColumn(fks[i]);
                if (col == null) {
                    throw new IllegalStateException("Can't find column " + fks[i] + " in table " + this.getFactTable());
                }
                fkCols[i] = col;
            }
            join.setForeignKeyColumns(fkCols);
            if (pkCols.length != fkCols.length) {
                throw new IllegalStateException("Primary keys(" + lookup.getTable() + ")" + Arrays.toString(pks) + " are not consistent with Foreign keys(" + this.getFactTable() + ") " + Arrays.toString(fks));
            }
            for (i = 0; i < fkCols.length; ++i) {
                if (fkCols[i].getDatatype().equals(pkCols[i].getDatatype())) continue;
                logger.warn("PK " + lookup.getTable() + "." + pkCols[i].getName() + "." + pkCols[i].getDatatype() + " are not consistent with FK " + this.getFactTable() + "." + fkCols[i].getName() + "." + fkCols[i].getDatatype());
            }
        }
    }

    public void addError(String message) {
        this.addError(message, false);
    }

    public void addError(String message, boolean silent) {
        if (!silent) {
            throw new IllegalStateException(message);
        }
        this.errors.add(message);
    }

    public List<String> getError() {
        return this.errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataModelDesc modelDesc = (DataModelDesc)o;
        if (!this.name.equals(modelDesc.name)) {
            return false;
        }
        return this.getFactTable().equals(modelDesc.getFactTable());
    }

    @Override
    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.getFactTable().hashCode();
        return result;
    }

    public String toString() {
        return "DataModelDesc [name=" + this.name + "]";
    }

    public String getResourcePath() {
        return DataModelDesc.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String descName) {
        return "/model_desc/" + descName + ".json";
    }

    public List<ModelDimensionDesc> getDimensions() {
        return this.dimensions;
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public void setDimensions(List<ModelDimensionDesc> dimensions) {
        this.dimensions = dimensions;
    }

    public void setMetrics(String[] metrics) {
        this.metrics = metrics;
    }

    public static DataModelDesc getCopyOf(DataModelDesc dataModelDesc) {
        DataModelDesc newDataModelDesc = new DataModelDesc();
        newDataModelDesc.setName(dataModelDesc.getName());
        newDataModelDesc.setDescription(dataModelDesc.getDescription());
        newDataModelDesc.setDimensions(dataModelDesc.getDimensions());
        newDataModelDesc.setFilterCondition(dataModelDesc.getFilterCondition());
        newDataModelDesc.setFactTable(dataModelDesc.getFactTable());
        newDataModelDesc.setLookups(dataModelDesc.getLookups());
        newDataModelDesc.setMetrics(dataModelDesc.getMetrics());
        newDataModelDesc.setPartitionDesc(PartitionDesc.getCopyOf(dataModelDesc.getPartitionDesc()));
        newDataModelDesc.updateRandomUuid();
        return newDataModelDesc;
    }

    public static enum RealizationCapacity {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

