/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ColumnDesc
implements Serializable {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="datatype")
    private String datatype;
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String comment;
    private DataType type;
    private TableDesc table;
    private int zeroBasedIndex = -1;
    private boolean isNullable = true;
    private TblColRef ref;

    @Deprecated
    public TblColRef getRef() {
        if (this.ref == null) {
            this.ref = new TblColRef(this);
        }
        return this.ref;
    }

    public int getZeroBasedIndex() {
        return this.zeroBasedIndex;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
        this.type = DataType.getType(datatype);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DataType getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public int getTypePrecision() {
        return this.type.getPrecision();
    }

    public int getTypeScale() {
        return this.type.getScale();
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public void init(TableDesc table) {
        DataType normalized;
        this.table = table;
        if (this.name != null) {
            this.name = this.name.toUpperCase();
        }
        if (this.id != null) {
            this.zeroBasedIndex = Integer.parseInt(this.id) - 1;
        }
        if ((normalized = DataType.getType(this.datatype)) == null) {
            this.setDatatype(null);
        } else {
            this.setDatatype(normalized.toString());
        }
    }

    public boolean isSameAs(String tableName, String columnName) {
        return StringUtils.equalsIgnoreCase((String)this.table.getIdentity(), (String)tableName) && StringUtils.equalsIgnoreCase((String)this.name, (String)columnName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDesc other = (ColumnDesc)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.datatype == null ? other.datatype != null : !this.datatype.equals(other.datatype));
    }

    public String toString() {
        return "ColumnDesc{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", datatype='" + this.datatype + '\'' + ", comment='" + this.comment + '\'' + '}';
    }
}

