/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.StringSerializer;
import org.apache.kylin.metadata.filter.BuiltInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class EvaluatableFunctionTupleFilter
extends BuiltInFunctionTupleFilter {
    private boolean constantsInitted = false;
    private List<Object> values = Lists.newArrayListWithCapacity((int)1);
    private Object tupleValue;

    public EvaluatableFunctionTupleFilter(String name) {
        super(name, TupleFilter.FilterOperatorEnum.EVAL_FUNC);
        this.values.add(null);
    }

    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem cs) {
        Object tupleValue = null;
        for (TupleFilter filter : this.children) {
            if (this.isConstant(filter)) continue;
            filter.evaluate(tuple, cs);
            tupleValue = filter.getValues().iterator().next();
        }
        TblColRef tblColRef = this.getColumn();
        DataType strDataType = DataType.getType("string");
        if (tblColRef.getType() != strDataType) {
            throw new IllegalStateException("Only String type is allow in BuiltInFunction");
        }
        ByteArray valueByteArray = tupleValue;
        StringSerializer serializer = new StringSerializer(strDataType);
        String value = serializer.deserialize(ByteBuffer.wrap(valueByteArray.array(), valueByteArray.offset(), valueByteArray.length()));
        try {
            if (this.isLikeFunction()) {
                return (Boolean)this.invokeFunction(value);
            }
            this.tupleValue = this.invokeFunction(value);
            ByteBuffer buffer = ByteBuffer.allocate(valueByteArray.length() * 2);
            serializer.serialize((String)this.tupleValue, buffer);
            this.tupleValue = new ByteArray(buffer.array(), 0, buffer.position());
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<?> getValues() {
        this.values.set(0, this.tupleValue);
        return this.values;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        if (!this.isValid()) {
            throw new IllegalStateException("must be valid");
        }
        BytesUtil.writeUTFString(this.name, buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.name = BytesUtil.readUTFString(buffer);
        this.initMethod();
    }

    @Override
    public boolean isEvaluable() {
        return true;
    }

    private boolean isConstant(TupleFilter filter) {
        return filter instanceof ConstantTupleFilter || filter instanceof DynamicTupleFilter;
    }

    @Override
    public Object invokeFunction(Object input) throws InvocationTargetException, IllegalAccessException {
        if (this.isLikeFunction()) {
            this.initConstants();
        }
        return super.invokeFunction(input);
    }

    private void initConstants() {
        if (this.constantsInitted) {
            return;
        }
        ByteArray byteArray = (ByteArray)this.methodParams.get(this.constantPosition);
        StringSerializer s = new StringSerializer(DataType.getType("string"));
        String pattern = s.deserialize(ByteBuffer.wrap(byteArray.array(), byteArray.offset(), byteArray.length()));
        this.methodParams.set(this.constantPosition, pattern);
        this.constantsInitted = true;
    }

    public String getLikePattern() {
        if (!this.isLikeFunction()) {
            return null;
        }
        this.initConstants();
        return (String)this.methodParams.get(1);
    }

    public boolean isLikeFunction() {
        return "like".equalsIgnoreCase(this.getName());
    }
}

