/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cachesync;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster {
    private static final Logger logger = LoggerFactory.getLogger(Broadcaster.class);
    public static final String SYNC_ALL = "all";
    public static final String SYNC_PRJ_SCHEMA = "project_schema";
    public static final String SYNC_PRJ_DATA = "project_data";
    private static final ConcurrentHashMap<KylinConfig, Broadcaster> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private BlockingDeque<BroadcastEvent> broadcastEvents = new LinkedBlockingDeque<BroadcastEvent>();
    private Map<String, List<Listener>> listenerMap = Maps.newConcurrentMap();
    private AtomicLong counter = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Broadcaster getInstance(KylinConfig config) {
        ConcurrentHashMap<KylinConfig, Broadcaster> concurrentHashMap = CACHE;
        synchronized (concurrentHashMap) {
            Broadcaster r = CACHE.get(config);
            if (r != null) {
                return r;
            }
            r = new Broadcaster(config);
            CACHE.put(config, r);
            if (CACHE.size() > 1) {
                logger.warn("More than one singleton exist");
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        ConcurrentHashMap<KylinConfig, Broadcaster> concurrentHashMap = CACHE;
        synchronized (concurrentHashMap) {
            CACHE.clear();
        }
    }

    private Broadcaster(final KylinConfig config) {
        this.config = config;
        Object[] nodes = config.getRestServers();
        if (nodes == null || nodes.length < 1) {
            logger.warn("There is no available rest server; check the 'kylin.rest.servers' config");
            this.broadcastEvents = null;
            return;
        }
        logger.debug(nodes.length + " nodes in the cluster: " + Arrays.toString(nodes));
        Executors.newSingleThreadExecutor(new DaemonThreadFactory()).execute(new Runnable(){

            @Override
            public void run() {
                ArrayList restClients = Lists.newArrayList();
                for (String node : config.getRestServers()) {
                    restClients.add(new RestClient(node));
                }
                ExecutorService wipingCachePool = Executors.newFixedThreadPool(restClients.size());
                while (true) {
                    try {
                        block4: while (true) {
                            final BroadcastEvent broadcastEvent = (BroadcastEvent)Broadcaster.this.broadcastEvents.takeFirst();
                            logger.info("Announcing new broadcast event: " + broadcastEvent);
                            Iterator i$ = restClients.iterator();
                            while (true) {
                                if (!i$.hasNext()) continue block4;
                                final RestClient restClient = (RestClient)i$.next();
                                wipingCachePool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            restClient.wipeCache(broadcastEvent.getEntity(), broadcastEvent.getEvent(), broadcastEvent.getCacheKey());
                                        }
                                        catch (IOException e) {
                                            logger.warn("Thread failed during wipe cache at " + broadcastEvent);
                                        }
                                    }
                                });
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.error("error running wiping", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(Listener listener, String ... entities) {
        ConcurrentHashMap<KylinConfig, Broadcaster> concurrentHashMap = CACHE;
        synchronized (concurrentHashMap) {
            List<Listener> all = this.listenerMap.get(SYNC_ALL);
            if (all != null && all.contains(listener)) {
                return;
            }
            for (String entity : entities) {
                if (StringUtils.isBlank((String)entity)) continue;
                this.addListener(entity, listener);
            }
            this.addListener(SYNC_ALL, listener);
            this.addListener(SYNC_PRJ_SCHEMA, listener);
            this.addListener(SYNC_PRJ_DATA, listener);
        }
    }

    private void addListener(String entity, Listener listener) {
        List<Listener> list = this.listenerMap.get(entity);
        if (list == null) {
            list = new ArrayList<Listener>();
        }
        list.add(listener);
        this.listenerMap.put(entity, list);
    }

    public void notifyClearAll() throws IOException {
        this.notifyListener(SYNC_ALL, Event.UPDATE, SYNC_ALL);
    }

    public void notifyProjectSchemaUpdate(String project) throws IOException {
        this.notifyListener(SYNC_PRJ_SCHEMA, Event.UPDATE, project);
    }

    public void notifyProjectDataUpdate(String project) throws IOException {
        this.notifyListener(SYNC_PRJ_DATA, Event.UPDATE, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener(String entity, Event event, String cacheKey) throws IOException {
        ConcurrentHashMap<KylinConfig, Broadcaster> concurrentHashMap = CACHE;
        synchronized (concurrentHashMap) {
            ArrayList list = this.listenerMap.get(entity);
            if (list == null) {
                return;
            }
            logger.debug("Broadcasting metadata change: entity=" + entity + ", event=" + (Object)((Object)event) + ", cacheKey=" + cacheKey + ", listeners=" + list);
            list = Lists.newArrayList(list);
            switch (entity) {
                case "all": {
                    for (Listener l : list) {
                        l.onClearAll(this);
                    }
                    Broadcaster.clearCache();
                    break;
                }
                case "project_schema": {
                    ProjectManager.getInstance(this.config).clearL2Cache();
                    for (Listener l : list) {
                        l.onProjectSchemaChange(this, cacheKey);
                    }
                    break;
                }
                case "project_data": {
                    ProjectManager.getInstance(this.config).clearL2Cache();
                    for (Listener l : list) {
                        l.onProjectDataChange(this, cacheKey);
                    }
                    break;
                }
                default: {
                    for (Listener l : list) {
                        l.onEntityChange(this, entity, event, cacheKey);
                    }
                }
            }
            logger.debug("Done broadcasting metadata change: entity=" + entity + ", event=" + (Object)((Object)event) + ", cacheKey=" + cacheKey);
        }
    }

    public void queue(String entity, String event, String key) {
        if (this.broadcastEvents == null) {
            return;
        }
        try {
            this.counter.incrementAndGet();
            this.broadcastEvents.putFirst(new BroadcastEvent(entity, event, key));
        }
        catch (Exception e) {
            this.counter.decrementAndGet();
            logger.error("error putting BroadcastEvent", (Throwable)e);
        }
    }

    public long getCounterAndClear() {
        return this.counter.getAndSet(0L);
    }

    public static class BroadcastEvent {
        private String entity;
        private String event;
        private String cacheKey;

        public BroadcastEvent(String entity, String event, String cacheKey) {
            this.entity = entity;
            this.event = event;
            this.cacheKey = cacheKey;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getEvent() {
            return this.event;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
            result = 31 * result + (this.cacheKey == null ? 0 : this.cacheKey.hashCode());
            result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BroadcastEvent other = (BroadcastEvent)obj;
            if (!StringUtils.equals((String)this.event, (String)other.event)) {
                return false;
            }
            if (!StringUtils.equals((String)this.cacheKey, (String)other.cacheKey)) {
                return false;
            }
            return StringUtils.equals((String)this.entity, (String)other.entity);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("entity", (Object)this.entity).add("event", (Object)this.event).add("cacheKey", (Object)this.cacheKey).toString();
        }
    }

    public static abstract class Listener {
        public void onClearAll(Broadcaster broadcaster) throws IOException {
        }

        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
        }

        public void onProjectDataChange(Broadcaster broadcaster, String project) throws IOException {
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Event event, String cacheKey) throws IOException {
        }
    }

    public static enum Event {
        CREATE("create"),
        UPDATE("update"),
        DROP("drop");

        private String text;

        private Event(String text) {
            this.text = text;
        }

        public String getType() {
            return this.text;
        }

        public static Event getEvent(String event) {
            for (Event one : Event.values()) {
                if (!one.getType().equalsIgnoreCase(event)) continue;
                return one;
            }
            return null;
        }
    }
}

