/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.measure.topn.Counter;
import org.apache.kylin.measure.topn.DoubleDeltaSerializer;
import org.apache.kylin.measure.topn.TopNCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class TopNCounterSerializer
extends DataTypeSerializer<TopNCounter<ByteArray>> {
    private DoubleDeltaSerializer dds = new DoubleDeltaSerializer(3);
    private int precision;

    public TopNCounterSerializer(DataType dataType) {
        this.precision = dataType.getPrecision();
    }

    @Override
    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        int capacity = in.getInt();
        int size = in.getInt();
        int keyLength = in.getInt();
        this.dds.deserialize(in);
        int len = in.position() - mark + keyLength * size;
        in.position(mark);
        return len;
    }

    @Override
    public int maxLength() {
        return this.precision * 50 * 12;
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.precision * 50 * 8;
    }

    @Override
    public void serialize(TopNCounter<ByteArray> value, ByteBuffer out) {
        double[] counters = value.getCounters();
        List<Counter<ByteArray>> peek = value.topK(1);
        int keyLength = peek.size() > 0 ? peek.get(0).getItem().length() : 0;
        out.putInt(value.getCapacity());
        out.putInt(value.size());
        out.putInt(keyLength);
        this.dds.serialize(counters, out);
        Iterator<Counter<ByteArray>> iterator = value.iterator();
        while (iterator.hasNext()) {
            ByteArray item = iterator.next().getItem();
            out.put(item.array(), item.offset(), item.length());
        }
    }

    @Override
    public TopNCounter<ByteArray> deserialize(ByteBuffer in) {
        int capacity = in.getInt();
        int size = in.getInt();
        int keyLength = in.getInt();
        double[] counters = this.dds.deserialize(in);
        TopNCounter<ByteArray> counter = new TopNCounter<ByteArray>(capacity);
        byte[] keyArray = new byte[size * keyLength];
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            in.get(keyArray, offset, keyLength);
            ByteArray byteArray = new ByteArray(keyArray, offset, keyLength);
            counter.offerToHead(byteArray, counters[i]);
            offset += keyLength;
        }
        return counter;
    }
}

