/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.topn.Counter;

public class TopNCounter<T>
implements Iterable<Counter<T>> {
    public static final int EXTRA_SPACE_RATE = 50;
    protected int capacity;
    private HashMap<T, Counter<T>> counterMap;
    protected LinkedList<Counter<T>> counterList;
    private boolean ordered = true;
    private boolean descending = true;
    private static final Comparator ASC_COMPARATOR = new Comparator<Counter>(){

        @Override
        public int compare(Counter o1, Counter o2) {
            return o1.getCount() > o2.getCount() ? 1 : (o1.getCount() == o2.getCount() ? 0 : -1);
        }
    };
    private static final Comparator DESC_COMPARATOR = new Comparator<Counter>(){

        @Override
        public int compare(Counter o1, Counter o2) {
            return o1.getCount() > o2.getCount() ? -1 : (o1.getCount() == o2.getCount() ? 0 : 1);
        }
    };

    public TopNCounter(int capacity) {
        this.capacity = capacity;
        this.counterMap = Maps.newHashMap();
        this.counterList = Lists.newLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public LinkedList<Counter<T>> getCounterList() {
        return this.counterList;
    }

    public void offer(T item) {
        this.offer(item, 1.0);
    }

    public void offer(T item, double incrementCount) {
        Counter<T> counterNode = this.counterMap.get(item);
        if (counterNode == null) {
            counterNode = new Counter<T>(item, incrementCount);
            this.counterMap.put(item, counterNode);
            this.counterList.add(counterNode);
        } else {
            counterNode.setCount(counterNode.getCount() + incrementCount);
        }
        this.ordered = false;
    }

    public void sortAndRetain() {
        Collections.sort(this.counterList, this.descending ? DESC_COMPARATOR : ASC_COMPARATOR);
        this.retain(this.capacity);
        this.ordered = true;
    }

    public List<Counter<T>> topK(int k) {
        if (!this.ordered) {
            this.sortAndRetain();
        }
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (Counter counter : this.counterList) {
            if (topK.size() == k) {
                return topK;
            }
            topK.add(counter);
        }
        return topK;
    }

    public int size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Counter counter : this.counterList) {
            sb.append(counter.item);
            sb.append(':');
            sb.append(counter.count);
        }
        sb.append(']');
        return sb.toString();
    }

    public void offerToHead(T item, double count) {
        Counter<T> c = new Counter<T>(item, count);
        this.counterList.addFirst(c);
        this.counterMap.put(c.item, c);
    }

    public TopNCounter<T> merge(TopNCounter<T> another) {
        Object item;
        double m1 = 0.0;
        double m2 = 0.0;
        if (this.size() >= this.capacity) {
            m1 = this.counterList.getLast().count;
        }
        if (another.size() >= another.capacity) {
            m2 = another.counterList.getLast().count;
        }
        HashSet duplicateItems = Sets.newHashSet();
        ArrayList notDuplicateItems = Lists.newArrayList();
        for (Map.Entry<Object, Counter<Object>> entry : this.counterMap.entrySet()) {
            item = entry.getKey();
            Counter<T> existing = another.counterMap.get(item);
            if (existing != null) {
                duplicateItems.add(item);
                continue;
            }
            notDuplicateItems.add(item);
        }
        for (Map.Entry<Object, Counter<Object>> item2 : duplicateItems) {
            this.offer(item2, another.counterMap.get(item2).count);
        }
        for (Map.Entry<Object, Counter<Object>> item2 : notDuplicateItems) {
            this.offer(item2, m2);
        }
        for (Map.Entry<Object, Counter<Object>> entry : another.counterMap.entrySet()) {
            item = entry.getKey();
            if (duplicateItems.contains(item)) continue;
            double counter = entry.getValue().count;
            this.offer(item, counter + m1);
        }
        this.sortAndRetain();
        return this;
    }

    public void retain(int newCapacity) {
        this.capacity = newCapacity;
        if (this.size() > newCapacity) {
            int n = this.size() - newCapacity;
            for (int i = 0; i < n; ++i) {
                Counter<T> toRemoved = this.counterList.pollLast();
                this.counterMap.remove(toRemoved.item);
            }
        }
    }

    public double[] getCounters() {
        double[] counters = new double[this.size()];
        int index = 0;
        if (this.descending) {
            Iterator<Counter<T>> iterator = this.counterList.descendingIterator();
            while (iterator.hasNext()) {
                Counter<T> b = iterator.next();
                counters[index] = b.count;
                ++index;
            }
        } else {
            throw new IllegalStateException();
        }
        assert (index == this.size());
        return counters;
    }

    @Override
    public Iterator<Counter<T>> iterator() {
        if (this.descending) {
            return this.counterList.descendingIterator();
        }
        throw new IllegalStateException();
    }
}

