/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.hllc.HLLCAggregator;
import org.apache.kylin.measure.hllc.HLLCSerializer;
import org.apache.kylin.measure.hllc.HLLDistinctCountAggFunc;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class HLLCMeasureType
extends MeasureType<HyperLogLogPlusCounter> {
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String DATATYPE_HLLC = "hllc";
    private final DataType dataType;
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"COUNT_DISTINCT", HLLDistinctCountAggFunc.class);

    public HLLCMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        this.validate(functionDesc.getExpression(), functionDesc.getReturnDataType(), true);
    }

    private void validate(String funcName, DataType dataType, boolean checkDataType) {
        if (!FUNC_COUNT_DISTINCT.equals(funcName)) {
            throw new IllegalArgumentException();
        }
        if (!DATATYPE_HLLC.equals(dataType.getName())) {
            throw new IllegalArgumentException();
        }
        if (dataType.getPrecision() < 1 || dataType.getPrecision() > 5000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<HyperLogLogPlusCounter> newIngester() {
        return new MeasureIngester<HyperLogLogPlusCounter>(){
            HyperLogLogPlusCounter current;
            {
                this.current = new HyperLogLogPlusCounter(HLLCMeasureType.this.dataType.getPrecision());
            }

            @Override
            public HyperLogLogPlusCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                HyperLogLogPlusCounter hllc = this.current;
                hllc.clear();
                for (String v : values) {
                    if (v == null) continue;
                    hllc.add(v);
                }
                return hllc;
            }
        };
    }

    @Override
    public MeasureAggregator<HyperLogLogPlusCounter> newAggregator() {
        return new HLLCAggregator(this.dataType.getPrecision());
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    public static boolean isCountDistinct(FunctionDesc func) {
        return FUNC_COUNT_DISTINCT.equalsIgnoreCase(func.getExpression());
    }

    public static class Factory
    extends MeasureTypeFactory<HyperLogLogPlusCounter> {
        @Override
        public MeasureType<HyperLogLogPlusCounter> createMeasureType(String funcName, DataType dataType) {
            return new HLLCMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return HLLCMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return HLLCMeasureType.DATATYPE_HLLC;
        }

        @Override
        public Class<? extends DataTypeSerializer<HyperLogLogPlusCounter>> getAggrDataTypeSerializer() {
            return HLLCSerializer.class;
        }
    }
}

