/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.extendedcolumn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.extendedcolumn.ExtendedColumnSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedColumnMeasureType
extends MeasureType<ByteArray> {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedColumnMeasureType.class);
    public static final String FUNC_RAW = "EXTENDED_COLUMN";
    public static final String DATATYPE_RAW = "extendedcolumn";
    private final DataType dataType;

    public ExtendedColumnMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    public static List<TblColRef> getExtendedColumnHosts(FunctionDesc functionDesc) {
        ArrayList ret = Lists.newArrayList();
        List<TblColRef> params = functionDesc.getParameter().getColRefs();
        for (int i = 0; i < params.size() - 1; ++i) {
            ret.add(params.get(i));
        }
        return ret;
    }

    public static TblColRef getExtendedColumn(FunctionDesc functionDesc) {
        List<TblColRef> params = functionDesc.getParameter().getColRefs();
        return params.get(params.size() - 1);
    }

    @Override
    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
        for (MeasureDesc measureDesc : measureDescs) {
            FunctionDesc extendColumnFunc = measureDesc.getFunction();
            List<TblColRef> hosts = ExtendedColumnMeasureType.getExtendedColumnHosts(extendColumnFunc);
            TblColRef extended = ExtendedColumnMeasureType.getExtendedColumn(extendColumnFunc);
            if (!sqlDigest.groupbyColumns.contains(extended)) continue;
            sqlDigest.aggregations.add(extendColumnFunc);
            sqlDigest.groupbyColumns.remove(extended);
            sqlDigest.groupbyColumns.addAll(hosts);
            sqlDigest.metricColumns.add(extended);
        }
    }

    @Override
    public CapabilityResult.CapabilityInfluence influenceCapabilityCheck(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, MeasureDesc measureDesc) {
        TblColRef extendedCol = ExtendedColumnMeasureType.getExtendedColumn(measureDesc.getFunction());
        if (!unmatchedDimensions.contains(extendedCol)) {
            return null;
        }
        if (digest.filterColumns.contains(extendedCol)) {
            return null;
        }
        unmatchedDimensions.remove(extendedCol);
        return new CapabilityResult.CapabilityInfluence(){

            @Override
            public double suggestCostMultiplier() {
                return 0.9;
            }
        };
    }

    @Override
    public boolean needAdvancedTupleFilling() {
        return true;
    }

    @Override
    public MeasureType.IAdvMeasureFiller getAdvancedTupleFiller(FunctionDesc function, TupleInfo returnTupleInfo, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        int extendedColumnInTupleIdx;
        TblColRef extended = ExtendedColumnMeasureType.getExtendedColumn(function);
        int n = extendedColumnInTupleIdx = returnTupleInfo.hasColumn(extended) ? returnTupleInfo.getColumnIndex(extended) : -1;
        if (extendedColumnInTupleIdx == -1) {
            throw new RuntimeException("Extended column is not required in returnTupleInfo");
        }
        return new MeasureType.IAdvMeasureFiller(){
            private String value;

            @Override
            public void reload(Object measureValue) {
                if (measureValue == null) {
                    this.value = null;
                    return;
                }
                ByteArray byteArray = (ByteArray)measureValue;
                this.value = Bytes.toString(byteArray.array());
            }

            @Override
            public int getNumOfRows() {
                return 1;
            }

            @Override
            public void fillTuple(Tuple tuple, int row) {
                tuple.setDimensionValue(extendedColumnInTupleIdx, this.value);
            }
        };
    }

    @Override
    public MeasureIngester<ByteArray> newIngester() {
        return new MeasureIngester<ByteArray>(){

            public String truncateWhenUTF8(String s, int maxBytes) {
                int b = 0;
                for (int i = 0; i < s.length(); ++i) {
                    int more;
                    char c = s.charAt(i);
                    int skip = 0;
                    if (c <= '\u007f') {
                        more = 1;
                    } else if (c <= '\u07ff') {
                        more = 2;
                    } else if (c <= '\ud7ff') {
                        more = 3;
                    } else if (c <= '\udfff') {
                        more = 4;
                        skip = 1;
                    } else {
                        more = 3;
                    }
                    if (b + more > maxBytes) {
                        return s.substring(0, i);
                    }
                    b += more;
                    i += skip;
                }
                return s;
            }

            @Override
            public ByteArray valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                if (values.length <= 1) {
                    throw new IllegalArgumentException();
                }
                String literal = values[values.length - 1];
                if (literal == null) {
                    return new ByteArray();
                }
                byte[] bytes = Bytes.toBytes(literal);
                if (bytes.length <= ExtendedColumnMeasureType.this.dataType.getPrecision()) {
                    return new ByteArray(bytes);
                }
                return new ByteArray(this.truncateWhenUTF8(literal, ExtendedColumnMeasureType.this.dataType.getPrecision()).getBytes());
            }
        };
    }

    @Override
    public MeasureAggregator<ByteArray> newAggregator() {
        return new MeasureAggregator<ByteArray>(){
            private ByteArray byteArray = null;
            private boolean warned = false;

            @Override
            public void reset() {
                this.byteArray = null;
            }

            @Override
            public void aggregate(ByteArray value) {
                if (this.byteArray == null) {
                    this.byteArray = value;
                } else if (!this.byteArray.equals(value) && !this.warned) {
                    logger.warn("Extended column must be unique given same host column");
                    this.warned = true;
                }
            }

            @Override
            public ByteArray getState() {
                return this.byteArray;
            }

            @Override
            public int getMemBytesEstimate() {
                return ExtendedColumnMeasureType.this.dataType.getPrecision() / 2;
            }
        };
    }

    @Override
    public boolean needRewrite() {
        return false;
    }

    public static class Factory
    extends MeasureTypeFactory<ByteArray> {
        @Override
        public MeasureType<ByteArray> createMeasureType(String funcName, DataType dataType) {
            return new ExtendedColumnMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return ExtendedColumnMeasureType.FUNC_RAW;
        }

        @Override
        public String getAggrDataTypeName() {
            return ExtendedColumnMeasureType.DATATYPE_RAW;
        }

        @Override
        public Class<? extends DataTypeSerializer<ByteArray>> getAggrDataTypeSerializer() {
            return ExtendedColumnSerializer.class;
        }
    }
}

