/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapIntersectDistinctCountAggFunc {
    private static final Logger logger = LoggerFactory.getLogger(BitmapIntersectDistinctCountAggFunc.class);

    public static RetentionPartialResult init() {
        return new RetentionPartialResult();
    }

    public static RetentionPartialResult add(RetentionPartialResult result, Object value, Object key, List keyList) {
        result.add(key, keyList, value);
        return result;
    }

    public static RetentionPartialResult merge(RetentionPartialResult result, Object value, Object key, List keyList) {
        return BitmapIntersectDistinctCountAggFunc.add(result, value, key, keyList);
    }

    public static long result(RetentionPartialResult result) {
        return result.result();
    }

    public static class RetentionPartialResult {
        Map<Object, BitmapCounter> map = new LinkedHashMap<Object, BitmapCounter>();
        List keyList;

        public void add(Object key, List keyList, Object value) {
            BitmapCounter counter;
            if (this.keyList == null) {
                this.keyList = keyList;
            }
            if ((counter = this.map.get(key)) == null) {
                counter = new BitmapCounter();
                this.map.put(key, counter);
            }
            counter.merge((BitmapCounter)value);
        }

        public long result() {
            if (this.keyList == null || this.keyList.isEmpty()) {
                return 0L;
            }
            BitmapCounter counter = null;
            for (Object key : this.keyList) {
                BitmapCounter c = this.map.get(key);
                if (c == null) {
                    return 0L;
                }
                if (counter == null) {
                    counter = c.clone();
                }
                counter.intersect(c);
            }
            return counter.getCount();
        }
    }
}

