/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;

public class BufferedMeasureCodec {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int MAX_BUFFER_SIZE = 0x40000000;
    private final MeasureCodec codec;
    private ByteBuffer buf;
    private final int[] measureSizes;

    public BufferedMeasureCodec(Collection<MeasureDesc> measureDescs) {
        this.codec = new MeasureCodec(measureDescs);
        this.measureSizes = new int[this.codec.getMeasuresCount()];
    }

    public BufferedMeasureCodec(MeasureDesc ... measureDescs) {
        this.codec = new MeasureCodec(measureDescs);
        this.measureSizes = new int[this.codec.getMeasuresCount()];
    }

    public BufferedMeasureCodec(DataType ... dataTypes) {
        this.codec = new MeasureCodec(dataTypes);
        this.measureSizes = new int[this.codec.getMeasuresCount()];
    }

    public BufferedMeasureCodec(String ... dataTypes) {
        this.codec = new MeasureCodec(dataTypes);
        this.measureSizes = new int[this.codec.getMeasuresCount()];
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    public int[] getMeasureSizes() {
        return this.measureSizes;
    }

    public void setBufferSize(int size) {
        this.buf = null;
        this.buf = ByteBuffer.allocate(size);
    }

    public void decode(ByteBuffer buf, Object[] result) {
        this.codec.decode(buf, result);
    }

    public ByteBuffer encode(Object[] values) {
        if (this.buf == null) {
            this.setBufferSize(0x100000);
        }
        assert (values.length == this.codec.getMeasuresCount());
        while (true) {
            try {
                this.buf.clear();
                int pos = 0;
                for (int i = 0; i < this.codec.getMeasuresCount(); ++i) {
                    this.codec.encode(i, values[i], this.buf);
                    this.measureSizes[i] = this.buf.position() - pos;
                    pos = this.buf.position();
                }
                return this.buf;
            }
            catch (BufferOverflowException boe) {
                if (this.buf.capacity() >= 0x40000000) {
                    throw boe;
                }
                this.setBufferSize(this.buf.capacity() * 2);
                continue;
            }
            break;
        }
    }
}

