/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTSampleCodeSystem;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.LongMutable;

public class UnitTestSupport {
    public static GTInfo basicInfo() {
        GTInfo.Builder builder = UnitTestSupport.infoBuilder();
        GTInfo info = builder.build();
        return info;
    }

    public static GTInfo advancedInfo() {
        GTInfo.Builder builder = UnitTestSupport.infoBuilder();
        builder.enableColumnBlock(new ImmutableBitSet[]{UnitTestSupport.setOf(0), UnitTestSupport.setOf(1, 2), UnitTestSupport.setOf(3, 4)});
        builder.enableRowBlock(4);
        return builder.build();
    }

    public static GTInfo hllInfo() {
        GTInfo.Builder builder = GTInfo.builder();
        builder.setCodeSystem(new GTSampleCodeSystem());
        builder.setColumns(DataType.getType("varchar(10)"), DataType.getType("varchar(10)"), DataType.getType("varchar(10)"), DataType.getType("bigint"), DataType.getType("decimal"), DataType.getType("hllc14"));
        builder.setPrimaryKey(UnitTestSupport.setOf(0));
        builder.setColumnPreferIndex(UnitTestSupport.setOf(0));
        return builder.build();
    }

    private static GTInfo.Builder infoBuilder() {
        GTInfo.Builder builder = GTInfo.builder();
        builder.setCodeSystem(new GTSampleCodeSystem());
        builder.setColumns(DataType.getType("varchar(10)"), DataType.getType("varchar(10)"), DataType.getType("varchar(10)"), DataType.getType("bigint"), DataType.getType("decimal"));
        builder.setPrimaryKey(UnitTestSupport.setOf(0));
        builder.setColumnPreferIndex(UnitTestSupport.setOf(0));
        return builder;
    }

    public static List<GTRecord> mockupData(GTInfo info, int nRows) {
        ArrayList<GTRecord> result = new ArrayList<GTRecord>(nRows);
        int round = nRows / 10;
        for (int i = 0; i < round; ++i) {
            String d_01_14 = UnitTestSupport.datePlus("2015-01-14", i * 4);
            String d_01_15 = UnitTestSupport.datePlus("2015-01-15", i * 4);
            String d_01_16 = UnitTestSupport.datePlus("2015-01-16", i * 4);
            String d_01_17 = UnitTestSupport.datePlus("2015-01-17", i * 4);
            result.add(UnitTestSupport.newRec(info, d_01_14, "Yang", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_14, "Luke", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_15, "Xu", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_15, "Dong", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_15, "Jason", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_16, "Mahone", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_16, "Shaofeng", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_16, "Qianhao", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_16, "George", "Food", new LongMutable(10L), new BigDecimal("10.5")));
            result.add(UnitTestSupport.newRec(info, d_01_17, "Kejia", "Food", new LongMutable(10L), new BigDecimal("10.5")));
        }
        return result;
    }

    public static List<GTRecord> mockupHllData(GTInfo info, int nRows) {
        ArrayList<GTRecord> result = new ArrayList<GTRecord>(nRows);
        int round = nRows / 10;
        for (int i = 0; i < round; ++i) {
            String d_01_14 = UnitTestSupport.datePlus("2015-01-14", i * 4);
            String d_01_15 = UnitTestSupport.datePlus("2015-01-15", i * 4);
            String d_01_16 = UnitTestSupport.datePlus("2015-01-16", i * 4);
            String d_01_17 = UnitTestSupport.datePlus("2015-01-17", i * 4);
            result.add(UnitTestSupport.newRec(info, d_01_14, "Yang", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_14, "Luke", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_15, "Xu", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_15, "Dong", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_15, "Jason", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_16, "Mahone", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_16, "Shaofeng", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_16, "Qianhao", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_16, "George", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
            result.add(UnitTestSupport.newRec(info, d_01_17, "Kejia", "Food", new LongMutable(10L), new BigDecimal("10.5"), new HyperLogLogPlusCounter(14)));
        }
        return result;
    }

    private static String datePlus(String date, int plusDays) {
        long millis = DateFormat.stringToMillis(date);
        return DateFormat.formatToDateStr(millis += 86400000L * (long)plusDays);
    }

    private static GTRecord newRec(GTInfo info, Object ... values) {
        GTRecord rec = new GTRecord(info);
        return rec.setValues(values);
    }

    private static ImmutableBitSet setOf(int ... values) {
        BitSet set = new BitSet();
        for (int i : values) {
            set.set(i);
        }
        return new ImmutableBitSet(set);
    }
}

