/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.dict.lookup.SnapshotTableSerializer;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.ReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotManager {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotManager.class);
    private static final ConcurrentHashMap<KylinConfig, SnapshotManager> SERVICE_CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private LoadingCache<String, SnapshotTable> snapshotCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SnapshotManager getInstance(KylinConfig config) {
        SnapshotManager r = SERVICE_CACHE.get(config);
        if (r != null) return r;
        Class<SnapshotManager> clazz = SnapshotManager.class;
        synchronized (SnapshotManager.class) {
            r = SERVICE_CACHE.get(config);
            if (r != null) return r;
            r = new SnapshotManager(config);
            SERVICE_CACHE.put(config, r);
            if (SERVICE_CACHE.size() <= 1) return r;
            logger.warn("More than one singleton exist");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    private SnapshotManager(KylinConfig config) {
        this.config = config;
        this.snapshotCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, SnapshotTable>(){

            public void onRemoval(RemovalNotification<String, SnapshotTable> notification) {
                logger.info("Snapshot with resource path " + (String)notification.getKey() + " is removed due to " + notification.getCause());
            }
        }).maximumSize((long)config.getCachedSnapshotMaxEntrySize()).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, SnapshotTable>(){

            public SnapshotTable load(String key) throws Exception {
                SnapshotTable snapshotTable = SnapshotManager.this.load(key, true);
                return snapshotTable;
            }
        });
    }

    public void wipeoutCache() {
        this.snapshotCache.invalidateAll();
    }

    public SnapshotTable getSnapshotTable(String resourcePath) throws IOException {
        try {
            SnapshotTable r = (SnapshotTable)this.snapshotCache.get((Object)resourcePath);
            if (r == null) {
                r = this.load(resourcePath, true);
                this.snapshotCache.put((Object)resourcePath, (Object)r);
            }
            return r;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void removeSnapshot(String resourcePath) throws IOException {
        ResourceStore store = MetadataManager.getInstance(this.config).getStore();
        store.deleteResource(resourcePath);
        this.snapshotCache.invalidate((Object)resourcePath);
    }

    public SnapshotTable buildSnapshot(ReadableTable table, TableDesc tableDesc) throws IOException {
        SnapshotTable snapshot = new SnapshotTable(table, tableDesc.getIdentity());
        snapshot.updateRandomUuid();
        String dup = this.checkDupByInfo(snapshot);
        if (dup != null) {
            logger.info("Identical input " + table.getSignature() + ", reuse existing snapshot at " + dup);
            return this.getSnapshotTable(dup);
        }
        if (snapshot.getSignature().getSize() / 1024L / 1024L > (long)this.config.getTableSnapshotMaxMB()) {
            throw new IllegalStateException("Table snapshot should be no greater than " + this.config.getTableSnapshotMaxMB() + " MB, but " + tableDesc + " size is " + snapshot.getSignature().getSize());
        }
        snapshot.takeSnapshot(table, tableDesc);
        return this.trySaveNewSnapshot(snapshot);
    }

    public SnapshotTable rebuildSnapshot(ReadableTable table, TableDesc tableDesc, String overwriteUUID) throws IOException {
        SnapshotTable snapshot = new SnapshotTable(table, tableDesc.getIdentity());
        snapshot.setUuid(overwriteUUID);
        snapshot.takeSnapshot(table, tableDesc);
        SnapshotTable existing = this.getSnapshotTable(snapshot.getResourcePath());
        snapshot.setLastModified(existing.getLastModified());
        this.save(snapshot);
        this.snapshotCache.put((Object)snapshot.getResourcePath(), (Object)snapshot);
        return snapshot;
    }

    public SnapshotTable trySaveNewSnapshot(SnapshotTable snapshotTable) throws IOException {
        String dupTable = this.checkDupByContent(snapshotTable);
        if (dupTable != null) {
            logger.info("Identical snapshot content " + snapshotTable + ", reuse existing snapshot at " + dupTable);
            return this.getSnapshotTable(dupTable);
        }
        this.save(snapshotTable);
        this.snapshotCache.put((Object)snapshotTable.getResourcePath(), (Object)snapshotTable);
        return snapshotTable;
    }

    private String checkDupByInfo(SnapshotTable snapshot) throws IOException {
        String resourceDir;
        ResourceStore store = MetadataManager.getInstance(this.config).getStore();
        NavigableSet<String> existings = store.listResources(resourceDir = snapshot.getResourceDir());
        if (existings == null) {
            return null;
        }
        ReadableTable.TableSignature sig = snapshot.getSignature();
        for (String existing : existings) {
            SnapshotTable existingTable = this.load(existing, false);
            if (existingTable == null || !sig.equals(existingTable.getSignature())) continue;
            return existing;
        }
        return null;
    }

    private String checkDupByContent(SnapshotTable snapshot) throws IOException {
        String resourceDir;
        ResourceStore store = MetadataManager.getInstance(this.config).getStore();
        NavigableSet<String> existings = store.listResources(resourceDir = snapshot.getResourceDir());
        if (existings == null) {
            return null;
        }
        for (String existing : existings) {
            SnapshotTable existingTable = this.load(existing, true);
            if (existingTable == null || !existingTable.equals(snapshot)) continue;
            return existing;
        }
        return null;
    }

    private void save(SnapshotTable snapshot) throws IOException {
        ResourceStore store = MetadataManager.getInstance(this.config).getStore();
        String path = snapshot.getResourcePath();
        store.putResource(path, snapshot, SnapshotTableSerializer.FULL_SERIALIZER);
    }

    private SnapshotTable load(String resourcePath, boolean loadData) throws IOException {
        logger.info("Loading snapshotTable from " + resourcePath + ", with loadData: " + loadData);
        ResourceStore store = MetadataManager.getInstance(this.config).getStore();
        SnapshotTable table = store.getResource(resourcePath, SnapshotTable.class, loadData ? SnapshotTableSerializer.FULL_SERIALIZER : SnapshotTableSerializer.INFO_SERIALIZER);
        if (loadData) {
            logger.debug("Loaded snapshot at " + resourcePath);
        }
        return table;
    }
}

