/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryValueEnumerator;

public class MultipleDictionaryValueEnumerator
implements IDictionaryValueEnumerator {
    private int curDictIndex = 0;
    private Dictionary curDict;
    private int curKey;
    private byte[] curValue = null;
    private List<Dictionary> dictionaryList;

    public MultipleDictionaryValueEnumerator(List<DictionaryInfo> dictionaryInfoList) {
        this.dictionaryList = Lists.newArrayListWithCapacity((int)dictionaryInfoList.size());
        for (DictionaryInfo dictInfo : dictionaryInfoList) {
            this.dictionaryList.add(dictInfo.getDictionaryObject());
        }
        if (!this.dictionaryList.isEmpty()) {
            this.curDict = this.dictionaryList.get(0);
            this.curKey = this.curDict.getMinId();
        }
    }

    @Override
    public byte[] current() throws IOException {
        return this.curValue;
    }

    @Override
    public boolean moveNext() throws IOException {
        while (this.curDictIndex < this.dictionaryList.size()) {
            if (this.curKey <= this.curDict.getMaxId()) {
                byte[] buffer = new byte[this.curDict.getSizeOfValue()];
                int size = this.curDict.getValueBytesFromId(this.curKey, buffer, 0);
                this.curValue = Bytes.copy(buffer, 0, size);
                ++this.curKey;
                return true;
            }
            if (++this.curDictIndex >= this.dictionaryList.size()) continue;
            this.curDict = this.dictionaryList.get(this.curDictIndex);
            this.curKey = this.curDict.getMinId();
        }
        this.curValue = null;
        return false;
    }

    @Override
    public void close() throws IOException {
    }
}

