/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.AppendTrieDictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.metadata.MetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDictionaryBuilder
implements IDictionaryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GlobalDictionaryBuilder.class);

    @Override
    public Dictionary<String> build(DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList<String> returnSamples) throws IOException {
        AppendTrieDictionary.Builder builder;
        if (dictInfo == null) {
            throw new IllegalArgumentException("GlobalDictinaryBuilder must used with an existing DictionaryInfo");
        }
        String dictDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/GlobalDict" + dictInfo.getResourceDir() + "/";
        NavigableSet<String> dicts = MetadataManager.getInstance(KylinConfig.getInstanceFromEnv()).getStore().listResources(dictInfo.getResourceDir());
        ArrayList<String> appendDicts = new ArrayList<String>();
        if (dicts != null && !dicts.isEmpty()) {
            for (String string : dicts) {
                DictionaryInfo info = MetadataManager.getInstance(KylinConfig.getInstanceFromEnv()).getStore().getResource(string, DictionaryInfo.class, DictionaryInfoSerializer.INFO_SERIALIZER);
                if (!info.getDictionaryClass().equals(AppendTrieDictionary.class.getName())) continue;
                appendDicts.add(string);
            }
        }
        if (appendDicts.isEmpty()) {
            logger.info("GlobalDict {} is empty, create new one", (Object)dictInfo.getResourceDir());
            builder = AppendTrieDictionary.Builder.create(dictDir);
        } else if (appendDicts.size() == 1) {
            logger.info("GlobalDict {} exist, append value", appendDicts.get(0));
            AppendTrieDictionary appendTrieDictionary = (AppendTrieDictionary)DictionaryManager.getInstance(KylinConfig.getInstanceFromEnv()).getDictionary((String)appendDicts.get(0));
            builder = AppendTrieDictionary.Builder.create(appendTrieDictionary);
        } else {
            throw new IllegalStateException(String.format("GlobalDict %s should have 0 or 1 append dict but %d", dictInfo.getResourceDir(), appendDicts.size()));
        }
        while (valueEnumerator.moveNext()) {
            byte[] byArray = valueEnumerator.current();
            if (byArray == null) continue;
            String v = Bytes.toString(byArray);
            builder.addValue(v);
            if (returnSamples.size() >= nSamples || returnSamples.contains(v)) continue;
            returnSamples.add(v);
        }
        return builder.build(baseId);
    }
}

