/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTreeMap<K extends WritableComparable, V extends Writable>
extends TreeMap<K, V>
implements Writable {
    private static final Logger logger = LoggerFactory.getLogger(CachedTreeMap.class);
    private final Class<K> keyClazz;
    private final Class<V> valueClazz;
    volatile transient Collection<V> values;
    private final LoadingCache<K, V> valueCache;
    private final TreeSet<String> fileList;
    private final Configuration conf;
    private final String baseDir;
    private final String tmpDir;
    private final FileSystem fs;
    private final boolean persistent;
    private final boolean immutable;
    private long writeValueTime = 0L;
    private long readValueTime = 0L;
    private static final int BUFFER_SIZE = 0x800000;

    private CachedTreeMap(int maxCount, Class<K> keyClazz, Class<V> valueClazz, String baseDir, boolean persistent, boolean immutable) throws IOException {
        this.keyClazz = keyClazz;
        this.valueClazz = valueClazz;
        this.fileList = new TreeSet();
        this.conf = new Configuration();
        this.baseDir = baseDir.endsWith("/") ? baseDir.substring(0, baseDir.length() - 1) : baseDir;
        this.tmpDir = this.baseDir + ".tmp";
        this.fs = FileSystem.get((URI)new Path(baseDir).toUri(), (Configuration)this.conf);
        this.persistent = persistent;
        this.immutable = immutable;
        CacheBuilder builder = CacheBuilder.newBuilder().removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> notification) {
                logger.info(String.format("Evict cache key %s(%d) with value %s caused by %s, size %d/%d ", notification.getKey(), ((WritableComparable)notification.getKey()).hashCode(), notification.getValue(), notification.getCause(), CachedTreeMap.this.size(), CachedTreeMap.this.valueCache.size()));
                switch (notification.getCause()) {
                    case SIZE: {
                        CachedTreeMap.this.writeValue((WritableComparable)notification.getKey(), (Writable)notification.getValue());
                        break;
                    }
                    case EXPLICIT: {
                        CachedTreeMap.this.deleteValue((WritableComparable)notification.getKey());
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected evict reason " + notification.getCause());
                    }
                }
            }
        });
        if (this.immutable) {
            builder.softValues();
        } else {
            builder.maximumSize((long)maxCount);
            if (this.fs.exists(new Path(this.tmpDir))) {
                this.fs.delete(new Path(this.tmpDir), true);
            }
            if (this.fs.exists(new Path(this.baseDir))) {
                FileUtil.copy((FileSystem)this.fs, (Path)new Path(this.baseDir), (FileSystem)this.fs, (Path)new Path(this.tmpDir), (boolean)false, (boolean)true, (Configuration)this.conf);
            } else {
                this.fs.mkdirs(new Path(this.baseDir));
            }
        }
        this.valueCache = builder.build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                Writable value = CachedTreeMap.this.readValue(key);
                logger.info(String.format("Load cache by key %s(%d) with value %s", key, key.hashCode(), value));
                return value;
            }
        });
    }

    private String generateFileName(K key) {
        String file = (this.immutable ? this.baseDir : this.tmpDir) + "/cached_" + key.toString();
        return file;
    }

    public String getCurrentDir() {
        return this.immutable ? this.baseDir : this.tmpDir;
    }

    public void commit(boolean stillMutable) throws IOException {
        assert (!this.immutable) : "Only support commit method with immutable false";
        Path basePath = new Path(this.baseDir);
        Path backupPath = new Path(this.baseDir + ".bak");
        Path tmpPath = new Path(this.tmpDir);
        try {
            this.fs.rename(basePath, backupPath);
        }
        catch (IOException e) {
            logger.info("CachedTreeMap commit backup basedir failed, " + e, (Throwable)e);
            throw e;
        }
        try {
            if (stillMutable) {
                FileUtil.copy((FileSystem)this.fs, (Path)tmpPath, (FileSystem)this.fs, (Path)basePath, (boolean)false, (boolean)true, (Configuration)this.conf);
            } else {
                this.fs.rename(tmpPath, basePath);
            }
            this.fs.delete(backupPath, true);
        }
        catch (IOException e) {
            this.fs.rename(backupPath, basePath);
            logger.info("CachedTreeMap commit move/copy tmpdir failed, " + e, (Throwable)e);
            throw e;
        }
    }

    public void loadEntry(CachedTreeMap other) {
        for (Object key : other.keySet()) {
            super.put((WritableComparable)key, null);
        }
    }

    private void writeValue(K key, V value) {
        if (this.immutable) {
            return;
        }
        long t0 = System.currentTimeMillis();
        String fileName = this.generateFileName(key);
        Path filePath = new Path(fileName);
        try (FSDataOutputStream out = this.fs.create(filePath, true, 0x800000, (short)5, 0x4000000L);){
            value.write((DataOutput)out);
            if (!this.persistent) {
                this.fs.deleteOnExit(filePath);
            }
        }
        catch (Exception e) {
            logger.error(String.format("write value into %s exception: %s", fileName, e), (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
        finally {
            this.fileList.add(fileName);
            this.writeValueTime += System.currentTimeMillis() - t0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private V readValue(K key) throws Exception {
        long t0 = System.currentTimeMillis();
        String fileName = this.generateFileName(key);
        Path filePath = new Path(fileName);
        try {
            Writable writable;
            Throwable throwable;
            FSDataInputStream input;
            block17: {
                block18: {
                    input = this.fs.open(filePath, 0x800000);
                    throwable = null;
                    Writable value = (Writable)this.valueClazz.newInstance();
                    value.readFields((DataInput)input);
                    writable = value;
                    if (input == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        input.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    break block17;
                }
                input.close();
            }
            return (V)writable;
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (input != null) {
                            if (throwable != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("read value from %s exception: %s", fileName, e), (Throwable)e);
                    throwable = null;
                    return (V)throwable;
                }
            }
        }
        finally {
            this.readValueTime += System.currentTimeMillis() - t0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValue(K key) {
        if (this.persistent && this.immutable) {
            return;
        }
        String fileName = this.generateFileName(key);
        Path filePath = new Path(fileName);
        try {
            if (this.fs.exists(filePath)) {
                this.fs.delete(filePath, true);
            }
        }
        catch (Exception e) {
            logger.error(String.format("delete value file %s exception: %s", fileName, e), (Throwable)e);
        }
        finally {
            this.fileList.remove(fileName);
        }
    }

    @Override
    public V put(K key, V value) {
        assert (!this.immutable) : "Only support put method with immutable false";
        super.put(key, null);
        this.valueCache.put(key, value);
        return null;
    }

    @Override
    public V get(Object key) {
        if (super.containsKey(key)) {
            try {
                return (V)((Writable)this.valueCache.get((Object)((WritableComparable)key)));
            }
            catch (ExecutionException e) {
                logger.error(String.format("get value with key %s exception: ", key, e), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        assert (!this.immutable) : "Only support remove method with immutable false";
        super.remove(key);
        this.valueCache.invalidate(key);
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.values = null;
        this.valueCache.invalidateAll();
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public void write(DataOutput out) throws IOException {
        assert (this.persistent) : "Only support serialize with persistent true";
        out.writeInt(this.size());
        for (WritableComparable key : this.keySet()) {
            key.write(out);
            Writable value = (Writable)this.valueCache.getIfPresent((Object)key);
            if (null == value) continue;
            this.writeValue(key, value);
        }
    }

    public void readFields(DataInput in) throws IOException {
        assert (this.persistent) : "Only support deserialize with persistent true";
        int size = in.readInt();
        try {
            for (int i = 0; i < size; ++i) {
                WritableComparable key = (WritableComparable)this.keyClazz.newInstance();
                key.readFields(in);
                super.put(key, null);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        if (this.persistent) {
            return;
        }
        try {
            this.clear();
            for (String file : this.fileList) {
                try {
                    Path filePath = new Path(file);
                    this.fs.delete(filePath, true);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    class ValueIterator<V>
    implements Iterator<V> {
        Iterator<K> keyIterator;
        K currentKey;

        public ValueIterator() {
            this.keyIterator = CachedTreeMap.this.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext();
        }

        @Override
        public V next() {
            this.currentKey = (WritableComparable)this.keyIterator.next();
            try {
                return (V)CachedTreeMap.this.valueCache.get(this.currentKey);
            }
            catch (ExecutionException e) {
                logger.error(String.format("get value with key %s exception: ", this.currentKey, e), (Throwable)e);
                return null;
            }
        }

        @Override
        public void remove() {
            assert (!CachedTreeMap.this.immutable) : "Only support remove method with immutable false";
            this.keyIterator.remove();
            CachedTreeMap.this.valueCache.invalidate(this.currentKey);
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CachedTreeMap.this.size();
        }
    }

    public static class CachedTreeMapBuilder<K, V> {
        private Class<K> keyClazz;
        private Class<V> valueClazz;
        private int maxCount = 8;
        private String baseDir;
        private boolean persistent;
        private boolean immutable;

        public static CachedTreeMapBuilder newBuilder() {
            return new CachedTreeMapBuilder();
        }

        private CachedTreeMapBuilder() {
        }

        public CachedTreeMapBuilder keyClazz(Class<K> clazz) {
            this.keyClazz = clazz;
            return this;
        }

        public CachedTreeMapBuilder valueClazz(Class<V> clazz) {
            this.valueClazz = clazz;
            return this;
        }

        public CachedTreeMapBuilder<K, V> maxSize(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public CachedTreeMapBuilder<K, V> baseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public CachedTreeMapBuilder<K, V> persistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public CachedTreeMapBuilder<K, V> immutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public CachedTreeMap build() throws IOException {
            if (this.baseDir == null) {
                throw new RuntimeException("CachedTreeMap need a baseDir to cache data");
            }
            if (this.keyClazz == null || this.valueClazz == null) {
                throw new RuntimeException("CachedTreeMap need key and value clazz to serialize data");
            }
            CachedTreeMap map = new CachedTreeMap(this.maxCount, this.keyClazz, this.valueClazz, this.baseDir, this.persistent, this.immutable);
            return map;
        }
    }
}

