/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.CachedTreeMap;
import org.apache.kylin.dict.StringBytesConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendTrieDictionary<T>
extends Dictionary<T> {
    public static final byte[] HEAD_MAGIC = new byte[]{65, 112, 112, 101, 99, 100, 84, 114, 105, 101, 68, 105, 99, 116};
    public static final int HEAD_SIZE_I = HEAD_MAGIC.length;
    public static final int BIT_IS_LAST_CHILD = 128;
    public static final int BIT_IS_END_OF_VALUE = 64;
    private static final Logger logger = LoggerFactory.getLogger(AppendTrieDictionary.class);
    private transient String baseDir;
    private transient int baseId;
    private transient int maxId;
    private transient int maxValueLength;
    private transient int nValues;
    private transient BytesConverter<T> bytesConverter;
    private TreeMap<DictSliceKey, DictSlice> dictSliceMap;
    private transient boolean enableValueCache = true;
    private transient SoftReference<HashMap> valueToIdCache;

    public AppendTrieDictionary() {
        if (this.enableValueCache) {
            this.valueToIdCache = new SoftReference(new HashMap());
        }
    }

    public void update(String baseDir, int baseId, int maxId, int maxValueLength, int nValues, BytesConverter bytesConverter, CachedTreeMap dictMap) throws IOException {
        this.baseDir = baseDir;
        this.baseId = baseId;
        this.maxId = maxId;
        this.maxValueLength = maxValueLength;
        this.nValues = nValues;
        this.bytesConverter = bytesConverter;
        int cacheSize = KylinConfig.getInstanceFromEnv().getAppendDictCacheSize();
        this.dictSliceMap = CachedTreeMap.CachedTreeMapBuilder.newBuilder().maxSize(cacheSize).baseDir(baseDir).persistent(true).immutable(true).keyClazz(DictSliceKey.class).valueClazz(DictSlice.class).build();
        ((CachedTreeMap)this.dictSliceMap).loadEntry(dictMap);
    }

    public byte[] writeDictMap() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        ((Writable)this.dictSliceMap).write((DataOutput)out);
        byte[] dictMapBytes = buf.toByteArray();
        buf.close();
        out.close();
        return dictMapBytes;
    }

    @Override
    protected int getIdFromValueBytesImpl(byte[] value, int offset, int len, int roundingFlag) {
        DictSlice slice;
        int id;
        if (this.dictSliceMap.isEmpty()) {
            return -1;
        }
        byte[] tempVal = new byte[len];
        System.arraycopy(value, offset, tempVal, 0, len);
        DictSliceKey sliceKey = this.dictSliceMap.floorKey(DictSliceKey.wrap(tempVal));
        if (sliceKey == null) {
            sliceKey = this.dictSliceMap.firstKey();
        }
        if ((id = (slice = this.dictSliceMap.get(sliceKey)).getIdFromValueBytesImpl(value, offset, len, roundingFlag)) < 0) {
            logger.error("Not a valid value: " + this.bytesConverter.convertFromBytes(value, offset, len));
        }
        return id;
    }

    @Override
    public int getMinId() {
        return this.baseId;
    }

    @Override
    public int getMaxId() {
        return this.maxId;
    }

    @Override
    public int getSizeOfId() {
        return 4;
    }

    @Override
    public int getSizeOfValue() {
        return this.maxValueLength;
    }

    @Override
    protected final int getIdFromValueImpl(T value, int roundingFlag) {
        HashMap cache;
        if (this.enableValueCache && roundingFlag == 0 && (cache = this.valueToIdCache.get()) != null) {
            Integer id = null;
            id = (Integer)cache.get(value);
            if (id != null) {
                return id;
            }
            byte[] valueBytes = this.bytesConverter.convertToBytes(value);
            id = this.getIdFromValueBytes(valueBytes, 0, valueBytes.length, roundingFlag);
            cache.put(value, id);
            return id;
        }
        byte[] valueBytes = this.bytesConverter.convertToBytes(value);
        return this.getIdFromValueBytes(valueBytes, 0, valueBytes.length, roundingFlag);
    }

    @Override
    protected final T getValueFromIdImpl(int id) {
        throw new UnsupportedOperationException("AppendTrieDictionary can't retrive value from id");
    }

    @Override
    protected byte[] getValueBytesFromIdImpl(int id) {
        throw new UnsupportedOperationException("AppendTrieDictionary can't retrive value from id");
    }

    @Override
    protected int getValueBytesFromIdImpl(int id, byte[] returnValue, int offset) {
        throw new UnsupportedOperationException("AppendTrieDictionary can't retrive value from id");
    }

    public void flushIndex(CachedTreeMap dictSliceMap) throws IOException {
        Path filePath = new Path(dictSliceMap.getCurrentDir() + "/.index");
        Configuration conf = new Configuration();
        try (FSDataOutputStream indexOut = FileSystem.get((URI)filePath.toUri(), (Configuration)conf).create(filePath, true, 0x800000, (short)5, 0x4000000L);){
            indexOut.writeInt(this.baseId);
            indexOut.writeInt(this.maxId);
            indexOut.writeInt(this.maxValueLength);
            indexOut.writeInt(this.nValues);
            indexOut.writeUTF(this.bytesConverter.getClass().getName());
            dictSliceMap.write((DataOutput)indexOut);
        }
        dictSliceMap.commit(false);
    }

    @Override
    public AppendTrieDictionary copyToAnotherMeta(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        Configuration conf = new Configuration();
        AppendTrieDictionary<T> newDict = new AppendTrieDictionary<T>();
        newDict.update(this.baseDir.replaceFirst(srcConfig.getHdfsWorkingDirectory(), dstConfig.getHdfsWorkingDirectory()), this.baseId, this.maxId, this.maxValueLength, this.nValues, this.bytesConverter, (CachedTreeMap)this.dictSliceMap);
        logger.info("Copy AppendDict from {} to {}", (Object)this.baseDir, (Object)newDict.baseDir);
        Path srcPath = new Path(this.baseDir);
        Path dstPath = new Path(newDict.baseDir);
        FileSystem dstFs = FileSystem.get((URI)dstPath.toUri(), (Configuration)conf);
        if (dstFs.exists(dstPath)) {
            logger.info("Delete existing AppendDict {}", (Object)dstPath);
            dstFs.delete(dstPath, true);
        }
        FileUtil.copy((FileSystem)FileSystem.get((URI)srcPath.toUri(), (Configuration)conf), (Path)srcPath, (FileSystem)FileSystem.get((URI)dstPath.toUri(), (Configuration)conf), (Path)dstPath, (boolean)false, (boolean)true, (Configuration)conf);
        return newDict;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.baseDir);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String baseDir = in.readUTF();
        Path filePath = new Path(baseDir + "/.index");
        Configuration conf = new Configuration();
        try (FSDataInputStream input = FileSystem.get((URI)filePath.toUri(), (Configuration)conf).open(filePath, 0x800000);){
            int baseId = input.readInt();
            int maxId = input.readInt();
            int maxValueLength = input.readInt();
            int nValues = input.readInt();
            String converterName = input.readUTF();
            BytesConverter converter = null;
            if (!converterName.isEmpty()) {
                try {
                    converter = ClassUtil.forName(converterName, BytesConverter.class).newInstance();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            CachedTreeMap dictMap = CachedTreeMap.CachedTreeMapBuilder.newBuilder().baseDir(baseDir).persistent(true).immutable(true).keyClazz(DictSliceKey.class).valueClazz(DictSlice.class).build();
            dictMap.readFields((DataInput)input);
            this.update(baseDir, baseId, maxId, maxValueLength, nValues, converter, dictMap);
        }
    }

    @Override
    public void dump(PrintStream out) {
        out.println("Total " + this.nValues + " values, " + (this.dictSliceMap == null ? 0 : this.dictSliceMap.size()) + " slice");
    }

    public int hashCode() {
        int hashCode = 31;
        for (DictSlice slice : this.dictSliceMap.values()) {
            hashCode += 31 * slice.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public boolean contains(Dictionary other) {
        return false;
    }

    public static class Builder<T> {
        private String baseDir;
        private int maxId;
        private int maxValueLength;
        private int nValues;
        private BytesConverter<T> bytesConverter;
        private AppendTrieDictionary dict;
        private TreeMap<DictSliceKey, DictNode> mutableDictSliceMap;
        private static int MAX_ENTRY_IN_SLICE = 10000000;
        private static final double MAX_ENTRY_OVERHEAD_FACTOR = 1.0;
        private int processedCount = 0;

        public static Builder create(String baseDir) throws IOException {
            return new Builder<String>(null, baseDir, 0, 0, 0, new StringBytesConverter(), null);
        }

        public static Builder create(AppendTrieDictionary dict) throws IOException {
            return new Builder(dict, dict.baseDir, dict.maxId, dict.maxValueLength, dict.nValues, dict.bytesConverter, dict.writeDictMap());
        }

        private Builder(AppendTrieDictionary dict, String baseDir, int maxId, int maxValueLength, int nValues, BytesConverter<T> bytesConverter, byte[] dictMapBytes) throws IOException {
            this.dict = dict;
            this.baseDir = baseDir;
            this.maxId = maxId;
            this.maxValueLength = maxValueLength;
            this.nValues = nValues;
            this.bytesConverter = bytesConverter;
            MAX_ENTRY_IN_SLICE = KylinConfig.getInstanceFromEnv().getAppendDictEntrySize();
            int cacheSize = KylinConfig.getInstanceFromEnv().getAppendDictCacheSize();
            this.mutableDictSliceMap = CachedTreeMap.CachedTreeMapBuilder.newBuilder().maxSize(cacheSize).baseDir(baseDir).keyClazz(DictSliceKey.class).valueClazz(DictNode.class).persistent(true).immutable(false).build();
            if (dictMapBytes != null) {
                ((Writable)this.mutableDictSliceMap).readFields((DataInput)new DataInputStream(new ByteArrayInputStream(dictMapBytes)));
            }
        }

        public void addValue(T value) {
            this.addValue(this.bytesConverter.convertToBytes(value));
        }

        public void addValue(byte[] value) {
            DictSliceKey sliceKey;
            if (++this.processedCount % 1000000 == 0) {
                logger.debug("add value count " + this.processedCount);
            }
            this.maxValueLength = Math.max(this.maxValueLength, value.length);
            if (this.mutableDictSliceMap.isEmpty()) {
                DictNode root = new DictNode(new byte[0], false);
                this.mutableDictSliceMap.put(DictSliceKey.wrap(new byte[0]), root);
            }
            if ((sliceKey = this.mutableDictSliceMap.floorKey(DictSliceKey.wrap(value))) == null) {
                sliceKey = this.mutableDictSliceMap.firstKey();
            }
            DictNode root = this.mutableDictSliceMap.get(sliceKey);
            this.addValueR(root, value, 0);
            if ((double)root.childrenCount > (double)MAX_ENTRY_IN_SLICE * 1.0) {
                this.mutableDictSliceMap.remove(sliceKey);
                DictNode newRoot = this.splitNodeTree(root);
                DictNode.mergeSingleByteNode(root, 1);
                DictNode.mergeSingleByteNode(newRoot, 0);
                this.mutableDictSliceMap.put(DictSliceKey.wrap(root.firstValue()), root);
                this.mutableDictSliceMap.put(DictSliceKey.wrap(newRoot.firstValue()), newRoot);
            }
        }

        private DictNode splitNodeTree(DictNode root) {
            DictNode parent = root;
            int childCountToSplit = (int)((double)MAX_ENTRY_IN_SLICE * 1.0 / 2.0);
            block0: while (true) {
                ArrayList<DictNode> children;
                if ((children = parent.children).size() == 0) break;
                if (children.size() == 1) {
                    parent = (DictNode)children.get(0);
                    continue;
                }
                int i = children.size() - 1;
                while (true) {
                    if (i < 0) continue block0;
                    parent = (DictNode)children.get(i);
                    if (childCountToSplit > ((DictNode)children.get((int)i)).childrenCount) {
                        childCountToSplit -= ((DictNode)children.get((int)i)).childrenCount;
                    } else {
                        --childCountToSplit;
                        continue block0;
                    }
                    --i;
                }
                break;
            }
            DictNode splitNode = parent;
            return DictNode.splitNodeTree(splitNode);
        }

        private int createNextId() {
            int id = ++this.maxId;
            if (this.maxId < 0) {
                throw new IllegalArgumentException("AppendTrieDictionary Id overflow Integer.MAX_VALUE");
            }
            ++this.nValues;
            return id;
        }

        private void addValueR(DictNode node, byte[] value, int start) {
            DictNode c;
            int j;
            assert (value.length - start <= 255) : "value bytes overflow than 255";
            int i = 0;
            int n = node.part.length;
            int nn = value.length;
            int comp = 0;
            for (j = start; i < n && j < nn && (comp = BytesUtil.compareByteUnsigned(node.part[i], value[j])) == 0; ++i, ++j) {
            }
            if (j == nn) {
                if (i == n) {
                    if (!node.isEndOfValue) {
                        node.id = this.createNextId();
                    }
                    node.isEndOfValue = true;
                } else {
                    DictNode c2 = new DictNode(BytesUtil.subarray(node.part, i, n), node.isEndOfValue, node.children);
                    c2.id = node.id;
                    node.reset(BytesUtil.subarray(node.part, 0, i), true);
                    node.addChild(c2);
                    node.id = this.createNextId();
                }
                return;
            }
            if (i < n) {
                DictNode c1 = new DictNode(BytesUtil.subarray(node.part, i, n), node.isEndOfValue, node.children);
                c1.id = node.id;
                DictNode c2 = new DictNode(BytesUtil.subarray(value, j, nn), true);
                c2.id = this.createNextId();
                node.reset(BytesUtil.subarray(node.part, 0, i), false);
                if (comp < 0) {
                    node.addChild(c1);
                    node.addChild(c2);
                } else {
                    node.addChild(c2);
                    node.addChild(c1);
                }
                return;
            }
            byte lookfor = value[j];
            int lo = 0;
            int hi = node.children.size() - 1;
            int mid = 0;
            boolean found = false;
            comp = 0;
            while (!found && lo <= hi) {
                mid = lo + (hi - lo) / 2;
                c = node.children.get(mid);
                comp = BytesUtil.compareByteUnsigned(lookfor, c.part[0]);
                if (comp < 0) {
                    hi = mid - 1;
                    continue;
                }
                if (comp > 0) {
                    lo = mid + 1;
                    continue;
                }
                found = true;
            }
            if (found) {
                this.addValueR(node.children.get(mid), value, j);
            } else {
                c = new DictNode(BytesUtil.subarray(value, j, nn), true);
                c.id = this.createNextId();
                node.addChild(comp <= 0 ? mid : mid + 1, c);
            }
        }

        public AppendTrieDictionary<T> build(int baseId) throws IOException {
            if (this.dict == null) {
                this.dict = new AppendTrieDictionary();
            }
            this.dict.update(this.baseDir, baseId, this.maxId, this.maxValueLength, this.nValues, this.bytesConverter, (CachedTreeMap)this.mutableDictSliceMap);
            this.dict.flushIndex((CachedTreeMap)this.mutableDictSliceMap);
            return this.dict;
        }
    }

    public static class Stats {
        public int nValues;
        public int nValueBytesPlain;
        public int nValueBytesCompressed;
        public int maxValueLength;
        public int mbpn_nNodes;
        public int mbpn_trieDepth;
        public int mbpn_maxFanOut;
        public int mbpn_nChildLookups;
        public int mbpn_nTotalFanOut;
        public int mbpn_sizeValueTotal;
        public int mbpn_sizeNoValueBytes;
        public int mbpn_sizeChildOffset;
        public int mbpn_sizeId;
        public int mbpn_footprint;

        private static void traverseR(DictNode node, Visitor visitor, int level) {
            visitor.visit(node, level);
            for (DictNode c : node.children) {
                Stats.traverseR(c, visitor, level + 1);
            }
        }

        private static void traversePostOrderR(DictNode node, Visitor visitor, int level) {
            for (DictNode c : node.children) {
                Stats.traversePostOrderR(c, visitor, level + 1);
            }
            visitor.visit(node, level);
        }

        public static Stats stats(DictNode root) {
            int t;
            Stats.traversePostOrderR(root, new Visitor(){

                @Override
                public void visit(DictNode n, int level) {
                    n.nValuesBeneath = n.isEndOfValue ? 1 : 0;
                    for (DictNode c : n.children) {
                        n.nValuesBeneath += c.nValuesBeneath;
                    }
                }
            }, 0);
            final Stats s = new Stats();
            final ArrayList lenAtLvl = new ArrayList();
            Stats.traverseR(root, new Visitor(){

                @Override
                public void visit(DictNode n, int level) {
                    if (n.isEndOfValue) {
                        ++s.nValues;
                    }
                    s.nValueBytesPlain += n.part.length * n.nValuesBeneath;
                    s.nValueBytesCompressed += n.part.length;
                    ++s.mbpn_nNodes;
                    if (s.mbpn_trieDepth < level + 1) {
                        s.mbpn_trieDepth = level + 1;
                    }
                    if (n.children.size() > 0) {
                        if (s.mbpn_maxFanOut < n.children.size()) {
                            s.mbpn_maxFanOut = n.children.size();
                        }
                        int childLookups = n.nValuesBeneath - (n.isEndOfValue ? 1 : 0);
                        s.mbpn_nChildLookups += childLookups;
                        s.mbpn_nTotalFanOut += childLookups * n.children.size();
                    }
                    if (level < lenAtLvl.size()) {
                        lenAtLvl.set(level, n.part.length);
                    } else {
                        lenAtLvl.add(n.part.length);
                    }
                    int lenSoFar = 0;
                    for (int i = 0; i <= level; ++i) {
                        lenSoFar += ((Integer)lenAtLvl.get(i)).intValue();
                    }
                    if (lenSoFar > s.maxValueLength) {
                        s.maxValueLength = lenSoFar;
                    }
                }
            }, 0);
            s.mbpn_sizeId = 4;
            s.mbpn_sizeValueTotal = s.nValueBytesCompressed + s.nValues * s.mbpn_sizeId;
            s.mbpn_sizeNoValueBytes = 1;
            s.mbpn_sizeChildOffset = 4;
            s.mbpn_footprint = s.mbpn_sizeValueTotal + s.mbpn_nNodes * (s.mbpn_sizeNoValueBytes + s.mbpn_sizeChildOffset);
            while (BytesUtil.sizeForValue((t = s.mbpn_sizeValueTotal + s.mbpn_nNodes * (s.mbpn_sizeNoValueBytes + s.mbpn_sizeChildOffset - 1)) * 4) <= s.mbpn_sizeChildOffset - 1) {
                --s.mbpn_sizeChildOffset;
                s.mbpn_footprint = t;
            }
            return s;
        }

        public void print(DictNode root) {
            this.print(root, System.out);
        }

        public void print(DictNode root, final PrintStream out) {
            Stats.traverseR(root, new Visitor(){

                @Override
                public void visit(DictNode n, int level) {
                    try {
                        for (int i = 0; i < level; ++i) {
                            out.print("  ");
                        }
                        out.print(new String(n.part, "UTF-8"));
                        out.print(" - ");
                        if (n.nValuesBeneath > 0) {
                            out.print(n.nValuesBeneath);
                        }
                        if (n.isEndOfValue) {
                            out.print("* [" + n.id + "]");
                        }
                        out.print("\n");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }, 0);
        }

        public static interface Visitor {
            public void visit(DictNode var1, int var2);
        }
    }

    public static class DictNode
    implements Writable {
        public byte[] part;
        public int id = -1;
        public boolean isEndOfValue;
        public ArrayList<DictNode> children = new ArrayList();
        public int nValuesBeneath;
        public DictNode parent;
        public int childrenCount = 1;

        public DictNode() {
        }

        public void clone(DictNode o) {
            this.part = o.part;
            this.id = o.id;
            this.isEndOfValue = o.isEndOfValue;
            this.children = o.children;
            this.nValuesBeneath = o.nValuesBeneath;
            this.parent = o.parent;
            this.childrenCount = o.childrenCount;
        }

        DictNode(byte[] value, boolean isEndOfValue) {
            this.reset(value, isEndOfValue);
        }

        DictNode(byte[] value, boolean isEndOfValue, ArrayList<DictNode> children) {
            this.reset(value, isEndOfValue, children);
        }

        void reset(byte[] value, boolean isEndOfValue) {
            this.reset(value, isEndOfValue, new ArrayList<DictNode>());
        }

        void reset(byte[] value, boolean isEndOfValue, ArrayList<DictNode> children) {
            this.part = value;
            this.isEndOfValue = isEndOfValue;
            this.clearChild();
            for (DictNode child : children) {
                this.addChild(child);
            }
            this.id = -1;
        }

        void clearChild() {
            this.children.clear();
            int childrenCountDelta = this.childrenCount - 1;
            DictNode p = this;
            while (p != null) {
                p.childrenCount -= childrenCountDelta;
                p = p.parent;
            }
        }

        void addChild(DictNode child) {
            this.addChild(-1, child);
        }

        void addChild(int index, DictNode child) {
            child.parent = this;
            if (index < 0) {
                this.children.add(child);
            } else {
                this.children.add(index, child);
            }
            DictNode p = this;
            while (p != null) {
                p.childrenCount += child.childrenCount;
                p = p.parent;
            }
        }

        public DictNode removeChild(int index) {
            DictNode child = this.children.remove(index);
            child.parent = null;
            DictNode p = this;
            while (p != null) {
                p.childrenCount -= child.childrenCount;
                p = p.parent;
            }
            return child;
        }

        public DictNode duplicateNode() {
            DictNode newChild = new DictNode(this.part, false);
            newChild.parent = this.parent;
            if (this.parent != null) {
                int index = this.parent.children.indexOf(this);
                this.parent.addChild(index + 1, newChild);
            }
            return newChild;
        }

        public byte[] firstValue() {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DictNode p = this;
            while (true) {
                bytes.write(p.part, 0, p.part.length);
                if (p.isEndOfValue || p.children.size() == 0) break;
                p = p.children.get(0);
            }
            return bytes.toByteArray();
        }

        public static DictNode splitNodeTree(DictNode splitNode) {
            if (splitNode == null) {
                return null;
            }
            DictNode current = splitNode;
            DictNode p = current.parent;
            while (p != null) {
                int index = p.children.indexOf(current);
                assert (index != -1);
                DictNode newParent = p.duplicateNode();
                for (int i = p.children.size() - 1; i >= index; --i) {
                    DictNode child = p.removeChild(i);
                    newParent.addChild(0, child);
                }
                current = newParent;
                p = p.parent;
            }
            return current;
        }

        public static void mergeSingleByteNode(DictNode root, int leftOrRight) {
            DictNode current = root;
            while (!current.children.isEmpty()) {
                DictNode child;
                DictNode dictNode = child = leftOrRight == 0 ? current.children.get(0) : current.children.get(current.children.size() - 1);
                if (current.children.size() > 1 || current.isEndOfValue) {
                    current = child;
                    continue;
                }
                byte[] newValue = new byte[current.part.length + child.part.length];
                System.arraycopy(current.part, 0, newValue, 0, current.part.length);
                System.arraycopy(child.part, 0, newValue, current.part.length, child.part.length);
                current.reset(newValue, child.isEndOfValue, child.children);
                current.id = child.id;
            }
        }

        public void write(DataOutput out) throws IOException {
            byte[] bytes = this.buildTrieBytes();
            out.write(bytes);
        }

        public void readFields(DataInput in) throws IOException {
            DictNode root = DictSlice.rebuildNodeByDeserialize(in);
            this.clone(root);
        }

        protected byte[] buildTrieBytes() {
            byte[] head;
            Stats stats = Stats.stats(this);
            int sizeChildOffset = stats.mbpn_sizeChildOffset;
            int sizeId = stats.mbpn_sizeId;
            try {
                ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
                DataOutputStream headOut = new DataOutputStream(byteBuf);
                headOut.write(HEAD_MAGIC);
                headOut.writeShort(0);
                headOut.writeInt(stats.mbpn_footprint);
                headOut.writeInt(stats.nValues);
                headOut.write(sizeChildOffset);
                headOut.write(sizeId);
                headOut.close();
                head = byteBuf.toByteArray();
                BytesUtil.writeUnsigned(head.length, head, HEAD_SIZE_I, 2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] trieBytes = new byte[stats.mbpn_footprint + head.length];
            System.arraycopy(head, 0, trieBytes, 0, head.length);
            LinkedList<DictNode> open = new LinkedList<DictNode>();
            IdentityHashMap<DictNode, Integer> offsetMap = new IdentityHashMap<DictNode, Integer>();
            int o = head.length;
            offsetMap.put(this, o);
            o = this.build_writeNode(this, o, true, sizeChildOffset, sizeId, trieBytes);
            if (!this.children.isEmpty()) {
                open.addLast(this);
            }
            while (!open.isEmpty()) {
                DictNode parent = (DictNode)open.removeFirst();
                this.build_overwriteChildOffset((Integer)offsetMap.get(parent), o - head.length, sizeChildOffset, trieBytes);
                for (int i = 0; i < parent.children.size(); ++i) {
                    DictNode c = parent.children.get(i);
                    boolean isLastChild = i == parent.children.size() - 1;
                    offsetMap.put(c, o);
                    o = this.build_writeNode(c, o, isLastChild, sizeChildOffset, sizeId, trieBytes);
                    if (c.children.isEmpty()) continue;
                    open.addLast(c);
                }
            }
            if (o != trieBytes.length) {
                throw new RuntimeException();
            }
            return trieBytes;
        }

        private void build_overwriteChildOffset(int parentOffset, int childOffset, int sizeChildOffset, byte[] trieBytes) {
            int flags = trieBytes[parentOffset] & 0xC0;
            BytesUtil.writeUnsigned(childOffset, trieBytes, parentOffset, sizeChildOffset);
            int n = parentOffset;
            trieBytes[n] = (byte)(trieBytes[n] | flags);
        }

        private int build_writeNode(DictNode n, int offset, boolean isLastChild, int sizeChildOffset, int sizeId, byte[] trieBytes) {
            int o = offset;
            if (isLastChild) {
                int n2 = o;
                trieBytes[n2] = (byte)(trieBytes[n2] | 0x80);
            }
            if (n.isEndOfValue) {
                int n3 = o;
                trieBytes[n3] = (byte)(trieBytes[n3] | 0x40);
            }
            o += sizeChildOffset;
            if (n.part.length > 255) {
                throw new RuntimeException();
            }
            BytesUtil.writeUnsigned(n.part.length, trieBytes, o, 1);
            System.arraycopy(n.part, 0, trieBytes, ++o, n.part.length);
            o += n.part.length;
            if (n.isEndOfValue) {
                assert (n.id > 0);
                BytesUtil.writeUnsigned(n.id, trieBytes, o, sizeId);
                o += sizeId;
            }
            return o;
        }

        public String toString() {
            return String.format("DictNode[root=%s, nodes=%d, firstValue=%s]", Bytes.toStringBinary(this.part), this.childrenCount, Bytes.toStringBinary(this.firstValue()));
        }
    }

    public static class DictSlice<T>
    implements Writable {
        private byte[] trieBytes;
        private transient int headSize;
        private transient int bodyLen;
        private transient int sizeChildOffset;
        private transient int nValues;
        private transient int sizeOfId;
        private transient int childOffsetMask;
        private transient int firstByteOffset;

        public DictSlice() {
        }

        public DictSlice(byte[] trieBytes) {
            this.init(trieBytes);
        }

        private void init(byte[] trieBytes) {
            this.trieBytes = trieBytes;
            if (BytesUtil.compareBytes(HEAD_MAGIC, 0, trieBytes, 0, HEAD_MAGIC.length) != 0) {
                throw new IllegalArgumentException("Wrong file type (magic does not match)");
            }
            try {
                DataInputStream headIn = new DataInputStream(new ByteArrayInputStream(trieBytes, HEAD_SIZE_I, trieBytes.length - HEAD_SIZE_I));
                this.headSize = headIn.readShort();
                this.bodyLen = headIn.readInt();
                this.nValues = headIn.readInt();
                this.sizeChildOffset = headIn.read();
                this.sizeOfId = headIn.read();
                this.childOffsetMask = ~(192 << (this.sizeChildOffset - 1) * 8);
                this.firstByteOffset = this.sizeChildOffset + 1;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        public byte[] getFirstValue() {
            int nodeOffset = this.headSize;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            do {
                int valueLen = BytesUtil.readUnsigned(this.trieBytes, nodeOffset + this.firstByteOffset - 1, 1);
                bytes.write(this.trieBytes, nodeOffset + this.firstByteOffset, valueLen);
            } while (!this.checkFlag(nodeOffset, 64) && (nodeOffset = this.headSize + (BytesUtil.readUnsigned(this.trieBytes, nodeOffset, this.sizeChildOffset) & this.childOffsetMask)) != this.headSize);
            return bytes.toByteArray();
        }

        /*
         * Exception decompiling
         */
        private int lookupSeqNoFromValue(int n, byte[] inp, int o, int inpEnd, int roundingFlag) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getStructuredStatement(GotoStatement.java:116)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean checkFlag(int offset, int bit) {
            return (this.trieBytes[offset] & bit) > 0;
        }

        public int getIdFromValueBytesImpl(byte[] value, int offset, int len, int roundingFlag) {
            int id = this.lookupSeqNoFromValue(this.headSize, value, offset, offset + len, roundingFlag);
            return id;
        }

        private DictNode rebuildTrieTree() {
            return this.rebuildTrieTreeR(this.headSize, null);
        }

        private DictNode rebuildTrieTreeR(int n, DictNode parent) {
            DictNode root = null;
            while (true) {
                int p = n + this.firstByteOffset;
                int childOffset = BytesUtil.readUnsigned(this.trieBytes, n, this.sizeChildOffset) & this.childOffsetMask;
                int parLen = BytesUtil.readUnsigned(this.trieBytes, p - 1, 1);
                boolean isEndOfValue = this.checkFlag(n, 64);
                byte[] value = new byte[parLen];
                System.arraycopy(this.trieBytes, p, value, 0, parLen);
                DictNode node = new DictNode(value, isEndOfValue);
                if (isEndOfValue) {
                    int id;
                    node.id = id = BytesUtil.readUnsigned(this.trieBytes, p + parLen, this.sizeOfId);
                }
                if (parent == null) {
                    root = node;
                } else {
                    parent.addChild(node);
                }
                if (childOffset != 0) {
                    this.rebuildTrieTreeR(childOffset + this.headSize, node);
                }
                if (this.checkFlag(n, 128)) break;
                n += this.firstByteOffset + parLen + (isEndOfValue ? this.sizeOfId : 0);
            }
            return root;
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.trieBytes);
        }

        public void readFields(DataInput in) throws IOException {
            byte[] headPartial = new byte[HEAD_MAGIC.length + 2 + 4];
            in.readFully(headPartial);
            if (BytesUtil.compareBytes(HEAD_MAGIC, 0, headPartial, 0, HEAD_MAGIC.length) != 0) {
                throw new IllegalArgumentException("Wrong file type (magic does not match)");
            }
            DataInputStream headIn = new DataInputStream(new ByteArrayInputStream(headPartial, HEAD_SIZE_I, headPartial.length - HEAD_SIZE_I));
            short headSize = headIn.readShort();
            int bodyLen = headIn.readInt();
            headIn.close();
            byte[] all = new byte[headSize + bodyLen];
            System.arraycopy(headPartial, 0, all, 0, headPartial.length);
            in.readFully(all, headPartial.length, all.length - headPartial.length);
            this.init(all);
        }

        public static DictNode rebuildNodeByDeserialize(DataInput in) throws IOException {
            DictSlice slice = new DictSlice();
            slice.readFields(in);
            return super.rebuildTrieTree();
        }

        public String toString() {
            return String.format("DictSlice[firstValue=%s, values=%d, bytes=%d]", Bytes.toStringBinary(this.getFirstValue()), this.nValues, this.bodyLen);
        }

        public int hashCode() {
            return Arrays.hashCode(this.trieBytes);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DictSlice)) {
                logger.info("Equals return false because it's not DictInfo");
                return false;
            }
            DictSlice that = (DictSlice)o;
            return Arrays.equals(this.trieBytes, that.trieBytes);
        }
    }

    public static class DictSliceKey
    implements WritableComparable {
        byte[] key;

        public static DictSliceKey wrap(byte[] key) {
            DictSliceKey dictKey = new DictSliceKey();
            dictKey.key = key;
            return dictKey;
        }

        public String toString() {
            return Bytes.toStringBinary(this.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public int compareTo(Object o) {
            if (!(o instanceof DictSliceKey)) {
                return -1;
            }
            DictSliceKey other = (DictSliceKey)o;
            return Bytes.compareTo(this.key, other.key);
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.key.length);
            out.write(this.key);
        }

        public void readFields(DataInput in) throws IOException {
            this.key = new byte[in.readInt()];
            in.readFully(this.key);
        }
    }
}

