/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.metadata.model.TblColRef;

public class StreamingCubeRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        if (cube.getFactTableDesc().getSourceType() != 1) {
            return;
        }
        if (cube.getLookupTableDescs() != null && cube.getLookupTableDescs().size() > 0) {
            context.addResult(ResultLevel.ERROR, "Streaming Cube doesn't support star-schema so far; only one fact table is allowed.");
            return;
        }
        if (cube.getModel().getPartitionDesc() == null || cube.getModel().getPartitionDesc().getPartitionDateColumn() == null) {
            context.addResult(ResultLevel.ERROR, "Must define a partition column.");
            return;
        }
        TblColRef partitionCol = cube.getModel().getPartitionDesc().getPartitionDateColumnRef();
        boolean found = false;
        block0: for (DimensionDesc dimensionDesc : cube.getDimensions()) {
            for (TblColRef dimCol : dimensionDesc.getColumnRefs()) {
                if (!dimCol.equals(partitionCol)) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            context.addResult(ResultLevel.ERROR, "Partition column '" + partitionCol + "' isn't in dimension list.");
            return;
        }
    }
}

