/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;

public class AggregationGroupRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        this.inner(cube, context);
    }

    private void inner(CubeDesc cube, ValidateContext context) {
        int index = 0;
        for (AggregationGroup agg : cube.getAggregationGroups()) {
            if (agg.getIncludes() == null) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " 'includes' field not set");
                continue;
            }
            if (agg.getSelectRule() == null) {
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " 'select rule' field not set");
                continue;
            }
            long combination = 1L;
            TreeSet<String> includeDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getIncludes() != null) {
                for (String include : agg.getIncludes()) {
                    includeDims.add(include);
                }
            }
            TreeSet<String> mandatoryDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getSelectRule().mandatory_dims != null) {
                for (String m : agg.getSelectRule().mandatory_dims) {
                    mandatoryDims.add(m);
                }
            }
            TreeSet<String> hierarchyDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getSelectRule().hierarchy_dims != null) {
                String[][] arr$ = agg.getSelectRule().hierarchy_dims;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] ss;
                    for (String s : ss = arr$[i$]) {
                        hierarchyDims.add(s);
                    }
                    combination *= (long)(ss.length + 1);
                }
            }
            TreeSet<String> jointDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (agg.getSelectRule().joint_dims != null) {
                String[][] arr$ = agg.getSelectRule().joint_dims;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] ss;
                    for (String s : ss = arr$[i$]) {
                        jointDims.add(s);
                    }
                    combination *= 2L;
                }
            }
            if (!(includeDims.containsAll(mandatoryDims) && includeDims.containsAll(hierarchyDims) && includeDims.containsAll(jointDims))) {
                ArrayList notIncluded = Lists.newArrayList();
                Iterable all = Iterables.unmodifiableIterable((Iterable)Iterables.concat(mandatoryDims, hierarchyDims, jointDims));
                for (String dim : all) {
                    if (includeDims.contains(dim)) continue;
                    notIncluded.add(dim);
                }
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " 'includes' dimensions not include all the dimensions:" + ((Object)notIncluded).toString());
                continue;
            }
            TreeSet<String> normalDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            normalDims.addAll(includeDims);
            normalDims.removeAll(mandatoryDims);
            normalDims.removeAll(hierarchyDims);
            normalDims.removeAll(jointDims);
            combination *= 1L << normalDims.size();
            if (CollectionUtils.containsAny(mandatoryDims, hierarchyDims)) {
                TreeSet intersection = new TreeSet(mandatoryDims);
                intersection.retainAll(hierarchyDims);
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " mandatory dimension has overlap with hierarchy dimension: " + ((Object)intersection).toString());
                continue;
            }
            if (CollectionUtils.containsAny(mandatoryDims, jointDims)) {
                HashSet intersection = new HashSet(mandatoryDims);
                intersection.retainAll(jointDims);
                context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " mandatory dimension has overlap with joint dimension: " + ((Object)intersection).toString());
                continue;
            }
            int jointDimNum = 0;
            if (agg.getSelectRule().joint_dims != null) {
                for (String[] joints : agg.getSelectRule().joint_dims) {
                    TreeSet<String> oneJoint = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    for (String s : joints) {
                        oneJoint.add(s);
                    }
                    if (oneJoint.size() < 2) {
                        context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " require at least 2 dimensions in a joint: " + ((Object)oneJoint).toString());
                        continue;
                    }
                    jointDimNum += oneJoint.size();
                    int overlapHierarchies = 0;
                    if (agg.getSelectRule().hierarchy_dims == null) continue;
                    for (String[] oneHierarchy : agg.getSelectRule().hierarchy_dims) {
                        TreeSet<String> oneHierarchySet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                        for (String s : oneHierarchy) {
                            oneHierarchySet.add(s);
                        }
                        Sets.SetView share = Sets.intersection(oneJoint, oneHierarchySet);
                        if (!share.isEmpty()) {
                            ++overlapHierarchies;
                        }
                        if (share.size() <= 1) continue;
                        context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " joint dimensions has overlap with more than 1 dimensions in same hierarchy: " + share.toString());
                    }
                    if (overlapHierarchies <= true) continue;
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " joint dimensions has overlap with more than 1 hierarchies");
                }
                if (jointDimNum != jointDims.size()) {
                    TreeSet existing = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    TreeSet overlap = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    for (String[] joints : agg.getSelectRule().joint_dims) {
                        TreeSet<String> oneJoint = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                        for (String s : joints) {
                            oneJoint.add(s);
                        }
                        if (CollectionUtils.containsAny(existing, oneJoint)) {
                            overlap.addAll(Sets.intersection(existing, oneJoint));
                        }
                        existing.addAll(oneJoint);
                    }
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " a dimension exists in more than one joint: " + ((Object)overlap).toString());
                    continue;
                }
            }
            if (combination > (long)this.getMaxCombinations(cube)) {
                String msg = "Aggregation group " + index + " has too many combinations, current combination is " + combination + ", max allowed combination is " + this.getMaxCombinations(cube) + "; use 'mandatory'/'hierarchy'/'joint' to optimize; or update 'kylin.cube.aggrgroup.max.combination' to a bigger value.";
                context.addResult(ResultLevel.ERROR, msg);
                continue;
            }
            ++index;
        }
    }

    protected int getMaxCombinations(CubeDesc cubeDesc) {
        return cubeDesc.getConfig().getCubeAggrGroupMaxCombination();
    }
}

