/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DimensionDesc {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="derived")
    private String[] derived;
    private TableRef tableRef;
    private JoinDesc join;
    private TblColRef[] columnRefs;

    public void init(CubeDesc cubeDesc) {
        if (this.name != null) {
            this.name = this.name.toUpperCase();
        }
        if (this.table != null) {
            this.table = this.table.toUpperCase();
        }
        DataModelDesc model = cubeDesc.getModel();
        this.tableRef = model.findTable(this.getTable());
        if (this.tableRef == null) {
            throw new IllegalStateException("Can't find table " + this.table + " for dimension " + this.name);
        }
        this.join = null;
        for (LookupDesc lookup : model.getLookups()) {
            if (!lookup.getTableRef().equals(this.tableRef)) continue;
            this.join = lookup.getJoin();
            break;
        }
        if (this.derived != null && this.derived.length == 0) {
            this.derived = null;
        }
        if (this.derived != null) {
            StringUtil.toUpperCaseArray(this.derived, this.derived);
        }
        if (this.derived != null && this.join == null) {
            throw new IllegalStateException("Derived can only be defined on lookup table, cube " + cubeDesc + ", " + this);
        }
    }

    public boolean isDerived() {
        return this.derived != null;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public JoinDesc getJoin() {
        return this.join;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TblColRef[] getColumnRefs() {
        return this.columnRefs;
    }

    public void setColumnRefs(TblColRef[] colRefs) {
        this.columnRefs = colRefs;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String[] getDerived() {
        return this.derived;
    }

    public void setDerived(String[] derived) {
        this.derived = derived;
    }

    public TableRef getTableRef() {
        return this.tableRef;
    }

    public boolean equals(Object o) {
        throw new NotImplementedException();
    }

    public int hashCode() {
        throw new NotImplementedException();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("table", (Object)this.table).add("column", (Object)this.column).add("derived", (Object)Arrays.toString(this.derived)).add("join", (Object)this.join).toString();
    }
}

