/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AggregationGroup {
    @JsonProperty(value="includes")
    private String[] includes;
    @JsonProperty(value="select_rule")
    private SelectRule selectRule;
    private long partialCubeFullMask;
    private long mandatoryColumnMask;
    private List<HierarchyMask> hierarchyMasks;
    private List<Long> joints;
    private long jointDimsMask;
    private long normalDimsMask;
    private long hierarchyDimsMask;
    private List<Long> normalDims;
    private CubeDesc cubeDesc;
    private boolean isMandatoryOnlyValid;

    public void init(CubeDesc cubeDesc, RowKeyDesc rowKeyDesc) {
        this.cubeDesc = cubeDesc;
        this.isMandatoryOnlyValid = cubeDesc.getConfig().getCubeAggrGroupIsMandatoryOnlyValid();
        if (this.includes == null || this.includes.length == 0 || this.selectRule == null) {
            throw new IllegalStateException("AggregationGroup incomplete");
        }
        this.columnNamesToUpperCase();
        this.buildPartialCubeFullMask(rowKeyDesc);
        this.buildMandatoryColumnMask(rowKeyDesc);
        this.buildHierarchyMasks(rowKeyDesc);
        this.buildJointColumnMask(rowKeyDesc);
        this.buildJointDimsMask();
        this.buildNormalDimsMask();
        this.buildHierarchyDimsMask();
    }

    private void columnNamesToUpperCase() {
        StringUtil.toUpperCaseArray(this.includes, this.includes);
        StringUtil.toUpperCaseArray(this.selectRule.mandatory_dims, this.selectRule.mandatory_dims);
        if (this.selectRule.hierarchy_dims != null) {
            for (String[] cols : this.selectRule.hierarchy_dims) {
                StringUtil.toUpperCaseArray(cols, cols);
            }
        }
        if (this.selectRule.joint_dims != null) {
            for (String[] cols : this.selectRule.joint_dims) {
                StringUtil.toUpperCaseArray(cols, cols);
            }
        }
    }

    private void buildPartialCubeFullMask(RowKeyDesc rowKeyDesc) {
        Preconditions.checkState((this.includes != null ? 1 : 0) != 0);
        Preconditions.checkState((this.includes.length != 0 ? 1 : 0) != 0);
        this.partialCubeFullMask = 0L;
        for (String dim : this.includes) {
            TblColRef hColumn = this.cubeDesc.getModel().findColumn(dim);
            Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
            long bit = 1L << index;
            this.partialCubeFullMask |= bit;
        }
    }

    private void buildJointColumnMask(RowKeyDesc rowKeyDesc) {
        this.joints = Lists.newArrayList();
        if (this.selectRule.joint_dims == null || this.selectRule.joint_dims.length == 0) {
            return;
        }
        for (String[] joint_dims : this.selectRule.joint_dims) {
            if (joint_dims == null || joint_dims.length == 0) continue;
            long joint = 0L;
            for (int i = 0; i < joint_dims.length; ++i) {
                TblColRef hColumn = this.cubeDesc.getModel().findColumn(joint_dims[i]);
                Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
                long bit = 1L << index;
                joint |= bit;
            }
            Preconditions.checkState((joint != 0L ? 1 : 0) != 0);
            this.joints.add(joint);
        }
    }

    private void buildMandatoryColumnMask(RowKeyDesc rowKeyDesc) {
        this.mandatoryColumnMask = 0L;
        String[] mandatory_dims = this.selectRule.mandatory_dims;
        if (mandatory_dims == null || mandatory_dims.length == 0) {
            return;
        }
        for (String dim : mandatory_dims) {
            TblColRef hColumn = this.cubeDesc.getModel().findColumn(dim);
            Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
            this.mandatoryColumnMask |= 1L << index;
        }
    }

    private void buildHierarchyMasks(RowKeyDesc rowKeyDesc) {
        this.hierarchyMasks = new ArrayList<HierarchyMask>();
        if (this.selectRule.hierarchy_dims == null || this.selectRule.hierarchy_dims.length == 0) {
            return;
        }
        for (String[] hierarchy_dims : this.selectRule.hierarchy_dims) {
            int i;
            HierarchyMask mask = new HierarchyMask();
            if (hierarchy_dims == null || hierarchy_dims.length == 0) continue;
            ArrayList<Long> allMaskList = new ArrayList<Long>();
            ArrayList<Long> dimList = new ArrayList<Long>();
            for (i = 0; i < hierarchy_dims.length; ++i) {
                TblColRef hColumn = this.cubeDesc.getModel().findColumn(hierarchy_dims[i]);
                Integer index = rowKeyDesc.getColumnBitIndex(hColumn);
                long bit = 1L << index;
                mask.fullMask |= bit;
                allMaskList.add(mask.fullMask);
                dimList.add(bit);
            }
            Preconditions.checkState((allMaskList.size() == dimList.size() ? 1 : 0) != 0);
            mask.allMasks = new long[allMaskList.size()];
            mask.dims = new long[dimList.size()];
            for (i = 0; i < allMaskList.size(); ++i) {
                mask.allMasks[i] = (Long)allMaskList.get(i);
                mask.dims[i] = (Long)dimList.get(i);
            }
            this.hierarchyMasks.add(mask);
        }
    }

    private void buildNormalDimsMask() {
        long leftover = this.partialCubeFullMask & (this.mandatoryColumnMask ^ 0xFFFFFFFFFFFFFFFFL);
        leftover &= this.jointDimsMask ^ 0xFFFFFFFFFFFFFFFFL;
        for (HierarchyMask hierarchyMask : this.hierarchyMasks) {
            leftover &= hierarchyMask.fullMask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.normalDimsMask = leftover;
        this.normalDims = this.bits(leftover);
    }

    private void buildHierarchyDimsMask() {
        long ret = 0L;
        for (HierarchyMask mask : this.hierarchyMasks) {
            ret |= mask.fullMask;
        }
        this.hierarchyDimsMask = ret;
    }

    private List<Long> bits(long x) {
        long bit;
        ArrayList r = Lists.newArrayList();
        for (long l = x; l != 0L; l ^= bit) {
            bit = Long.lowestOneBit(l);
            r.add(bit);
        }
        return r;
    }

    public void buildJointDimsMask() {
        long ret = 0L;
        for (long x : this.joints) {
            ret |= x;
        }
        this.jointDimsMask = ret;
    }

    public long getMandatoryColumnMask() {
        return this.mandatoryColumnMask;
    }

    public List<HierarchyMask> getHierarchyMasks() {
        return this.hierarchyMasks;
    }

    public int getBuildLevel() {
        int ret = 1;
        if (this.getPartialCubeFullMask() == Cuboid.getBaseCuboidId(this.cubeDesc)) {
            --ret;
        }
        ret += this.getNormalDims().size();
        for (HierarchyMask hierarchyMask : this.hierarchyMasks) {
            ret += hierarchyMask.allMasks.length;
        }
        for (Long joint : this.joints) {
            if ((joint & this.getHierarchyDimsMask()) != 0L) continue;
            ++ret;
        }
        return ret;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setSelectRule(SelectRule selectRule) {
        this.selectRule = selectRule;
    }

    public List<Long> getJoints() {
        return this.joints;
    }

    public long getJointDimsMask() {
        return this.jointDimsMask;
    }

    public long getNormalDimsMask() {
        return this.normalDimsMask;
    }

    public long getHierarchyDimsMask() {
        return this.hierarchyDimsMask;
    }

    public List<Long> getNormalDims() {
        return this.normalDims;
    }

    public long getPartialCubeFullMask() {
        return this.partialCubeFullMask;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public SelectRule getSelectRule() {
        return this.selectRule;
    }

    public boolean isMandatoryOnlyValid() {
        return this.isMandatoryOnlyValid;
    }

    public static class HierarchyMask {
        public long fullMask;
        public long[] allMasks;
        public long[] dims;
    }
}

