/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.gridtable.RecordComparator;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;

public abstract class ScanRangePlannerBase {
    protected TupleFilter gtFilter;
    protected GTInfo gtInfo;
    protected Pair<ByteArray, ByteArray> gtStartAndEnd;
    protected TblColRef gtPartitionCol;
    protected ImmutableBitSet gtDimensions;
    protected ImmutableBitSet gtAggrGroups;
    protected ImmutableBitSet gtAggrMetrics;
    protected String[] gtAggrFuncs;
    protected boolean isPartitionColUsingDatetimeEncoding = true;
    protected RecordComparator rangeStartComparator;
    protected RecordComparator rangeEndComparator;
    protected RecordComparator rangeStartEndComparator;

    public abstract GTScanRequest planScanRequest();

    protected TupleFilter flattenToOrAndFilter(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        TupleFilter flatFilter = filter.flatFilter();
        if (flatFilter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            LogicalTupleFilter f = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
            f.addChild(flatFilter);
            flatFilter = f;
        }
        if (flatFilter.getOperator() != TupleFilter.FilterOperatorEnum.OR) {
            throw new IllegalStateException();
        }
        return flatFilter;
    }

    protected List<Collection<ColumnRange>> translateToOrAndDimRanges(TupleFilter flatFilter) {
        ArrayList result = Lists.newArrayList();
        if (flatFilter == null) {
            result.add(Collections.emptyList());
            return result;
        }
        for (TupleFilter tupleFilter : flatFilter.getChildren()) {
            if (tupleFilter.getOperator() != TupleFilter.FilterOperatorEnum.AND) {
                throw new IllegalStateException("Filter should be AND instead of " + tupleFilter);
            }
            Collection<ColumnRange> andRanges = this.translateToAndDimRanges(tupleFilter.getChildren());
            if (andRanges == null) continue;
            result.add(andRanges);
        }
        return this.preEvaluateConstantConditions(result);
    }

    private Collection<ColumnRange> translateToAndDimRanges(List<? extends TupleFilter> andFilters) {
        HashMap<TblColRef, ColumnRange> rangeMap = new HashMap<TblColRef, ColumnRange>();
        for (TupleFilter tupleFilter : andFilters) {
            if (!(tupleFilter instanceof CompareTupleFilter)) {
                if (!(tupleFilter instanceof ConstantTupleFilter) || tupleFilter.evaluate(null, null)) continue;
                return null;
            }
            CompareTupleFilter comp = (CompareTupleFilter)tupleFilter;
            if (comp.getColumn() == null) continue;
            ColumnRange newRange = new ColumnRange(comp.getColumn(), (Set<ByteArray>)comp.getValues(), comp.getOperator());
            ColumnRange existing = (ColumnRange)rangeMap.get(newRange.column);
            if (existing == null) {
                rangeMap.put(newRange.column, newRange);
                continue;
            }
            existing.andMerge(newRange);
        }
        return rangeMap.values();
    }

    private List<Collection<ColumnRange>> preEvaluateConstantConditions(List<Collection<ColumnRange>> orAndRanges) {
        boolean globalAlwaysTrue = false;
        Iterator<Collection<ColumnRange>> iterator = orAndRanges.iterator();
        while (iterator.hasNext()) {
            Collection<ColumnRange> andRanges = iterator.next();
            Iterator<ColumnRange> iterator2 = andRanges.iterator();
            boolean hasAlwaysFalse = false;
            while (iterator2.hasNext()) {
                ColumnRange range = iterator2.next();
                if (range.satisfyAll()) {
                    iterator2.remove();
                    continue;
                }
                if (!range.satisfyNone()) continue;
                hasAlwaysFalse = true;
            }
            if (hasAlwaysFalse) {
                iterator.remove();
                continue;
            }
            if (!andRanges.isEmpty()) continue;
            globalAlwaysTrue = true;
            break;
        }
        if (globalAlwaysTrue) {
            orAndRanges.clear();
            orAndRanges.add(Collections.emptyList());
        }
        return orAndRanges;
    }

    protected String makeReadable(ByteArray byteArray) {
        if (byteArray == null) {
            return null;
        }
        return byteArray.toReadableText();
    }

    public class ColumnRange {
        public TblColRef column;
        public ByteArray begin = ByteArray.EMPTY;
        public ByteArray end = ByteArray.EMPTY;
        public Set<ByteArray> valueSet;
        public boolean isBoundryInclusive;

        public ColumnRange(TblColRef column, Set<ByteArray> values, TupleFilter.FilterOperatorEnum op) {
            this.column = column;
            if (op == TupleFilter.FilterOperatorEnum.EQ || op == TupleFilter.FilterOperatorEnum.IN || op == TupleFilter.FilterOperatorEnum.LTE || op == TupleFilter.FilterOperatorEnum.GTE) {
                this.isBoundryInclusive = true;
            }
            switch (op) {
                case EQ: 
                case IN: {
                    this.valueSet = new HashSet<ByteArray>(values);
                    this.refreshBeginEndFromEquals();
                    break;
                }
                case LT: 
                case LTE: {
                    this.end = ScanRangePlannerBase.this.rangeEndComparator.comparator.max(values);
                    break;
                }
                case GT: 
                case GTE: {
                    this.begin = ScanRangePlannerBase.this.rangeStartComparator.comparator.min(values);
                    break;
                }
                case NEQ: 
                case NOTIN: 
                case ISNULL: 
                case ISNOTNULL: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(op.name());
                }
            }
        }

        void copy(TblColRef column, ByteArray beginValue, ByteArray endValue, Set<ByteArray> equalValues) {
            this.column = column;
            this.begin = beginValue;
            this.end = endValue;
            this.valueSet = equalValues;
        }

        private void refreshBeginEndFromEquals() {
            if (this.valueSet.isEmpty()) {
                this.begin = ByteArray.EMPTY;
                this.end = ByteArray.EMPTY;
            } else {
                this.begin = ScanRangePlannerBase.this.rangeStartComparator.comparator.min(this.valueSet);
                this.end = ScanRangePlannerBase.this.rangeEndComparator.comparator.max(this.valueSet);
            }
        }

        public boolean satisfyAll() {
            return this.begin.array() == null && this.end.array() == null;
        }

        public boolean satisfyNone() {
            if (this.valueSet != null) {
                return this.valueSet.isEmpty();
            }
            if (this.begin.array() != null && this.end.array() != null) {
                return ScanRangePlannerBase.this.gtInfo.getCodeSystem().getComparator().compare(this.begin, this.end) > 0;
            }
            return false;
        }

        public void andMerge(ColumnRange another) {
            assert (this.column.equals(another.column));
            if (another.satisfyAll()) {
                return;
            }
            if (this.satisfyAll()) {
                this.copy(another.column, another.begin, another.end, another.valueSet);
                return;
            }
            if (this.valueSet != null && another.valueSet != null) {
                this.valueSet.retainAll(another.valueSet);
                this.refreshBeginEndFromEquals();
                return;
            }
            if (this.valueSet != null) {
                this.valueSet = this.filter(this.valueSet, another.begin, another.end);
                this.refreshBeginEndFromEquals();
                return;
            }
            if (another.valueSet != null) {
                this.valueSet = this.filter(another.valueSet, this.begin, this.end);
                this.refreshBeginEndFromEquals();
                return;
            }
            this.begin = ScanRangePlannerBase.this.rangeStartComparator.comparator.max(this.begin, another.begin);
            this.end = ScanRangePlannerBase.this.rangeEndComparator.comparator.min(this.end, another.end);
            this.isBoundryInclusive |= another.isBoundryInclusive;
        }

        private Set<ByteArray> filter(Set<ByteArray> equalValues, ByteArray beginValue, ByteArray endValue) {
            HashSet result = Sets.newHashSetWithExpectedSize((int)equalValues.size());
            for (ByteArray v : equalValues) {
                if (ScanRangePlannerBase.this.rangeStartEndComparator.comparator.compare(beginValue, v) > 0 || ScanRangePlannerBase.this.rangeStartEndComparator.comparator.compare(v, endValue) > 0) continue;
                result.add(v);
            }
            return equalValues;
        }

        public String toString() {
            if (this.valueSet == null) {
                return this.column.getName() + " between " + this.begin + " and " + this.end;
            }
            return this.column.getName() + " in " + this.valueSet;
        }
    }
}

