/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;

public class CuboidScheduler {
    private final CubeDesc cubeDesc;
    private final long max;
    private final Map<Long, List<Long>> cache;

    public CuboidScheduler(CubeDesc cubeDesc) {
        this.cubeDesc = cubeDesc;
        int size = this.cubeDesc.getRowkey().getRowKeyColumns().length;
        this.max = (long)Math.pow(2.0, size) - 1L;
        this.cache = new ConcurrentHashMap<Long, List<Long>>();
    }

    public long getParent(long child) {
        ArrayList candidates = Lists.newArrayList();
        long baseCuboidID = Cuboid.getBaseCuboidId(this.cubeDesc);
        if (child == baseCuboidID || !Cuboid.isValid(this.cubeDesc, child)) {
            throw new IllegalStateException();
        }
        for (AggregationGroup agg : Cuboid.getValidAggGroupForCuboid(this.cubeDesc, child)) {
            boolean thisAggContributed = false;
            if (agg.getPartialCubeFullMask() == child) {
                return baseCuboidID;
            }
            long normalDimsMask = agg.getNormalDimsMask() & (child ^ 0xFFFFFFFFFFFFFFFFL);
            if (normalDimsMask != 0L) {
                candidates.add(child | Long.lowestOneBit(normalDimsMask));
                thisAggContributed = true;
            }
            block1: for (AggregationGroup.HierarchyMask hierarchyMask : agg.getHierarchyMasks()) {
                if ((child & hierarchyMask.fullMask) == 0L) {
                    candidates.add(child | hierarchyMask.dims[0]);
                    thisAggContributed = true;
                    continue;
                }
                for (int i = hierarchyMask.allMasks.length - 1; i >= 0; --i) {
                    if ((child & hierarchyMask.allMasks[i]) != hierarchyMask.allMasks[i] || i == hierarchyMask.allMasks.length - 1) continue;
                    if ((agg.getJointDimsMask() & hierarchyMask.dims[i + 1]) != 0L || (child & hierarchyMask.dims[i + 1]) != 0L) continue block1;
                    candidates.add(child | hierarchyMask.dims[i + 1]);
                    thisAggContributed = true;
                    continue block1;
                }
            }
            if (thisAggContributed) continue;
            Iterator<Object> i$ = agg.getJoints().iterator();
            while (i$.hasNext()) {
                long joint = (Long)i$.next();
                if ((child & joint) != 0L) continue;
                candidates.add(child | joint);
            }
        }
        if (candidates.size() == 0) {
            throw new IllegalStateException();
        }
        return Collections.min(candidates, Cuboid.cuboidSelectComparator);
    }

    public Set<Long> getPotentialChildren(long parent) {
        if (parent != Cuboid.getBaseCuboid(this.cubeDesc).getId() && !Cuboid.isValid(this.cubeDesc, parent)) {
            throw new IllegalStateException();
        }
        HashSet set = Sets.newHashSet();
        if (Long.bitCount(parent) == 1) {
            return set;
        }
        if (parent == Cuboid.getBaseCuboidId(this.cubeDesc)) {
            for (AggregationGroup agg : this.cubeDesc.getAggregationGroups()) {
                long partialCubeFullMask = agg.getPartialCubeFullMask();
                if (partialCubeFullMask == parent || !Cuboid.isValid(agg, partialCubeFullMask)) continue;
                set.add(partialCubeFullMask);
            }
        }
        for (AggregationGroup agg : Cuboid.getValidAggGroupForCuboid(this.cubeDesc, parent)) {
            Iterator<Object> i$ = agg.getNormalDims().iterator();
            while (i$.hasNext()) {
                long normalDimMask = i$.next();
                long common = parent & normalDimMask;
                long temp = parent ^ normalDimMask;
                if (common == 0L || !Cuboid.isValid(agg, temp)) continue;
                set.add(temp);
            }
            block3: for (AggregationGroup.HierarchyMask hierarchyMask : agg.getHierarchyMasks()) {
                for (int i = hierarchyMask.allMasks.length - 1; i >= 0; --i) {
                    if ((parent & hierarchyMask.allMasks[i]) != hierarchyMask.allMasks[i]) continue;
                    if ((agg.getJointDimsMask() & hierarchyMask.dims[i]) != 0L || !Cuboid.isValid(agg, parent ^ hierarchyMask.dims[i])) continue block3;
                    set.add(parent ^ hierarchyMask.dims[i]);
                    continue block3;
                }
            }
            i$ = agg.getJoints().iterator();
            while (i$.hasNext()) {
                long joint = (Long)i$.next();
                if ((parent & joint) != joint || !Cuboid.isValid(agg, parent ^ joint)) continue;
                set.add(parent ^ joint);
            }
        }
        return set;
    }

    public int getCuboidCount() {
        return this.getCuboidCount(Cuboid.getBaseCuboidId(this.cubeDesc));
    }

    private int getCuboidCount(long cuboidId) {
        int r = 1;
        for (Long child : this.getSpanningCuboid(cuboidId)) {
            r += this.getCuboidCount(child);
        }
        return r;
    }

    public List<Long> getSpanningCuboid(long cuboid) {
        if (cuboid > this.max || cuboid < 0L) {
            throw new IllegalArgumentException("Cuboid " + cuboid + " is out of scope 0-" + this.max);
        }
        ArrayList result = this.cache.get(cuboid);
        if (result != null) {
            return result;
        }
        result = Lists.newArrayList();
        Set<Long> potentials = this.getPotentialChildren(cuboid);
        for (Long potential : potentials) {
            if (this.getParent(potential) != cuboid) continue;
            result.add(potential);
        }
        this.cache.put(cuboid, result);
        return result;
    }

    public int getCardinality(long cuboid) {
        if (cuboid > this.max || cuboid < 0L) {
            throw new IllegalArgumentException("Cubiod " + cuboid + " is out of scope 0-" + this.max);
        }
        return Long.bitCount(cuboid);
    }

    public List<Long> getAllCuboidIds() {
        long baseCuboidId = Cuboid.getBaseCuboidId(this.cubeDesc);
        ArrayList result = Lists.newArrayList();
        this.getSubCuboidIds(baseCuboidId, result);
        return result;
    }

    private void getSubCuboidIds(long parentCuboidId, List<Long> result) {
        result.add(parentCuboidId);
        for (Long cuboidId : this.getSpanningCuboid(parentCuboidId)) {
            this.getSubCuboidIds(cuboidId, result);
        }
    }
}

