/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cli;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGeneratorCLI {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGeneratorCLI.class);

    public static void processSegment(KylinConfig config, String cubeName, String segmentID, DistinctColumnValuesProvider factTableValueProvider) throws IOException {
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        CubeSegment segment = cube.getSegmentById(segmentID);
        DictionaryGeneratorCLI.processSegment(config, segment, factTableValueProvider);
    }

    private static void processSegment(KylinConfig config, CubeSegment cubeSeg, DistinctColumnValuesProvider factTableValueProvider) throws IOException {
        CubeManager cubeMgr = CubeManager.getInstance(config);
        for (TblColRef col : cubeSeg.getCubeDesc().getAllColumnsNeedDictionaryBuilt()) {
            logger.info("Building dictionary for " + col);
            cubeMgr.buildDictionary(cubeSeg, col, factTableValueProvider);
        }
        for (DimensionDesc dim : cubeSeg.getCubeDesc().getDimensions()) {
            if (dim.getTable() == null || dim.getTable().equalsIgnoreCase(cubeSeg.getCubeDesc().getFactTable())) continue;
            logger.info("Building snapshot of " + dim.getTable());
            cubeMgr.buildSnapshotTable(cubeSeg, dim.getTable());
            logger.info("Checking snapshot of " + dim.getTable());
            cubeMgr.getLookupTable(cubeSeg, dim);
        }
    }
}

