/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawQueryLastHacker {
    private static final Logger logger = LoggerFactory.getLogger(RawQueryLastHacker.class);

    public static void hackNoAggregations(SQLDigest sqlDigest, CubeDesc cubeDesc) {
        if (!sqlDigest.isRawQuery) {
            return;
        }
        logger.info("No group by and aggregation found in this query, will hack some result for better look of output...");
        boolean isSelectAll = sqlDigest.allColumns.isEmpty() || sqlDigest.allColumns.equals(sqlDigest.filterColumns);
        for (TblColRef col : cubeDesc.listAllColumns()) {
            if (!cubeDesc.listDimensionColumnsIncludingDerived().contains(col) && !isSelectAll || !col.getTable().equals(sqlDigest.factTable)) continue;
            sqlDigest.allColumns.add(col);
        }
        for (TblColRef col : sqlDigest.allColumns) {
            if (cubeDesc.listDimensionColumnsExcludingDerived(true).contains(col)) {
                sqlDigest.groupbyColumns.add(col);
                continue;
            }
            ParameterDesc colParameter = new ParameterDesc();
            colParameter.setType("column");
            colParameter.setValue(col.getName());
            FunctionDesc sumFunc = new FunctionDesc();
            sumFunc.setExpression("SUM");
            sumFunc.setParameter(colParameter);
            boolean measureHasSum = false;
            for (MeasureDesc colMeasureDesc : cubeDesc.getMeasures()) {
                if (!colMeasureDesc.getFunction().equals(sumFunc)) continue;
                measureHasSum = true;
                break;
            }
            if (measureHasSum) {
                sqlDigest.aggregations.add(sumFunc);
            } else {
                logger.warn("SUM is not defined for measure column " + col + ", output will be meaningless.");
            }
            sqlDigest.metricColumns.add(col);
        }
    }
}

