/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipFileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressZipFile(String sourceDir, String zipFilename) throws IOException {
        if (!ZipFileUtils.validateZipFilename(zipFilename)) {
            throw new RuntimeException("Zipfile must end with .zip");
        }
        ZipOutputStream zipFile = null;
        try {
            zipFile = new ZipOutputStream(new FileOutputStream(zipFilename));
            ZipFileUtils.compressDirectoryToZipfile(ZipFileUtils.normDir(new File(sourceDir).getParent()), ZipFileUtils.normDir(sourceDir), zipFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipFile);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompressZipfileToDirectory(String zipFileName, File outputFolder) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(zipFileName));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                logger.info("decompressing " + zipEntry.getName() + " is directory:" + zipEntry.isDirectory() + " available: " + zipInputStream.available());
                File temp = new File(outputFolder, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    temp.mkdirs();
                    continue;
                }
                temp.getParentFile().mkdirs();
                temp.createNewFile();
                temp.setLastModified(zipEntry.getTime());
                FileOutputStream outputStream = new FileOutputStream(temp);
                try {
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zipInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressDirectoryToZipfile(String rootDir, String sourceDir, ZipOutputStream out) throws IOException {
        for (File sourceFile : new File(sourceDir).listFiles()) {
            if (sourceFile.isDirectory()) {
                ZipFileUtils.compressDirectoryToZipfile(rootDir, sourceDir + ZipFileUtils.normDir(sourceFile.getName()), out);
                continue;
            }
            ZipEntry entry = new ZipEntry(ZipFileUtils.normDir(StringUtils.isEmpty((String)rootDir) ? sourceDir : sourceDir.replace(rootDir, "")) + sourceFile.getName());
            entry.setTime(sourceFile.lastModified());
            out.putNextEntry(entry);
            FileInputStream in = new FileInputStream(sourceDir + sourceFile.getName());
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private static boolean validateZipFilename(String filename) {
        return !StringUtils.isEmpty((String)filename) && filename.trim().toLowerCase().endsWith(".zip");
    }

    private static String normDir(String dirName) {
        if (!StringUtils.isEmpty((String)dirName) && !dirName.endsWith(File.separator)) {
            dirName = dirName + File.separator;
        }
        return dirName;
    }
}

