/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesUtil;

public abstract class Dictionary<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int[] NULL_ID = new int[]{0, 255, 65535, 0xFFFFFF, -1};

    public abstract int getMinId();

    public abstract int getMaxId();

    public int getSize() {
        return this.getMaxId() - this.getMinId() + 1;
    }

    public abstract int getSizeOfId();

    public abstract int getSizeOfValue();

    public abstract boolean contains(Dictionary<?> var1);

    public final int getIdFromValue(T value) throws IllegalArgumentException {
        return this.getIdFromValue(value, 0);
    }

    public final int getIdFromValue(T value, int roundingFlag) throws IllegalArgumentException {
        if (this.isNullObjectForm(value)) {
            return this.nullId();
        }
        return this.getIdFromValueImpl(value, roundingFlag);
    }

    public final boolean containsValue(T value) throws IllegalArgumentException {
        if (this.isNullObjectForm(value)) {
            return true;
        }
        try {
            this.getIdFromValueImpl(value, 0);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    protected boolean isNullObjectForm(T value) {
        return value == null;
    }

    protected abstract int getIdFromValueImpl(T var1, int var2);

    public final T getValueFromId(int id) throws IllegalArgumentException {
        if (this.isNullId(id)) {
            return null;
        }
        return this.getValueFromIdImpl(id);
    }

    protected abstract T getValueFromIdImpl(int var1);

    public final int getIdFromValueBytes(byte[] value, int offset, int len) throws IllegalArgumentException {
        return this.getIdFromValueBytes(value, offset, len, 0);
    }

    public final int getIdFromValueBytes(byte[] value, int offset, int len, int roundingFlag) throws IllegalArgumentException {
        if (this.isNullByteForm(value, offset, len)) {
            return this.nullId();
        }
        int id = this.getIdFromValueBytesImpl(value, offset, len, roundingFlag);
        if (id < 0) {
            throw new IllegalArgumentException("Value not exists!");
        }
        return id;
    }

    protected boolean isNullByteForm(byte[] value, int offset, int len) {
        return value == null;
    }

    protected abstract int getIdFromValueBytesImpl(byte[] var1, int var2, int var3, int var4);

    public final byte[] getValueBytesFromId(int id) {
        if (this.isNullId(id)) {
            return BytesUtil.EMPTY_BYTE_ARRAY;
        }
        return this.getValueBytesFromIdImpl(id);
    }

    protected abstract byte[] getValueBytesFromIdImpl(int var1);

    public final int getValueBytesFromId(int id, byte[] returnValue, int offset) throws IllegalArgumentException {
        if (this.isNullId(id)) {
            return -1;
        }
        return this.getValueBytesFromIdImpl(id, returnValue, offset);
    }

    protected abstract int getValueBytesFromIdImpl(int var1, byte[] var2, int var3);

    public abstract void dump(PrintStream var1);

    public int nullId() {
        return NULL_ID[this.getSizeOfId()];
    }

    public boolean isNullId(int id) {
        int nullId = NULL_ID[this.getSizeOfId()];
        return (nullId & id) == nullId;
    }

    public Dictionary copyToAnotherMeta(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        return this;
    }

    public static String dictIdToString(byte[] idBytes, int offset, int length) {
        try {
            return new String(idBytes, offset, length, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static int stringToDictId(String str) {
        try {
            byte[] bytes = str.getBytes("ISO-8859-1");
            return BytesUtil.readUnsigned(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract void readFields(DataInput var1) throws IOException;
}

