/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.Bytes;

public class BytesUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static void writeByte(byte num, byte[] bytes, int offset, int size) {
        for (int i = offset + size - 1; i >= offset; --i) {
            bytes[i] = num;
            num = (byte)(num >>> 8);
        }
    }

    public static void writeShort(short num, byte[] bytes, int offset, int size) {
        for (int i = offset + size - 1; i >= offset; --i) {
            bytes[i] = (byte)num;
            num = (short)(num >>> 8);
        }
    }

    public static long readShort(byte[] bytes, int offset, int size) {
        int num = 0;
        int n = offset + size;
        for (int i = offset; i < n; ++i) {
            num = (short)(num << 8);
            num = (short)(num | (short)bytes[i] & 0xFF);
        }
        return num;
    }

    public static void writeUnsigned(int num, byte[] bytes, int offset, int size) {
        for (int i = offset + size - 1; i >= offset; --i) {
            bytes[i] = (byte)num;
            num >>>= 8;
        }
    }

    public static int readUnsigned(byte[] bytes, int offset, int size) {
        int integer = 0;
        int n = offset + size;
        for (int i = offset; i < n; ++i) {
            integer <<= 8;
            integer |= bytes[i] & 0xFF;
        }
        return integer;
    }

    public static void writeUnsigned(int num, int size, ByteBuffer out) {
        int mask = 255 << (size - 1) * 8;
        for (int i = size; i > 0; --i) {
            int v = (num & mask) >> (i - 1) * 8;
            out.put((byte)v);
            mask >>= 8;
        }
    }

    public static int readUnsigned(ByteBuffer in, int size) {
        int integer = 0;
        for (int i = 0; i < size; ++i) {
            integer <<= 8;
            integer |= in.get() & 0xFF;
        }
        return integer;
    }

    public static void writeSignedLong(long num, byte[] bytes, int offset, int size) {
        BytesUtil.writeLong(num, bytes, offset, size);
    }

    public static long readSignedLong(byte[] bytes, int offset, int size) {
        long integer = (bytes[offset] & 0x80) == 0 ? 0L : -1L;
        int n = offset + size;
        for (int i = offset; i < n; ++i) {
            integer <<= 8;
            integer |= (long)(bytes[i] & 0xFF);
        }
        return integer;
    }

    public static void writeLong(long num, byte[] bytes, int offset, int size) {
        for (int i = offset + size - 1; i >= offset; --i) {
            bytes[i] = (byte)num;
            num >>>= 8;
        }
    }

    public static long readLong(byte[] bytes, int offset, int size) {
        long integer = 0L;
        int n = offset + size;
        for (int i = offset; i < n; ++i) {
            integer <<= 8;
            integer |= (long)bytes[i] & 0xFFL;
        }
        return integer;
    }

    public static void writeLong(long num, ByteBuffer out) {
        for (int i = 0; i < 8; ++i) {
            out.put((byte)num);
            num >>>= 8;
        }
    }

    public static long readLong(ByteBuffer in) {
        long integer = 0L;
        int mask = 255;
        int shift = 0;
        for (int i = 0; i < 8; ++i) {
            integer |= (long)(in.get() << shift & mask);
            mask <<= 8;
            shift += 8;
        }
        return integer;
    }

    public static int sizeForValue(long maxValue) {
        int size = 0;
        while (maxValue > 0L) {
            ++size;
            maxValue >>>= 8;
        }
        return size;
    }

    public static int compareByteUnsigned(byte b1, byte b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        return i1 - i2;
    }

    public static byte[] subarray(byte[] bytes, int start, int end) {
        byte[] r = new byte[end - start];
        System.arraycopy(bytes, start, r, 0, r.length);
        return r;
    }

    public static int compareBytes(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length) {
        int r = 0;
        for (int i = 0; i < length && (r = src[srcOffset + i] - dst[dstOffset + i]) == 0; ++i) {
        }
        return r;
    }

    public static void writeVInt(int i, ByteBuffer out) {
        BytesUtil.writeVLong(i, out);
    }

    public static void writeVLong(long i, ByteBuffer out) {
        if (i >= -112L && i <= 127L) {
            out.put((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        out.put((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            out.put((byte)((i & mask) >> shiftbits));
        }
    }

    public static long readVLong(ByteBuffer in) {
        byte firstByte = in.get();
        int len = BytesUtil.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = in.get();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return BytesUtil.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int readVInt(ByteBuffer in) {
        long n = BytesUtil.readVLong(in);
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("value too long to fit in integer");
        }
        return (int)n;
    }

    private static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }

    private static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    public static void writeUTFString(String str, ByteBuffer out) {
        byte[] bytes = str == null ? null : Bytes.toBytes(str);
        BytesUtil.writeByteArray(bytes, out);
    }

    public static String readUTFString(ByteBuffer in) {
        byte[] bytes = BytesUtil.readByteArray(in);
        return bytes == null ? null : Bytes.toString(bytes);
    }

    public static void writeAsciiString(String str, ByteBuffer out) {
        if (str == null) {
            BytesUtil.writeVInt(-1, out);
            return;
        }
        int len = str.length();
        BytesUtil.writeVInt(len, out);
        for (int i = 0; i < len; ++i) {
            out.put((byte)str.charAt(i));
        }
    }

    public static String readAsciiString(ByteBuffer in) {
        String result;
        int len = BytesUtil.readVInt(in);
        if (len < 0) {
            return null;
        }
        try {
            if (in.hasArray()) {
                int pos = in.position();
                result = new String(in.array(), pos, len, "ISO-8859-1");
                in.position(pos + len);
            } else {
                byte[] tmp = new byte[len];
                in.get(tmp);
                result = new String(tmp, "ISO-8859-1");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void writeAsciiStringArray(String[] strs, ByteBuffer out) {
        BytesUtil.writeVInt(strs.length, out);
        for (int i = 0; i < strs.length; ++i) {
            BytesUtil.writeAsciiString(strs[i], out);
        }
    }

    public static String[] readAsciiStringArray(ByteBuffer in) {
        int len = BytesUtil.readVInt(in);
        String[] strs = new String[len];
        for (int i = 0; i < len; ++i) {
            strs[i] = BytesUtil.readAsciiString(in);
        }
        return strs;
    }

    public static void writeIntArray(int[] array, ByteBuffer out) {
        if (array == null) {
            BytesUtil.writeVInt(-1, out);
            return;
        }
        BytesUtil.writeVInt(array.length, out);
        for (int i = 0; i < array.length; ++i) {
            BytesUtil.writeVInt(array[i], out);
        }
    }

    public static int[] readIntArray(ByteBuffer in) {
        int len = BytesUtil.readVInt(in);
        if (len < 0) {
            return null;
        }
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = BytesUtil.readVInt(in);
        }
        return array;
    }

    public static void writeByteArray(byte[] array, ByteBuffer out) {
        if (array == null) {
            BytesUtil.writeVInt(-1, out);
            return;
        }
        BytesUtil.writeVInt(array.length, out);
        out.put(array);
    }

    public static void writeByteArray(byte[] array, int offset, int length, ByteBuffer out) {
        if (array == null) {
            BytesUtil.writeVInt(-1, out);
            return;
        }
        BytesUtil.writeVInt(length, out);
        out.put(array, offset, length);
    }

    public static byte[] readByteArray(ByteBuffer in) {
        int len = BytesUtil.readVInt(in);
        if (len < 0) {
            return null;
        }
        byte[] array = new byte[len];
        in.get(array);
        return array;
    }

    public static int peekByteArrayLength(ByteBuffer in) {
        int start = in.position();
        int arrayLen = BytesUtil.readVInt(in);
        int sizeLen = in.position() - start;
        in.position(start);
        if (arrayLen < 0) {
            return sizeLen;
        }
        return sizeLen + arrayLen;
    }

    public static void writeBooleanArray(boolean[] array, ByteBuffer out) {
        if (array == null) {
            BytesUtil.writeVInt(-1, out);
            return;
        }
        BytesUtil.writeVInt(array.length, out);
        byte b_true = 1;
        byte b_false = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i]) {
                out.put(b_true);
                continue;
            }
            out.put(b_false);
        }
    }

    public static boolean[] readBooleanArray(ByteBuffer in) {
        int len = BytesUtil.readVInt(in);
        if (len < 0) {
            return null;
        }
        boolean[] array = new boolean[len];
        byte b_true = 1;
        for (int i = 0; i < array.length; ++i) {
            byte temp = in.get();
            array[i] = temp == b_true;
        }
        return array;
    }

    public static String toReadableText(byte[] array) {
        if (array == null) {
            return null;
        }
        return BytesUtil.toHex(array);
    }

    public static byte[] fromReadableText(String text) {
        String[] tokens = text.split("\\\\x");
        byte[] ret = new byte[tokens.length - 1];
        for (int i = 1; i < tokens.length; ++i) {
            int x = Bytes.toBinaryFromHex((byte)tokens[i].charAt(0));
            byte y = Bytes.toBinaryFromHex((byte)tokens[i].charAt(1));
            ret[i - 1] = (byte)((x <<= 4) + y);
        }
        return ret;
    }

    public static String toHex(byte[] array) {
        return BytesUtil.toHex(array, 0, array.length);
    }

    public static String toHex(byte[] array, int offset, int length) {
        StringBuilder sb = new StringBuilder(length * 4);
        for (int i = 0; i < length; ++i) {
            byte b = array[offset + i];
            sb.append(String.format("\\x%02X", b & 0xFF));
        }
        return sb.toString();
    }
}

