/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfig
extends KylinConfigBase {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfig.class);
    public static final String KYLIN_CONF_PROPERTIES_FILE = "kylin.properties";
    public static final String KYLIN_CONF = "KYLIN_CONF";
    private static KylinConfig ENV_INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KylinConfig getInstanceFromEnv() {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (ENV_INSTANCE == null) {
                try {
                    KylinConfig config = new KylinConfig();
                    config.reloadKylinConfig(KylinConfig.getKylinProperties());
                    logger.info("Initialized a new KylinConfig from getInstanceFromEnv : " + System.identityHashCode(config));
                    ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KylinConfig ", e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ENV_INSTANCE;
        }
    }

    public static void destroyInstance() {
        logger.info("Destory KylinConfig");
        KylinConfig.dumpStackTrace();
        ENV_INSTANCE = null;
    }

    private static UriType decideUriType(String metaUri) {
        try {
            File file = new File(metaUri);
            if (file.exists() || metaUri.contains("/")) {
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.isDirectory()) {
                    return UriType.LOCAL_FOLDER;
                }
                if (file.isFile()) {
                    if (file.getName().equalsIgnoreCase(KYLIN_CONF_PROPERTIES_FILE)) {
                        return UriType.PROPERTIES_FILE;
                    }
                    throw new IllegalStateException("Metadata uri : " + metaUri + " is a local file but not kylin.properties");
                }
                throw new IllegalStateException("Metadata uri : " + metaUri + " looks like a file but it's neither a file nor a directory");
            }
            if (RestClient.matchFullRestPattern(metaUri)) {
                return UriType.REST_ADDR;
            }
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not a valid REST URI address");
        }
        catch (Exception e) {
            throw new IllegalStateException("Metadata uri : " + metaUri + " is not recognized", e);
        }
    }

    public static KylinConfig createInstanceFromUri(String uri) {
        UriType uriType = KylinConfig.decideUriType(uri);
        logger.info("The URI " + uri + " is recognized as " + (Object)((Object)uriType));
        if (uriType == UriType.LOCAL_FOLDER) {
            KylinConfig config = new KylinConfig();
            config.setMetadataUrl(uri);
            return config;
        }
        if (uriType == UriType.PROPERTIES_FILE) {
            KylinConfig config;
            try {
                config = new KylinConfig();
                FileInputStream is = new FileInputStream(uri);
                Properties prop = KylinConfig.streamToProps(is);
                config.reloadKylinConfig(prop);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return config;
        }
        try {
            KylinConfig config = new KylinConfig();
            RestClient client = new RestClient(uri);
            String propertyText = client.getKylinProperties();
            InputStream is = IOUtils.toInputStream((String)propertyText, (Charset)Charset.defaultCharset());
            Properties prop = KylinConfig.streamToProps(is);
            config.reloadKylinConfig(prop);
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties streamToProps(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        IOUtils.closeQuietly((InputStream)is);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKylinConfigInEnvIfMissing(Properties prop) {
        Class<KylinConfig> clazz = KylinConfig.class;
        synchronized (KylinConfig.class) {
            if (ENV_INSTANCE == null) {
                try {
                    KylinConfig config = new KylinConfig();
                    config.reloadKylinConfig(prop);
                    logger.info("Resetting ENV_INSTANCE by a input stream: " + System.identityHashCode(config));
                    ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KylinConfig ", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static KylinConfig createKylinConfig(String propsInStr) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(propsInStr));
        return KylinConfig.createKylinConfig(props);
    }

    public static KylinConfig createKylinConfig(KylinConfig another) {
        return KylinConfig.createKylinConfig(another.getAllProperties());
    }

    public static KylinConfig createKylinConfig(Properties prop) {
        KylinConfig kylinConfig = new KylinConfig();
        kylinConfig.reloadKylinConfig(prop);
        return kylinConfig;
    }

    static File getKylinPropertiesFile() {
        String kylinConfHome = System.getProperty(KYLIN_CONF);
        if (!StringUtils.isEmpty((String)kylinConfHome)) {
            logger.info("Use KYLIN_CONF=" + kylinConfHome);
            return KylinConfig.getKylinPropertiesFile(kylinConfHome);
        }
        logger.warn("KYLIN_CONF property was not set, will seek KYLIN_HOME env variable");
        String kylinHome = KylinConfig.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            throw new KylinConfigCannotInitException("Didn't find KYLIN_CONF or KYLIN_HOME, please set one of them");
        }
        String path = kylinHome + File.separator + "conf";
        return KylinConfig.getKylinPropertiesFile(path);
    }

    public static Properties getKylinProperties() {
        File propFile = KylinConfig.getKylinPropertiesFile();
        if (propFile == null || !propFile.exists()) {
            logger.error("fail to locate kylin.properties");
            throw new RuntimeException("fail to locate kylin.properties");
        }
        Properties conf = new Properties();
        try {
            FileInputStream is = new FileInputStream(propFile);
            conf.load(is);
            IOUtils.closeQuietly((InputStream)is);
            File propOverrideFile = new File(propFile.getParentFile(), propFile.getName() + ".override");
            if (propOverrideFile.exists()) {
                FileInputStream ois = new FileInputStream(propOverrideFile);
                Properties propOverride = new Properties();
                propOverride.load(ois);
                IOUtils.closeQuietly((InputStream)ois);
                conf.putAll((Map<?, ?>)propOverride);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return conf;
    }

    private static File getKylinPropertiesFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path, KYLIN_CONF_PROPERTIES_FILE);
    }

    public static void setSandboxEnvIfPossible() {
        File dir1 = new File("../examples/test_case_data/sandbox");
        File dir2 = new File("../../kylin/examples/test_case_data/sandbox");
        if (dir1.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir1.getAbsolutePath());
            ClassUtil.addClasspath(dir1.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir1.getAbsolutePath());
        } else if (dir2.exists()) {
            logger.info("Setting sandbox env, KYLIN_CONF=" + dir2.getAbsolutePath());
            ClassUtil.addClasspath(dir2.getAbsolutePath());
            System.setProperty(KYLIN_CONF, dir2.getAbsolutePath());
        }
    }

    private KylinConfig() {
        logger.info("New KylinConfig " + System.identityHashCode(this));
        KylinConfig.dumpStackTrace();
    }

    protected KylinConfig(Properties props) {
        super(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.getAllProperties().store(fos, file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public String getConfigAsString() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.list(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void list(PrintWriter out) {
        Properties props = this.getAllProperties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)props.get(key);
            out.println(key + "=" + val);
        }
    }

    public KylinConfig base() {
        return this;
    }

    private int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.base().superHashCode();
    }

    public boolean equals(Object another) {
        if (!(another instanceof KylinConfig)) {
            return false;
        }
        return this.base() == ((KylinConfig)another).base();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOverrideProperties(Properties properties) throws IOException {
        File propFile = KylinConfig.getKylinPropertiesFile();
        File overrideFile = new File(propFile.getParentFile(), propFile.getName() + ".override");
        overrideFile.createNewFile();
        FileInputStream fis2 = null;
        Properties override = new Properties();
        try {
            fis2 = new FileInputStream(overrideFile);
            override.load(fis2);
            for (Map.Entry<Object, Object> entries : properties.entrySet()) {
                override.setProperty(entries.getKey().toString(), entries.getValue().toString());
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis2);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(overrideFile);
            Enumeration<?> e = override.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                pw.println(key + "=" + override.getProperty(key));
            }
            pw.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)pw);
    }

    private static void dumpStackTrace() {
    }

    public static enum UriType {
        PROPERTIES_FILE,
        REST_ADDR,
        LOCAL_FOLDER;

    }
}

