/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseStreamingInput {
    private static final Logger logger = LoggerFactory.getLogger(HbaseStreamingInput.class);
    private static final int CELL_SIZE = 131072;
    private static final byte[] CF = "F".getBytes();
    private static final byte[] QN = "C".getBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(String tableName) throws IOException {
        HConnection conn = HbaseStreamingInput.getConnection();
        HBaseAdmin hadmin = new HBaseAdmin(conn);
        try {
            boolean tableExist = hadmin.tableExists(tableName);
            if (tableExist) {
                logger.info("HTable '" + tableName + "' already exists");
                return;
            }
            logger.info("Creating HTable '" + tableName + "'");
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
            desc.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            desc.setMemStoreFlushSize(0x20000000L);
            HColumnDescriptor fd = new HColumnDescriptor(CF);
            fd.setBlocksize(131072);
            desc.addFamily(fd);
            hadmin.createTable(desc);
            logger.info("HTable '" + tableName + "' created");
        }
        finally {
            conn.close();
            hadmin.close();
        }
    }

    private static void scheduleJob(Semaphore semaphore, int interval) {
        while (true) {
            semaphore.release();
            try {
                Thread.sleep(interval);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void addData(String tableName) throws IOException {
        HbaseStreamingInput.createTable(tableName);
        final Semaphore semaphore = new Semaphore(0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                HbaseStreamingInput.scheduleJob(semaphore, 300000);
            }
        }).start();
        while (true) {
            try {
                semaphore.acquire();
                int waiting = semaphore.availablePermits();
                if (waiting > 0) {
                    logger.warn("There are another " + waiting + " batches waiting to be added");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            HConnection conn = HbaseStreamingInput.getConnection();
            HTableInterface table = conn.getTable(tableName);
            byte[] key = new byte[12];
            logger.info("============================================");
            long startTime = System.currentTimeMillis();
            logger.info("data load start time in millis: " + startTime);
            logger.info("data load start at " + HbaseStreamingInput.formatTime(startTime));
            ArrayList buffer = Lists.newArrayList();
            for (int i = 0; i < 1024; ++i) {
                long time = System.currentTimeMillis();
                Bytes.putLong((byte[])key, (int)0, (long)time);
                Bytes.putInt((byte[])key, (int)8, (int)i);
                Put put = new Put(key);
                byte[] cell = HbaseStreamingInput.randomBytes(131072);
                put.add(CF, QN, cell);
                buffer.add(put);
            }
            table.put((List)buffer);
            table.close();
            conn.close();
            long endTime = System.currentTimeMillis();
            logger.info("data load end at " + HbaseStreamingInput.formatTime(endTime));
            logger.info("data load time consumed: " + (endTime - startTime));
            logger.info("============================================");
        }
    }

    public static void randomScan(String tableName) throws IOException {
        final Semaphore semaphore = new Semaphore(0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                HbaseStreamingInput.scheduleJob(semaphore, 60000);
            }
        }).start();
        while (true) {
            try {
                semaphore.acquire();
                int waiting = semaphore.drainPermits();
                if (waiting > 0) {
                    logger.warn("Too many queries to handle! Blocking " + waiting + " sets of scan requests");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Random r = new Random();
            HConnection conn = HbaseStreamingInput.getConnection();
            HTableInterface table = conn.getTable(tableName);
            long leftBound = HbaseStreamingInput.getFirstKeyTime(table);
            long rightBound = System.currentTimeMillis();
            for (int t = 0; t < 5; ++t) {
                long start = (long)((double)leftBound + r.nextDouble() * (double)(rightBound - leftBound));
                long end = start + 600000L;
                logger.info("A scan from " + HbaseStreamingInput.formatTime(start) + " to " + HbaseStreamingInput.formatTime(end));
                Scan scan = new Scan();
                scan.setStartRow(Bytes.toBytes((long)start));
                scan.setStopRow(Bytes.toBytes((long)end));
                scan.addFamily(CF);
                ResultScanner scanner = table.getScanner(scan);
                long hash = 0L;
                int rowCount = 0;
                for (Result result : scanner) {
                    Cell cell = result.getColumnLatestCell(CF, QN);
                    byte[] value = cell.getValueArray();
                    if (cell.getValueLength() != 131072) {
                        logger.error("value size invalid!!!!!");
                    }
                    hash += (long)Arrays.hashCode(Arrays.copyOfRange(value, cell.getValueOffset(), cell.getValueLength() + cell.getValueOffset()));
                    ++rowCount;
                }
                scanner.close();
                logger.info("Scanned " + rowCount + " rows, the (meaningless) hash for the scan is " + hash);
            }
            table.close();
            conn.close();
        }
    }

    private static long getFirstKeyTime(HTableInterface table) throws IOException {
        long startTime = 0L;
        Scan scan = new Scan();
        scan.addFamily(CF);
        ResultScanner scanner = table.getScanner(scan);
        Iterator i$ = scanner.iterator();
        if (i$.hasNext()) {
            Result result = (Result)i$.next();
            Cell cell = result.getColumnLatestCell(CF, QN);
            byte[] key = cell.getRowArray();
            startTime = Bytes.toLong((byte[])key, (int)cell.getRowOffset(), (int)8);
            logger.info("Retrieved first record time: " + HbaseStreamingInput.formatTime(startTime));
        }
        scanner.close();
        return startTime;
    }

    private static HConnection getConnection() throws IOException {
        return HConnectionManager.createConnection((Configuration)HBaseConnection.getCurrentHBaseConfiguration());
    }

    private static String formatTime(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return dateFormat.format(cal.getTime());
    }

    private static byte[] randomBytes(int lenth) {
        byte[] bytes = new byte[lenth];
        Random rand = new Random();
        rand.nextBytes(bytes);
        return bytes;
    }

    public static void main(String[] args) throws Exception {
        if (args[0].equalsIgnoreCase("createtable")) {
            HbaseStreamingInput.createTable(args[1]);
        } else if (args[0].equalsIgnoreCase("adddata")) {
            HbaseStreamingInput.addData(args[1]);
        } else if (args[0].equalsIgnoreCase("randomscan")) {
            HbaseStreamingInput.randomScan(args[1]);
        }
    }
}

