/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.kylin.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRegionSizeCalculator {
    private static final Logger logger = LoggerFactory.getLogger(HBaseRegionSizeCalculator.class);
    private final Map<byte[], Long> sizeMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Pair<Integer, Integer>> countMap = new TreeMap<byte[], Pair<Integer, Integer>>(Bytes.BYTES_COMPARATOR);
    static final String ENABLE_REGIONSIZECALCULATOR = "hbase.regionsizecalculator.enable";

    public HBaseRegionSizeCalculator(HTable table) throws IOException {
        this(table, new HBaseAdmin(table.getConfiguration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HBaseRegionSizeCalculator(HTable table, HBaseAdmin hBaseAdmin) throws IOException {
        try {
            if (!this.enabled(table.getConfiguration())) {
                logger.info("Region size calculation disabled.");
                return;
            }
            logger.info("Calculating region sizes for table \"" + new String(table.getTableName()) + "\".");
            Set tableRegionInfos = table.getRegionLocations().keySet();
            TreeSet<byte[]> tableRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (HRegionInfo regionInfo : tableRegionInfos) {
                tableRegions.add(regionInfo.getRegionName());
            }
            ClusterStatus clusterStatus = hBaseAdmin.getClusterStatus();
            Collection servers = clusterStatus.getServers();
            long megaByte = 0x100000L;
            for (ServerName serverName : servers) {
                ServerLoad serverLoad = clusterStatus.getLoad(serverName);
                for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                    byte[] regionId = regionLoad.getName();
                    if (!tableRegions.contains(regionId)) continue;
                    long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                    this.sizeMap.put(regionId, regionSizeBytes);
                    this.countMap.put(regionId, (Pair<Integer, Integer>)new Pair((Object)regionLoad.getStores(), (Object)regionLoad.getStorefiles()));
                }
            }
        }
        finally {
            hBaseAdmin.close();
        }
    }

    boolean enabled(Configuration configuration) {
        return configuration.getBoolean(ENABLE_REGIONSIZECALCULATOR, true);
    }

    public long getRegionSize(byte[] regionId) {
        Long size = this.sizeMap.get(regionId);
        if (size == null) {
            logger.info("Unknown region:" + Arrays.toString(regionId));
            return 0L;
        }
        return size;
    }

    public Map<byte[], Long> getRegionSizeMap() {
        return Collections.unmodifiableMap(this.sizeMap);
    }

    public Map<byte[], Pair<Integer, Integer>> getRegionHFileCountMap() {
        return Collections.unmodifiableMap(this.countMap);
    }
}

