/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseClean
extends AbstractApplication {
    private static final Option OPTION_DELETE;
    private static final Option OPTION_TAG;
    protected static final Logger logger;
    boolean delete = false;
    String tag = null;

    private void cleanUp() {
        try {
            Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
            HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
            String tableNamePrefix = "KYLIN_";
            HTableDescriptor[] tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*");
            ArrayList allTablesNeedToBeDropped = Lists.newArrayList();
            for (HTableDescriptor desc : tableDescriptors) {
                String host = desc.getValue("KYLIN_HOST");
                if (!this.tag.equalsIgnoreCase(host)) continue;
                allTablesNeedToBeDropped.add(desc.getTableName().getNameAsString());
            }
            if (this.delete) {
                for (String htableName : allTablesNeedToBeDropped) {
                    logger.info("Deleting HBase table " + htableName);
                    if (hbaseAdmin.tableExists(htableName)) {
                        if (hbaseAdmin.isTableEnabled(htableName)) {
                            hbaseAdmin.disableTable(htableName);
                        }
                        hbaseAdmin.deleteTable(htableName);
                        logger.info("Deleted HBase table " + htableName);
                        continue;
                    }
                    logger.info("HBase table" + htableName + " does not exist");
                }
            } else {
                System.out.println("--------------- Tables To Be Dropped ---------------");
                for (String htableName : allTablesNeedToBeDropped) {
                    System.out.println(htableName);
                }
                System.out.println("----------------------------------------------------");
            }
            hbaseAdmin.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        HBaseClean cli = new HBaseClean();
        cli.execute(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_TAG);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.tag = optionsHelper.getOptionValue(OPTION_TAG);
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        this.cleanUp();
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"actually delete or not");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"tag");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"the tag of HTable");
        OPTION_TAG = OptionBuilder.create((String)"tag");
        logger = LoggerFactory.getLogger(HBaseClean.class);
    }
}

