/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.MeasureDecoder;
import org.apache.kylin.storage.hbase.steps.KeyValueCreator;

public class CubeHFileMapper
extends KylinMapper<Text, Text, ImmutableBytesWritable, KeyValue> {
    ImmutableBytesWritable outputKey = new ImmutableBytesWritable();
    String cubeName;
    CubeDesc cubeDesc;
    MeasureDecoder inputCodec;
    Object[] inputMeasures;
    List<KeyValueCreator> keyValueCreators;

    protected void setup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)config);
        this.cubeDesc = cubeMgr.getCube(this.cubeName).getDescriptor();
        this.inputCodec = new MeasureDecoder((Collection)this.cubeDesc.getMeasures());
        this.inputMeasures = new Object[this.cubeDesc.getMeasures().size()];
        this.keyValueCreators = Lists.newArrayList();
        for (HBaseColumnFamilyDesc cfDesc : this.cubeDesc.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc colDesc : cfDesc.getColumns()) {
                this.keyValueCreators.add(new KeyValueCreator(this.cubeDesc, colDesc));
            }
        }
    }

    public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.outputKey.set(key.getBytes(), 0, key.getLength());
        int n = this.keyValueCreators.size();
        if (n == 1 && this.keyValueCreators.get((int)0).isFullCopy) {
            KeyValue outputValue = this.keyValueCreators.get(0).create(key, value.getBytes(), 0, value.getLength());
            context.write((Object)this.outputKey, (Object)outputValue);
        } else {
            this.inputCodec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), this.inputMeasures);
            for (int i = 0; i < n; ++i) {
                KeyValue outputValue = this.keyValueCreators.get(i).create(key, this.inputMeasures);
                context.write((Object)this.outputKey, (Object)outputValue);
            }
        }
    }
}

