/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.storage.gtrecord.SortedIteratorMergerWithLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GTBlobScatter
implements IGTScanner {
    private static final Logger logger = LoggerFactory.getLogger(GTBlobScatter.class);
    private GTInfo info;
    private Iterator<byte[]> blocks;
    private ImmutableBitSet columns;
    private long totalScannedCount;
    private int storagePushDownLimit = -1;

    public GTBlobScatter(GTInfo info, Iterator<byte[]> blocks, ImmutableBitSet columns, long totalScannedCount, int storagePushDownLimit) {
        this.info = info;
        this.blocks = blocks;
        this.columns = columns;
        this.totalScannedCount = totalScannedCount;
        this.storagePushDownLimit = storagePushDownLimit;
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public long getScannedRowCount() {
        return this.totalScannedCount;
    }

    public void close() throws IOException {
    }

    public Iterator<GTRecord> iterator() {
        Iterator shardSubsets = Iterators.transform(this.blocks, (Function)new GTBlobScatterFunc());
        if (this.storagePushDownLimit <= KylinConfig.getInstanceFromEnv().getStoragePushDownLimitMax()) {
            return new SortedIteratorMergerWithLimit(shardSubsets, this.storagePushDownLimit, GTRecord.getPrimaryKeyComparator()).getIterator();
        }
        return Iterators.concat((Iterator)shardSubsets);
    }

    class GTBlobScatterFunc
    implements Function<byte[], Iterator<GTRecord>> {
        GTBlobScatterFunc() {
        }

        @Nullable
        public Iterator<GTRecord> apply(final @Nullable byte[] input) {
            return new Iterator<GTRecord>(){
                private ByteBuffer inputBuffer = null;
                private GTRecord firstRecord = null;
                private GTRecord secondRecord = null;
                private GTRecord thirdRecord = null;
                private GTRecord fourthRecord = null;
                private int counter = 0;

                @Override
                public boolean hasNext() {
                    if (this.inputBuffer == null) {
                        this.inputBuffer = ByteBuffer.wrap(input);
                        this.firstRecord = new GTRecord(GTBlobScatter.this.info);
                        this.secondRecord = new GTRecord(GTBlobScatter.this.info);
                        this.thirdRecord = new GTRecord(GTBlobScatter.this.info);
                        this.fourthRecord = new GTRecord(GTBlobScatter.this.info);
                    }
                    return this.inputBuffer.position() < this.inputBuffer.limit();
                }

                @Override
                public GTRecord next() {
                    this.firstRecord.loadColumns(GTBlobScatter.this.columns, this.inputBuffer);
                    return this.firstRecord;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

