/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.ISegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.cube.v2.CellListIterator;
import org.apache.kylin.storage.hbase.cube.v2.CubeHBaseRPC;
import org.apache.kylin.storage.hbase.cube.v2.HBaseReadonlyStore;
import org.apache.kylin.storage.hbase.cube.v2.RawScan;
import org.apache.kylin.storage.hbase.cube.v2.filter.MassInValueProviderFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeHBaseScanRPC
extends CubeHBaseRPC {
    public static final Logger logger = LoggerFactory.getLogger(CubeHBaseScanRPC.class);

    public CubeHBaseScanRPC(ISegment segment, Cuboid cuboid, final GTInfo fullGTInfo) {
        super(segment, cuboid, fullGTInfo);
        MassInTupleFilter.VALUE_PROVIDER_FACTORY = new MassInValueProviderFactoryImpl(new MassInValueProviderFactoryImpl.DimEncAware(){

            @Override
            public DimensionEncoding getDimEnc(TblColRef col) {
                return fullGTInfo.getCodeSystem().getDimEnc(col.getColumnDesc().getZeroBasedIndex());
            }
        });
    }

    public IGTScanner getGTScanner(GTScanRequest scanRequest) throws IOException {
        final IGTScanner scanner = this.getGTScannerInternal(scanRequest);
        return new IGTScanner(){

            public GTInfo getInfo() {
                return scanner.getInfo();
            }

            public long getScannedRowCount() {
                long sum = 0L;
                return sum += scanner.getScannedRowCount();
            }

            public void close() throws IOException {
                scanner.close();
            }

            public Iterator<GTRecord> iterator() {
                return scanner.iterator();
            }
        };
    }

    private List<byte[]> getRowKeysDifferentShards(byte[] halfCookedKey) {
        short cuboidShardNum = this.cubeSeg.getCuboidShardNum(Long.valueOf(this.cuboid.getId()));
        if (!this.cubeSeg.isEnableSharding()) {
            return Lists.newArrayList((Object[])new byte[][]{halfCookedKey});
        }
        ArrayList ret = Lists.newArrayList();
        for (short i = 0; i < cuboidShardNum; i = (short)(i + 1)) {
            short shard = ShardingHash.normalize((short)this.cubeSeg.getCuboidBaseShard(Long.valueOf(this.cuboid.getId())), (short)i, (int)this.cubeSeg.getTotalShards(this.cuboid.getId()));
            byte[] cookedKey = Arrays.copyOf(halfCookedKey, halfCookedKey.length);
            BytesUtil.writeShort((short)shard, (byte[])cookedKey, (int)0, (int)2);
            ret.add(cookedKey);
        }
        return ret;
    }

    private List<RawScan> spawnRawScansForAllShards(RawScan rawScan) {
        ArrayList ret = Lists.newArrayList();
        List<byte[]> startKeys = this.getRowKeysDifferentShards(rawScan.startKey);
        List<byte[]> endKeys = this.getRowKeysDifferentShards(rawScan.endKey);
        for (int i = 0; i < startKeys.size(); ++i) {
            RawScan temp = new RawScan(rawScan);
            temp.startKey = startKeys.get(i);
            temp.endKey = endKeys.get(i);
            ret.add(temp);
        }
        return ret;
    }

    private IGTScanner getGTScannerInternal(GTScanRequest scanRequest) throws IOException {
        ImmutableBitSet selectedColBlocks = scanRequest.getSelectedColBlocks().set(0);
        HConnection hbaseConn = HBaseConnection.get(this.cubeSeg.getCubeInstance().getConfig().getStorageUrl());
        final HTableInterface hbaseTable = hbaseConn.getTable(this.cubeSeg.getStorageLocationIdentifier());
        List<RawScan> rawScans = this.preparedHBaseScans(scanRequest.getGTScanRanges(), selectedColBlocks);
        List<List<Integer>> hbaseColumnsToGT = this.getHBaseColumnsGTMapping(selectedColBlocks);
        final ArrayList scanners = Lists.newArrayList();
        ArrayList resultIterators = Lists.newArrayList();
        for (RawScan rawScan : rawScans) {
            for (RawScan rawScanWithShard : this.spawnRawScansForAllShards(rawScan)) {
                this.logScan(rawScanWithShard, this.cubeSeg.getStorageLocationIdentifier());
                Scan hbaseScan = CubeHBaseScanRPC.buildScan(rawScanWithShard);
                ResultScanner scanner = hbaseTable.getScanner(hbaseScan);
                Iterator iterator = scanner.iterator();
                scanners.add(scanner);
                resultIterators.add(iterator);
            }
        }
        final Iterator allResultsIterator = Iterators.concat(resultIterators.iterator());
        CellListIterator cellListIterator = new CellListIterator(){

            @Override
            public void close() throws IOException {
                for (ResultScanner scanner : scanners) {
                    scanner.close();
                }
                hbaseTable.close();
            }

            @Override
            public boolean hasNext() {
                return allResultsIterator.hasNext();
            }

            @Override
            public List<Cell> next() {
                return ((Result)allResultsIterator.next()).listCells();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        HBaseReadonlyStore store = new HBaseReadonlyStore(cellListIterator, scanRequest, rawScans.get((int)0).hbaseColumns, hbaseColumnsToGT, this.cubeSeg.getRowKeyPreambleSize(), false);
        IGTScanner rawScanner = store.scan(scanRequest);
        final IGTScanner decorateScanner = scanRequest.decorateScanner(rawScanner);
        final TrimmedInfoGTRecordAdapter trimmedInfoGTRecordAdapter = new TrimmedInfoGTRecordAdapter(this.fullGTInfo, decorateScanner.iterator());
        return new IGTScanner(){

            public GTInfo getInfo() {
                return CubeHBaseScanRPC.this.fullGTInfo;
            }

            public long getScannedRowCount() {
                return decorateScanner.getScannedRowCount();
            }

            public void close() throws IOException {
                decorateScanner.close();
            }

            public Iterator<GTRecord> iterator() {
                return trimmedInfoGTRecordAdapter.iterator();
            }
        };
    }

    static class TrimmedInfoGTRecordAdapter
    implements Iterable<GTRecord> {
        private final GTInfo info;
        private final Iterator<GTRecord> input;

        public TrimmedInfoGTRecordAdapter(GTInfo info, Iterator<GTRecord> input) {
            this.info = info;
            this.input = input;
        }

        @Override
        public Iterator<GTRecord> iterator() {
            return new Iterator<GTRecord>(){

                @Override
                public boolean hasNext() {
                    return TrimmedInfoGTRecordAdapter.this.input.hasNext();
                }

                @Override
                public GTRecord next() {
                    GTRecord x = (GTRecord)TrimmedInfoGTRecordAdapter.this.input.next();
                    return new GTRecord(TrimmedInfoGTRecordAdapter.this.info, x.getInternal());
                }

                @Override
                public void remove() {
                }
            };
        }
    }
}

