/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.gridtable.StorageSideBehavior;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorFilter;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorProjector;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;
import org.apache.kylin.storage.hbase.common.coprocessor.FilterDecorator;
import org.apache.kylin.storage.hbase.cube.v1.RegionScannerAdapter;
import org.apache.kylin.storage.hbase.cube.v1.ResultScannerAdapter;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.AggregationScanner;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregators;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverEnabler {
    private static final Logger logger = LoggerFactory.getLogger(ObserverEnabler.class);
    static final String FORCE_COPROCESSOR = "forceObserver";
    static final Map<String, Boolean> CUBE_OVERRIDES = Maps.newConcurrentMap();

    public static ResultScanner scanWithCoprocessorIfBeneficial(CubeSegment segment, Cuboid cuboid, TupleFilter tupleFiler, Collection<TblColRef> groupBy, Collection<RowValueDecoder> rowValueDecoders, StorageContext context, HTableInterface table, Scan scan) throws IOException {
        boolean localCoprocessor;
        if (!context.isCoprocessorEnabled()) {
            return table.getScanner(scan);
        }
        CoprocessorRowType type = CoprocessorRowType.fromCuboid(segment, cuboid);
        CoprocessorFilter filter = CoprocessorFilter.fromFilter((IDimensionEncodingMap)segment.getDimensionEncodingMap(), tupleFiler, FilterDecorator.FilterConstantsTreatment.REPLACE_WITH_GLOBAL_DICT);
        CoprocessorProjector projector = CoprocessorProjector.makeForObserver(segment, cuboid, groupBy);
        ObserverAggregators aggrs = ObserverAggregators.fromValueDecoders(rowValueDecoders);
        boolean bl = localCoprocessor = KylinConfig.getInstanceFromEnv().getQueryRunLocalCoprocessor() || BackdoorToggles.getRunLocalCoprocessor();
        if (localCoprocessor) {
            RegionScannerAdapter innerScanner = new RegionScannerAdapter(table.getScanner(scan));
            AggregationScanner aggrScanner = new AggregationScanner(type, filter, projector, aggrs, innerScanner, StorageSideBehavior.SCAN_FILTER_AGGR_CHECKMEM);
            return new ResultScannerAdapter(aggrScanner);
        }
        String toggle = BackdoorToggles.getCoprocessorBehavior();
        if (toggle == null) {
            toggle = StorageSideBehavior.SCAN_FILTER_AGGR_CHECKMEM.toString();
        } else {
            logger.info("The execution of this query will use " + toggle + " as observer's behavior");
        }
        scan.setAttribute("_Coprocessor_Enable", new byte[]{1});
        scan.setAttribute("_Behavior", toggle.getBytes());
        scan.setAttribute("_Type", CoprocessorRowType.serialize(type));
        scan.setAttribute("_Projector", CoprocessorProjector.serialize(projector));
        scan.setAttribute("_Aggregators", ObserverAggregators.serialize(aggrs));
        scan.setAttribute("_Filter", CoprocessorFilter.serialize(filter));
        return table.getScanner(scan);
    }

    public static void enableCoprocessorIfBeneficial(CubeInstance cube, Collection<TblColRef> groupBy, Collection<RowValueDecoder> rowValueDecoders, StorageContext context) {
        if (ObserverEnabler.isCoprocessorBeneficial(cube, groupBy, rowValueDecoders, context)) {
            context.enableCoprocessor();
        }
    }

    private static boolean isCoprocessorBeneficial(CubeInstance cube, Collection<TblColRef> groupBy, Collection<RowValueDecoder> rowValueDecoders, StorageContext context) {
        String forceFlag = System.getProperty(FORCE_COPROCESSOR);
        if (forceFlag != null) {
            boolean r = Boolean.parseBoolean(forceFlag);
            logger.info("Coprocessor is " + (r ? "enabled" : "disabled") + " according to sys prop " + FORCE_COPROCESSOR);
            return r;
        }
        Boolean cubeOverride = CUBE_OVERRIDES.get(cube.getName());
        if (cubeOverride != null) {
            boolean r = cubeOverride;
            logger.info("Coprocessor is " + (r ? "enabled" : "disabled") + " according to cube overrides");
            return r;
        }
        if (RowValueDecoder.hasMemHungryMeasures(rowValueDecoders)) {
            logger.info("Coprocessor is disabled because there is memory hungry count distinct");
            return false;
        }
        if (context.isExactAggregation()) {
            logger.info("Coprocessor is disabled because exactAggregation is true");
            return false;
        }
        Cuboid cuboid = context.getCuboid();
        HashSet toAggr = Sets.newHashSet((Iterable)cuboid.getAggregationColumns());
        toAggr.removeAll(groupBy);
        if (toAggr.isEmpty()) {
            logger.info("Coprocessor is disabled because no additional columns to aggregate");
            return false;
        }
        logger.info("Coprocessor is enabled to aggregate " + toAggr + ", returning " + groupBy);
        return true;
    }

    private static int getBitsToScan(byte[] startKey, byte[] stopKey) {
        int bitIdx;
        byte bitMask;
        int byteIdx;
        int totalBits;
        int bitsToScan = totalBits = startKey.length * 8;
        for (int i = 0; i < totalBits && (startKey[byteIdx = i / 8] & (bitMask = (byte)(1 << (bitIdx = 7 - i % 8)))) == (stopKey[byteIdx] & bitMask); ++i) {
            --bitsToScan;
        }
        return bitsToScan;
    }

    public static void forceCoprocessorOn() {
        System.setProperty(FORCE_COPROCESSOR, "true");
    }

    public static void forceCoprocessorOff() {
        System.setProperty(FORCE_COPROCESSOR, "false");
    }

    public static String getForceCoprocessor() {
        return System.getProperty(FORCE_COPROCESSOR);
    }

    public static void forceCoprocessorUnset() {
        System.clearProperty(FORCE_COPROCESSOR);
    }

    public static void updateCubeOverride(String cubeName, String force) {
        if ("null".equalsIgnoreCase(force) || "default".equalsIgnoreCase(force)) {
            CUBE_OVERRIDES.remove(cubeName);
        } else if ("true".equalsIgnoreCase(force)) {
            CUBE_OVERRIDES.put(cubeName, Boolean.TRUE);
        } else if ("false".equalsIgnoreCase(force)) {
            CUBE_OVERRIDES.put(cubeName, Boolean.FALSE);
        }
    }

    public static Map<String, Boolean> getCubeOverrides() {
        return CUBE_OVERRIDES;
    }
}

