/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.measure.BufferedMeasureEncoder;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;

public class ObserverAggregators {
    private static final BytesSerializer<ObserverAggregators> serializer = new BytesSerializer<ObserverAggregators>(){

        public void serialize(ObserverAggregators value, ByteBuffer out) {
            BytesUtil.writeVInt((int)value.nHCols, (ByteBuffer)out);
            for (int i = 0; i < value.nHCols; ++i) {
                HCol col = value.hcols[i];
                BytesUtil.writeByteArray((byte[])col.family, (ByteBuffer)out);
                BytesUtil.writeByteArray((byte[])col.qualifier, (ByteBuffer)out);
                BytesUtil.writeAsciiStringArray((String[])col.funcNames, (ByteBuffer)out);
                BytesUtil.writeAsciiStringArray((String[])col.dataTypes, (ByteBuffer)out);
            }
        }

        public ObserverAggregators deserialize(ByteBuffer in) {
            int nHCols = BytesUtil.readVInt((ByteBuffer)in);
            HCol[] hcols = new HCol[nHCols];
            for (int i = 0; i < nHCols; ++i) {
                byte[] family = BytesUtil.readByteArray((ByteBuffer)in);
                byte[] qualifier = BytesUtil.readByteArray((ByteBuffer)in);
                String[] funcNames = BytesUtil.readAsciiStringArray((ByteBuffer)in);
                String[] dataTypes = BytesUtil.readAsciiStringArray((ByteBuffer)in);
                hcols[i] = new HCol(family, qualifier, funcNames, dataTypes);
            }
            return new ObserverAggregators(hcols);
        }
    };
    final HCol[] hcols;
    final int nHCols;
    final ByteBuffer[] hColValues;
    final int nTotalMeasures;
    MeasureType[] measureTypes;

    public static ObserverAggregators fromValueDecoders(Collection<RowValueDecoder> rowValueDecoders) {
        HCol[] hcols = new HCol[rowValueDecoders.size()];
        int i = 0;
        for (RowValueDecoder rowValueDecoder : rowValueDecoders) {
            hcols[i++] = ObserverAggregators.buildHCol(rowValueDecoder.getHBaseColumn());
        }
        ObserverAggregators aggrs = new ObserverAggregators(hcols);
        return aggrs;
    }

    private static HCol buildHCol(HBaseColumnDesc desc) {
        byte[] family = Bytes.toBytes((String)desc.getColumnFamilyName());
        byte[] qualifier = Bytes.toBytes((String)desc.getQualifier());
        MeasureDesc[] measures = desc.getMeasures();
        String[] funcNames = new String[measures.length];
        String[] dataTypes = new String[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            funcNames[i] = measures[i].getFunction().getExpression();
            dataTypes[i] = measures[i].getFunction().getReturnType();
        }
        return new HCol(family, qualifier, funcNames, dataTypes);
    }

    public static byte[] serialize(ObserverAggregators o) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        serializer.serialize((Object)o, buf);
        byte[] result = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, result, 0, buf.position());
        return result;
    }

    public static ObserverAggregators deserialize(byte[] bytes) {
        return (ObserverAggregators)serializer.deserialize(ByteBuffer.wrap(bytes));
    }

    public ObserverAggregators(HCol[] _hcols) {
        this.hcols = this.sort(_hcols);
        this.nHCols = this.hcols.length;
        this.hColValues = new ByteBuffer[this.nHCols];
        int nTotalMeasures = 0;
        for (HCol col : this.hcols) {
            nTotalMeasures += col.nMeasures;
        }
        this.nTotalMeasures = nTotalMeasures;
    }

    private HCol[] sort(HCol[] hcols) {
        HCol[] copy = Arrays.copyOf(hcols, hcols.length);
        Arrays.sort(copy, new Comparator<HCol>(){

            @Override
            public int compare(HCol o1, HCol o2) {
                int comp = Bytes.compareTo((byte[])o1.family, (byte[])o2.family);
                if (comp != 0) {
                    return comp;
                }
                comp = Bytes.compareTo((byte[])o1.qualifier, (byte[])o2.qualifier);
                return comp;
            }
        });
        return copy;
    }

    public MeasureAggregator[] createBuffer() {
        if (this.measureTypes == null) {
            this.measureTypes = new MeasureType[this.nTotalMeasures];
            int i = 0;
            for (HCol col : this.hcols) {
                for (int j = 0; j < col.nMeasures; ++j) {
                    this.measureTypes[i++] = MeasureTypeFactory.create((String)col.funcNames[j], (DataType)DataType.getType((String)col.dataTypes[j]));
                }
            }
        }
        MeasureAggregator[] aggrs = new MeasureAggregator[this.nTotalMeasures];
        for (int i = 0; i < this.nTotalMeasures; ++i) {
            aggrs[i] = this.measureTypes[i].newAggregator();
        }
        return aggrs;
    }

    public void aggregate(MeasureAggregator[] measureAggrs, List<Cell> rowCells) {
        int i = 0;
        for (int ci = 0; ci < this.nHCols; ++ci) {
            HCol col = this.hcols[ci];
            Cell cell = this.findCell(col, rowCells);
            if (cell == null) {
                i += col.nMeasures;
                continue;
            }
            ByteBuffer input = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            col.measureCodec.decode(input, col.measureValues);
            for (int j = 0; j < col.nMeasures; ++j) {
                measureAggrs[i++].aggregate(col.measureValues[j]);
            }
        }
    }

    private Cell findCell(HCol col, List<Cell> cells) {
        for (int i = cells.size() - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            if (!ObserverAggregators.match(col, cell)) continue;
            return cell;
        }
        return null;
    }

    public static boolean match(HCol col, Cell cell) {
        return Bytes.compareTo((byte[])col.family, (int)0, (int)col.family.length, (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()) == 0 && Bytes.compareTo((byte[])col.qualifier, (int)0, (int)col.qualifier.length, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) == 0;
    }

    public int getHColsNum() {
        return this.nHCols;
    }

    public byte[][] getHColFamilies() {
        byte[][] result = new byte[this.nHCols][];
        for (int i = 0; i < this.nHCols; ++i) {
            result[i] = this.hcols[i].family;
        }
        return result;
    }

    public byte[][] getHColQualifiers() {
        byte[][] result = new byte[this.nHCols][];
        for (int i = 0; i < this.nHCols; ++i) {
            result[i] = this.hcols[i].qualifier;
        }
        return result;
    }

    public ByteBuffer[] getHColValues(MeasureAggregator[] aggrs) {
        int i = 0;
        for (int ci = 0; ci < this.nHCols; ++ci) {
            HCol col = this.hcols[ci];
            for (int j = 0; j < col.nMeasures; ++j) {
                col.measureValues[j] = aggrs[i++].getState();
            }
            this.hColValues[ci] = col.measureCodec.encode(col.measureValues);
        }
        return this.hColValues;
    }

    public static class HCol {
        final byte[] family;
        final byte[] qualifier;
        final String[] funcNames;
        final String[] dataTypes;
        final int nMeasures;
        final BufferedMeasureEncoder measureCodec;
        final Object[] measureValues;

        public HCol(byte[] bFamily, byte[] bQualifier, String[] funcNames, String[] dataTypes) {
            this.family = bFamily;
            this.qualifier = bQualifier;
            this.funcNames = funcNames;
            this.dataTypes = dataTypes;
            this.nMeasures = funcNames.length;
            assert (funcNames.length == dataTypes.length);
            this.measureCodec = new BufferedMeasureEncoder(dataTypes);
            this.measureValues = new Object[this.nMeasures];
        }

        public String toString() {
            return "HCol [bFamily=" + Bytes.toString((byte[])this.family) + ", bQualifier=" + Bytes.toString((byte[])this.qualifier) + ", nMeasures=" + this.nMeasures + "]";
        }
    }
}

